/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ca;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.port.DbPortWorker;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.ca.dbtool.port.ca.CaCertstoreDbImporter;
import org.xipki.ca.dbtool.port.ca.CaconfDbImporter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class CaDbImportWorker
extends DbPortWorker {
    private static final Logger LOG = LoggerFactory.getLogger(CaDbImportWorker.class);
    private final DataSourceWrapper datasource;
    private final boolean resume;
    private final String srcFolder;
    private final int batchEntriesPerCommit;

    public CaDbImportWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, boolean resume, String srcFolder, int batchEntriesPerCommit) throws PasswordResolverException, IOException {
        ParamUtil.requireNonNull((String)"datasourceFactory", (Object)datasourceFactory);
        Properties props = DbPorter.getDbConfProperties(new FileInputStream(IoUtil.expandFilepath((String)dbConfFile)));
        this.datasource = datasourceFactory.createDataSource("ds-" + dbConfFile, props, passwordResolver);
        this.resume = resume;
        this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
        this.batchEntriesPerCommit = batchEntriesPerCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run0() throws Exception {
        File processLogFile = new File(this.srcFolder, "import.process");
        if (this.resume) {
            if (!processLogFile.exists()) {
                throw new Exception("could not process with '--resume' option");
            }
        } else if (processLogFile.exists()) {
            throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
        }
        long start = System.currentTimeMillis();
        try {
            if (!this.resume) {
                CaconfDbImporter caConfImporter = new CaconfDbImporter(this.datasource, this.srcFolder, this.stopMe);
                caConfImporter.importToDb();
                caConfImporter.shutdown();
            }
            CaCertstoreDbImporter certStoreImporter = new CaCertstoreDbImporter(this.datasource, this.srcFolder, this.batchEntriesPerCommit, this.resume, this.stopMe);
            certStoreImporter.importToDb();
            certStoreImporter.shutdown();
        }
        finally {
            try {
                this.datasource.close();
            }
            catch (Throwable th) {
                LOG.error("datasource.close()", th);
            }
            long end = System.currentTimeMillis();
            System.out.println("Finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
        }
    }
}

