/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ca;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.xipki.ca.dbtool.jaxb.ca.CaHasProfileType;
import org.xipki.ca.dbtool.jaxb.ca.CaHasPublisherType;
import org.xipki.ca.dbtool.jaxb.ca.CaHasRequestorType;
import org.xipki.ca.dbtool.jaxb.ca.CaHasUserType;
import org.xipki.ca.dbtool.jaxb.ca.CaType;
import org.xipki.ca.dbtool.jaxb.ca.CaaliasType;
import org.xipki.ca.dbtool.jaxb.ca.CaconfType;
import org.xipki.ca.dbtool.jaxb.ca.ObjectFactory;
import org.xipki.ca.dbtool.jaxb.ca.ProfileType;
import org.xipki.ca.dbtool.jaxb.ca.PublisherType;
import org.xipki.ca.dbtool.jaxb.ca.RequestorType;
import org.xipki.ca.dbtool.jaxb.ca.SignerType;
import org.xipki.ca.dbtool.jaxb.ca.UserType;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.XmlUtil;

class CaconfDbExporter
extends DbPorter {
    private Marshaller marshaller;

    CaconfDbExporter(DataSourceWrapper datasource, String destDir, AtomicBoolean stopMe) throws DataAccessException, JAXBException {
        super(datasource, destDir, stopMe);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        this.marshaller = jaxbContext.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        this.marshaller.setSchema(DbPorter.retrieveSchema("/xsd/dbi-ca.xsd"));
    }

    public void export() throws Exception {
        CaconfType caconf = new CaconfType();
        caconf.setVersion(1);
        System.out.println("exporting CA configuration from database");
        this.exportSigner(caconf);
        this.exportRequestor(caconf);
        this.exportUser(caconf);
        this.exportPublisher(caconf);
        this.exportCa(caconf);
        this.exportProfile(caconf);
        this.exportCaalias(caconf);
        this.exportCaHasRequestor(caconf);
        this.exportCaHasUser(caconf);
        this.exportCaHasPublisher(caconf);
        this.exportCaHasProfile(caconf);
        JAXBElement<CaconfType> root = new ObjectFactory().createCaconf(caconf);
        try {
            this.marshaller.marshal(root, new File(this.baseDir, "ca-configuration.xml"));
        }
        catch (JAXBException ex) {
            throw XmlUtil.convert((JAXBException)ex);
        }
        System.out.println(" exported CA configuration from database");
    }

    private void exportCaalias(CaconfType caconf) throws DataAccessException {
        System.out.println("exporting table CAALIAS");
        CaconfType.Caaliases caaliases = new CaconfType.Caaliases();
        String sql = "SELECT NAME,CA_ID FROM CAALIAS";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT NAME,CA_ID FROM CAALIAS");
            while (rs.next()) {
                CaaliasType caalias = new CaaliasType();
                caalias.setName(rs.getString("NAME"));
                caalias.setCaId(rs.getInt("CA_ID"));
                caaliases.getCaalias().add(caalias);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,CA_ID FROM CAALIAS", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaaliases(caaliases);
        System.out.println(" exported table CAALIAS");
    }

    private void exportRequestor(CaconfType caconf) throws DataAccessException, IOException {
        System.out.println("exporting table REQUESTOR");
        CaconfType.Requestors requestors = new CaconfType.Requestors();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM REQUESTOR";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,NAME,TYPE,CONF FROM REQUESTOR");
            while (rs.next()) {
                String name = rs.getString("NAME");
                RequestorType requestor = new RequestorType();
                requestor.setId(rs.getInt("ID"));
                requestor.setName(name);
                requestor.setType(rs.getString("TYPE"));
                requestor.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/cert-requestor-" + name + ".conf"));
                requestors.getRequestor().add(requestor);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM REQUESTOR", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setRequestors(requestors);
        System.out.println(" exported table REQUESTOR");
    }

    private void exportUser(CaconfType caconf) throws DataAccessException, IOException {
        System.out.println("exporting table TUSER");
        CaconfType.Users users = new CaconfType.Users();
        String sql = "SELECT ID,NAME,ACTIVE,PASSWORD FROM TUSER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,NAME,ACTIVE,PASSWORD FROM TUSER");
            while (rs.next()) {
                UserType user = new UserType();
                user.setId(rs.getInt("ID"));
                user.setName(rs.getString("NAME"));
                user.setActive(rs.getInt("ACTIVE"));
                user.setPassword(rs.getString("PASSWORD"));
                users.getUser().add(user);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,ACTIVE,PASSWORD FROM TUSER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setUsers(users);
        System.out.println(" exported table TUSER");
    }

    private void exportSigner(CaconfType caconf) throws DataAccessException, IOException {
        System.out.println("exporting table SIGNER");
        CaconfType.Signers signers = new CaconfType.Signers();
        String sql = "SELECT NAME,TYPE,CONF,CERT FROM SIGNER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT NAME,TYPE,CONF,CERT FROM SIGNER");
            while (rs.next()) {
                String name = rs.getString("NAME");
                SignerType signer = new SignerType();
                signer.setName(name);
                signer.setType(rs.getString("TYPE"));
                signer.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-signer-" + name));
                signer.setCert(this.buildFileOrBase64Binary(rs.getString("CERT"), "ca-conf/cert-signer-" + name + ".der"));
                signers.getSigner().add(signer);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,TYPE,CONF,CERT FROM SIGNER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setSigners(signers);
        System.out.println(" exported table SIGNER");
    }

    private void exportPublisher(CaconfType caconf) throws DataAccessException, IOException {
        System.out.println("exporting table PUBLISHER");
        CaconfType.Publishers publishers = new CaconfType.Publishers();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM PUBLISHER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,NAME,TYPE,CONF FROM PUBLISHER");
            while (rs.next()) {
                String name = rs.getString("NAME");
                PublisherType publisher = new PublisherType();
                publisher.setId(rs.getInt("ID"));
                publisher.setName(name);
                publisher.setType(rs.getString("TYPE"));
                publisher.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-publisher-" + name));
                publishers.getPublisher().add(publisher);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM PUBLISHER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setPublishers(publishers);
        System.out.println(" exported table PUBLISHER");
    }

    private void exportProfile(CaconfType caconf) throws DataAccessException, IOException {
        System.out.println("exporting table PROFILE");
        CaconfType.Profiles profiles = new CaconfType.Profiles();
        String sql = "SELECT ID,NAME,TYPE,CONF FROM PROFILE";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,NAME,TYPE,CONF FROM PROFILE");
            while (rs.next()) {
                String name = rs.getString("NAME");
                ProfileType profile = new ProfileType();
                profile.setId(rs.getInt("ID"));
                profile.setName(name);
                profile.setType(rs.getString("TYPE"));
                profile.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/certprofile-" + name));
                profiles.getProfile().add(profile);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM PROFILE", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setProfiles(profiles);
        System.out.println(" exported table PROFILE");
    }

    private void exportCa(CaconfType caconf) throws DataAccessException, IOException {
        System.out.println("exporting table CA");
        CaconfType.Cas cas = new CaconfType.Cas();
        String sql = "SELECT ID,NAME,SN_SIZE,STATUS,CA_URIS,MAX_VALIDITY,CERT,SIGNER_TYPE,SIGNER_CONF,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,KEEP_EXPIRED_CERT_DAYS,REV_INFO,DUPLICATE_KEY,DUPLICATE_SUBJECT,PROTOCOL_SUPPORT,SAVE_REQ,VALIDITY_MODE,NEXT_CRLNO,CMP_RESPONDER_NAME,SCEP_RESPONDER_NAME,CRL_SIGNER_NAME,CMP_CONTROL,SCEP_CONTROL,CRL_CONTROL,EXTRA_CONTROL FROM CA";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaType ca = new CaType();
                ca.setId(rs.getInt("ID"));
                ca.setName(name);
                ca.setSnSize(rs.getInt("SN_SIZE"));
                ca.setNextCrlNo(rs.getLong("NEXT_CRLNO"));
                ca.setStatus(rs.getString("STATUS"));
                ca.setCaUris(rs.getString("CA_URIS"));
                ca.setMaxValidity(rs.getString("MAX_VALIDITY"));
                ca.setCert(this.buildFileOrBase64Binary(rs.getString("CERT"), "ca-conf/cert-ca-" + name + ".der"));
                ca.setSignerType(rs.getString("SIGNER_TYPE"));
                ca.setSignerConf(this.buildFileOrValue(rs.getString("SIGNER_CONF"), "ca-conf/signerconf-ca-" + name));
                ca.setCmpResponderName(rs.getString("CMP_RESPONDER_NAME"));
                ca.setScepResponderName(rs.getString("SCEP_RESPONDER_NAME"));
                ca.setCrlSignerName(rs.getString("CRL_SIGNER_NAME"));
                ca.setCmpControl(rs.getString("CMP_CONTROL"));
                ca.setScepControl(rs.getString("SCEP_CONTROL"));
                ca.setCrlControl(rs.getString("CRL_CONTROL"));
                ca.setDuplicateKey(rs.getInt("DUPLICATE_KEY"));
                ca.setDuplicateSubject(rs.getInt("DUPLICATE_SUBJECT"));
                ca.setProtocolSupport(rs.getString("PROTOCOL_SUPPORT"));
                ca.setSaveReq(rs.getInt("SAVE_REQ"));
                ca.setPermission(rs.getInt("PERMISSION"));
                ca.setExpirationPeriod(rs.getInt("EXPIRATION_PERIOD"));
                ca.setKeepExpiredCertDays(rs.getInt("KEEP_EXPIRED_CERT_DAYS"));
                ca.setValidityMode(rs.getString("VALIDITY_MODE"));
                ca.setExtraControl(rs.getString("EXTRA_CONTROL"));
                ca.setNumCrls(rs.getInt("NUM_CRLS"));
                ca.setRevInfo(rs.getString("REV_INFO"));
                cas.getCa().add(ca);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCas(cas);
        System.out.println(" exported table CA");
    }

    private void exportCaHasRequestor(CaconfType caconf) throws DataAccessException {
        System.out.println("exporting table CA_HAS_REQUESTOR");
        CaconfType.CaHasRequestors caHasRequestors = new CaconfType.CaHasRequestors();
        String sql = "SELECT CA_ID,REQUESTOR_ID,RA,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT CA_ID,REQUESTOR_ID,RA,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR");
            while (rs.next()) {
                CaHasRequestorType caHasRequestor = new CaHasRequestorType();
                caHasRequestor.setCaId(rs.getInt("CA_ID"));
                caHasRequestor.setRequestorId(rs.getInt("REQUESTOR_ID"));
                caHasRequestor.setRa(rs.getBoolean("RA"));
                caHasRequestor.setPermission(rs.getInt("PERMISSION"));
                caHasRequestor.setProfiles(rs.getString("PROFILES"));
                caHasRequestors.getCaHasRequestor().add(caHasRequestor);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,REQUESTOR_ID,RA,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaHasRequestors(caHasRequestors);
        System.out.println(" exported table CA_HAS_REQUESTOR");
    }

    private void exportCaHasUser(CaconfType caconf) throws DataAccessException {
        System.out.println("exporting table CA_HAS_USER");
        CaconfType.CaHasUsers caHasUsers = new CaconfType.CaHasUsers();
        String sql = "SELECT ID,CA_ID,USER_ID,PERMISSION,PROFILES FROM CA_HAS_USER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,CA_ID,USER_ID,PERMISSION,PROFILES FROM CA_HAS_USER");
            while (rs.next()) {
                CaHasUserType caHasUser = new CaHasUserType();
                caHasUser.setId(rs.getInt("ID"));
                caHasUser.setCaId(rs.getInt("CA_ID"));
                caHasUser.setUserId(rs.getInt("USER_ID"));
                caHasUser.setPermission(rs.getInt("PERMISSION"));
                caHasUser.setProfiles(rs.getString("PROFILES"));
                caHasUsers.getCaHasUser().add(caHasUser);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,CA_ID,USER_ID,PERMISSION,PROFILES FROM CA_HAS_USER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaHasUsers(caHasUsers);
        System.out.println(" exported table CA_HAS_USER");
    }

    private void exportCaHasPublisher(CaconfType caconf) throws DataAccessException {
        System.out.println("exporting table CA_HAS_PUBLISHER");
        CaconfType.CaHasPublishers caHasPublishers = new CaconfType.CaHasPublishers();
        String sql = "SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER");
            while (rs.next()) {
                CaHasPublisherType caHasPublisher = new CaHasPublisherType();
                caHasPublisher.setCaId(rs.getInt("CA_ID"));
                caHasPublisher.setPublisherId(rs.getInt("PUBLISHER_ID"));
                caHasPublishers.getCaHasPublisher().add(caHasPublisher);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaHasPublishers(caHasPublishers);
        System.out.println(" exported table CA_HAS_PUBLISHER");
    }

    private void exportCaHasProfile(CaconfType caconf) throws DataAccessException {
        System.out.println("exporting table CA_HAS_PROFILE");
        CaconfType.CaHasProfiles caHasProfiles = new CaconfType.CaHasProfiles();
        String sql = "SELECT CA_ID,PROFILE_ID FROM CA_HAS_PROFILE";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT CA_ID,PROFILE_ID FROM CA_HAS_PROFILE");
            while (rs.next()) {
                CaHasProfileType caHasProfile = new CaHasProfileType();
                caHasProfile.setCaId(rs.getInt("CA_ID"));
                caHasProfile.setProfileId(rs.getInt("PROFILE_ID"));
                caHasProfiles.getCaHasProfile().add(caHasProfile);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,PROFILE_ID FROM CA_HAS_PROFILE", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        caconf.setCaHasProfiles(caHasProfiles);
        System.out.println(" exported table CA_HAS_PROFILE");
    }
}

