/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ocsp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.jaxb.ocsp.CertstoreType;
import org.xipki.ca.dbtool.jaxb.ocsp.IssuerType;
import org.xipki.ca.dbtool.jaxb.ocsp.ObjectFactory;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.ca.dbtool.xmlio.DbiXmlWriter;
import org.xipki.ca.dbtool.xmlio.ocsp.OcspCertType;
import org.xipki.ca.dbtool.xmlio.ocsp.OcspCertsWriter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.XmlUtil;

class OcspCertstoreDbExporter
extends DbPorter {
    public static final String PROCESS_LOG_FILENAME = "export.process";
    private static final Logger LOG = LoggerFactory.getLogger(OcspCertstoreDbExporter.class);
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;
    private final int numCertsInBundle;
    private final int numCertsPerSelect;
    private final boolean resume;

    OcspCertstoreDbExporter(DataSourceWrapper datasource, String baseDir, int numCertsInBundle, int numCertsPerSelect, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, baseDir, stopMe);
        File processLogFile;
        this.numCertsInBundle = ParamUtil.requireMin((String)"numCertsInBundle", (int)numCertsInBundle, (int)1);
        this.numCertsPerSelect = ParamUtil.requireMin((String)"numCertsPerSelect", (int)numCertsPerSelect, (int)1);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        this.marshaller = jaxbContext.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        Schema schema = DbPorter.retrieveSchema("/xsd/dbi-ocsp.xsd");
        this.marshaller.setSchema(schema);
        this.unmarshaller = jaxbContext.createUnmarshaller();
        this.unmarshaller.setSchema(schema);
        if (resume && !(processLogFile = new File(baseDir, PROCESS_LOG_FILENAME)).exists()) {
            throw new Exception("could not process with '--resume' option");
        }
        this.resume = resume;
    }

    public void export() throws Exception {
        CertstoreType certstore;
        if (this.resume) {
            try {
                JAXBElement root = (JAXBElement)this.unmarshaller.unmarshal(new File(this.baseDir, "ocsp-certstore.xml"));
                certstore = (CertstoreType)root.getValue();
            }
            catch (JAXBException ex) {
                throw XmlUtil.convert((JAXBException)ex);
            }
            if (certstore.getVersion() > 1) {
                throw new Exception("could not continue with Certstore greater than 1: " + certstore.getVersion());
            }
        } else {
            certstore = new CertstoreType();
            certstore.setVersion(1);
        }
        System.out.println("exporting OCSP certstore from database");
        if (!this.resume) {
            this.exportHashAlgo(certstore);
            this.exportIssuer(certstore);
        }
        File processLogFile = new File(this.baseDir, PROCESS_LOG_FILENAME);
        Exception exception = this.exportCert(certstore, processLogFile);
        JAXBElement<CertstoreType> root = new ObjectFactory().createCertstore(certstore);
        try {
            this.marshaller.marshal(root, new File(this.baseDir, "ocsp-certstore.xml"));
        }
        catch (JAXBException ex) {
            throw XmlUtil.convert((JAXBException)ex);
        }
        if (exception != null) {
            throw exception;
        }
        System.out.println(" exported OCSP certstore from database");
    }

    private void exportHashAlgo(CertstoreType certstore) throws DataAccessException {
        String certHashAlgoStr = this.dbSchemaInfo.getVariableValue("CERTHASH_ALGO");
        if (certHashAlgoStr == null) {
            throw new DataAccessException("CERTHASH_ALGO is not defined in table DBSCHEMA");
        }
        certstore.setCerthashAlgo(certHashAlgoStr);
    }

    private void exportIssuer(CertstoreType certstore) throws DataAccessException, IOException {
        System.out.println("exporting table ISSUER");
        CertstoreType.Issuers issuers = new CertstoreType.Issuers();
        certstore.setIssuers(issuers);
        String sql = "SELECT ID,CERT,REV_INFO FROM ISSUER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,CERT,REV_INFO FROM ISSUER");
            String issuerCertsDir = "issuer-conf";
            new File(issuerCertsDir).mkdirs();
            while (rs.next()) {
                int id = rs.getInt("ID");
                IssuerType issuer = new IssuerType();
                issuer.setId(id);
                String certFileName = issuerCertsDir + "/cert-issuer-" + id;
                IoUtil.save((File)new File(this.baseDir, certFileName), (byte[])rs.getString("CERT").getBytes("UTF-8"));
                issuer.setCertFile(certFileName);
                issuer.setRevInfo(rs.getString("REV_INFO"));
                issuers.getIssuer().add(issuer);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,CERT,REV_INFO FROM ISSUER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(" exported table ISSUER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception exportCert(CertstoreType certstore, File processLogFile) {
        new File(this.baseDir, DbPorter.OcspDbEntryType.CERT.getDirName()).mkdirs();
        FileOutputStream certsFileOs = null;
        try {
            certsFileOs = new FileOutputStream(new File(this.baseDir, DbPorter.OcspDbEntryType.CERT.getDirName() + ".mf"), true);
            this.exportCert0(certstore, processLogFile, certsFileOs);
            Exception exception = null;
            IoUtil.closeStream((OutputStream)certsFileOs);
            return exception;
        }
        catch (Exception ex) {
            OcspCertstoreDbExporter.deleteTmpFiles(this.baseDir, "tmp-certs-");
            System.err.println("\nexporting table CERT has been cancelled due to error,\nplease continue with the option '--resume'");
            LOG.error("Exception", (Throwable)ex);
            Exception exception = ex;
            return exception;
        }
        finally {
            IoUtil.closeStream(certsFileOs);
        }
    }

    private void exportCert0(CertstoreType certstore, File processLogFile, FileOutputStream certsFileOs) throws Exception {
        byte[] content;
        File certsDir = new File(this.baseDir, DbPorter.OcspDbEntryType.CERT.getDirName());
        Long minId = null;
        if (processLogFile.exists() && (content = IoUtil.read((File)processLogFile)) != null && content.length > 0) {
            Long l = minId = Long.valueOf(Long.parseLong(new String(content).trim()));
            Long l2 = minId = Long.valueOf(minId + 1L);
        }
        if (minId == null) {
            minId = this.min("CERT", "ID");
        }
        System.out.println("exporting table CERT from ID " + minId);
        String coreSql = "ID,SN,IID,LUPDATE,REV,RR,RT,RIT,NAFTER,NBEFORE,HASH,SUBJECT FROM CERT WHERE ID>=?";
        String certSql = this.datasource.buildSelectFirstSql(this.numCertsPerSelect, "ID ASC", "ID,SN,IID,LUPDATE,REV,RR,RT,RIT,NAFTER,NBEFORE,HASH,SUBJECT FROM CERT WHERE ID>=?");
        long maxId = this.max("CERT", "ID");
        int numProcessedBefore = certstore.getCountCerts();
        long total = this.count("CERT") - numProcessedBefore;
        ProcessLog processLog = new ProcessLog(total);
        PreparedStatement certPs = this.prepareStatement(certSql);
        int sum = 0;
        int numCertInCurrentFile = 0;
        OcspCertsWriter certsInCurrentFile = new OcspCertsWriter();
        File currentCertsZipFile = new File(this.baseDir, "tmp-certs-" + System.currentTimeMillis() + ".zip");
        ZipOutputStream currentCertsZip = OcspCertstoreDbExporter.getZipOutputStream(currentCertsZipFile);
        long minCertIdOfCurrentFile = -1L;
        long maxCertIdOfCurrentFile = -1L;
        processLog.printHeader();
        String sql = null;
        Long id = null;
        try {
            boolean interrupted = false;
            long lastMaxId = minId - 1L;
            while (true) {
                if (this.stopMe.get()) {
                    interrupted = true;
                    break;
                }
                sql = certSql;
                certPs.setLong(1, lastMaxId + 1L);
                ResultSet rs = certPs.executeQuery();
                if (!rs.next()) break;
                do {
                    long nbefore;
                    long nafter;
                    String subject;
                    String hash;
                    if (lastMaxId < (id = Long.valueOf(rs.getLong("ID")))) {
                        lastMaxId = id;
                    }
                    if (minCertIdOfCurrentFile == -1L) {
                        minCertIdOfCurrentFile = id;
                    } else if (minCertIdOfCurrentFile > id) {
                        minCertIdOfCurrentFile = id;
                    }
                    if (maxCertIdOfCurrentFile == -1L) {
                        maxCertIdOfCurrentFile = id;
                    } else if (maxCertIdOfCurrentFile < id) {
                        maxCertIdOfCurrentFile = id;
                    }
                    OcspCertType cert = new OcspCertType();
                    cert.setId(id);
                    cert.setIid(rs.getInt("IID"));
                    cert.setSn(rs.getString("SN"));
                    cert.setUpdate(rs.getLong("LUPDATE"));
                    boolean revoked = rs.getBoolean("REV");
                    cert.setRev(revoked);
                    if (revoked) {
                        cert.setRr(rs.getInt("RR"));
                        cert.setRt(rs.getLong("RT"));
                        long rit = rs.getLong("RIT");
                        if (rit != 0L) {
                            cert.setRit(rit);
                        }
                    }
                    if ((hash = rs.getString("HASH")) != null) {
                        cert.setHash(hash);
                    }
                    if ((subject = rs.getString("SUBJECT")) != null) {
                        cert.setSubject(subject);
                    }
                    if ((nafter = rs.getLong("NAFTER")) != 0L) {
                        cert.setNafter(nafter);
                    }
                    if ((nbefore = rs.getLong("NBEFORE")) != 0L) {
                        cert.setNbefore(nbefore);
                    }
                    certsInCurrentFile.add(cert);
                    ++sum;
                    if (++numCertInCurrentFile != this.numCertsInBundle) continue;
                    this.finalizeZip(currentCertsZip, certsInCurrentFile);
                    String currentCertsFilename = OcspCertstoreDbExporter.buildFilename("certs_", ".zip", minCertIdOfCurrentFile, maxCertIdOfCurrentFile, maxId);
                    currentCertsZipFile.renameTo(new File(certsDir, currentCertsFilename));
                    OcspCertstoreDbExporter.writeLine(certsFileOs, currentCertsFilename);
                    certstore.setCountCerts(numProcessedBefore + sum);
                    OcspCertstoreDbExporter.echoToFile(Long.toString(id), processLogFile);
                    processLog.addNumProcessed((long)numCertInCurrentFile);
                    processLog.printStatus();
                    certsInCurrentFile = new OcspCertsWriter();
                    numCertInCurrentFile = 0;
                    minCertIdOfCurrentFile = -1L;
                    maxCertIdOfCurrentFile = -1L;
                    currentCertsZipFile = new File(this.baseDir, "tmp-certs-" + System.currentTimeMillis() + ".zip");
                    currentCertsZip = OcspCertstoreDbExporter.getZipOutputStream(currentCertsZipFile);
                } while (rs.next());
                rs.close();
            }
            if (interrupted) {
                throw new InterruptedException("interrupted by the user");
            }
            if (numCertInCurrentFile > 0) {
                this.finalizeZip(currentCertsZip, certsInCurrentFile);
                String currentCertsFilename = OcspCertstoreDbExporter.buildFilename("certs_", ".zip", minCertIdOfCurrentFile, maxCertIdOfCurrentFile, maxId);
                currentCertsZipFile.renameTo(new File(certsDir, currentCertsFilename));
                OcspCertstoreDbExporter.writeLine(certsFileOs, currentCertsFilename);
                certstore.setCountCerts(numProcessedBefore + sum);
                if (id != null) {
                    OcspCertstoreDbExporter.echoToFile(Long.toString(id), processLogFile);
                }
                processLog.addNumProcessed((long)numCertInCurrentFile);
            } else {
                currentCertsZip.close();
                currentCertsZipFile.delete();
            }
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(certPs, null);
        }
        processLog.printTrailer();
        processLogFile.delete();
        System.out.println(" exported " + processLog.numProcessed() + " certificates from tables CERT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeZip(ZipOutputStream zipOutStream, DbiXmlWriter certsType) throws IOException, XMLStreamException {
        ZipEntry certZipEntry = new ZipEntry("certs.xml");
        zipOutStream.putNextEntry(certZipEntry);
        try {
            certsType.rewriteToZipStream(zipOutStream);
        }
        finally {
            zipOutStream.closeEntry();
        }
        zipOutStream.close();
    }
}

