/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ocsp;

import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.jaxb.ocsp.CertstoreType;
import org.xipki.ca.dbtool.jaxb.ocsp.IssuerType;
import org.xipki.ca.dbtool.jaxb.ocsp.ObjectFactory;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.ca.dbtool.port.ocsp.AbstractOcspCertstoreDbImporter;
import org.xipki.ca.dbtool.xmlio.ocsp.OcspCertType;
import org.xipki.ca.dbtool.xmlio.ocsp.OcspCertsReader;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.XmlUtil;

class OcspCertstoreDbImporter
extends AbstractOcspCertstoreDbImporter {
    private static final Logger LOG = LoggerFactory.getLogger(OcspCertstoreDbImporter.class);
    private final Unmarshaller unmarshaller;
    private final boolean resume;
    private final int numCertsPerCommit;

    OcspCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, int numCertsPerCommit, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        this.unmarshaller = jaxbContext.createUnmarshaller();
        this.unmarshaller.setSchema(DbPorter.retrieveSchema("/xsd/dbi-ocsp.xsd"));
        this.numCertsPerCommit = ParamUtil.requireMin((String)"numCertsPerCommit", (int)numCertsPerCommit, (int)1);
        File processLogFile = new File(this.baseDir, "import.process");
        if (resume) {
            if (!processLogFile.exists()) {
                throw new Exception("could not process with '--resume' option");
            }
        } else if (processLogFile.exists()) {
            throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
        }
        this.resume = resume;
    }

    public void importToDb() throws Exception {
        CertstoreType certstore;
        try {
            File file = new File(this.baseDir + File.separator + "ocsp-certstore.xml");
            JAXBElement root = (JAXBElement)this.unmarshaller.unmarshal(file);
            certstore = (CertstoreType)root.getValue();
        }
        catch (JAXBException ex) {
            throw XmlUtil.convert((JAXBException)ex);
        }
        if (certstore.getVersion() > 1) {
            throw new Exception("could not import Certstore greater than 1: " + certstore.getVersion());
        }
        File processLogFile = new File(this.baseDir, "import.process");
        System.out.println("importing OCSP certstore to database");
        try {
            if (!this.resume) {
                this.dropIndexes();
                this.importCertHashAlgo(certstore.getCerthashAlgo());
                this.importIssuer(certstore.getIssuers());
            }
            this.importCert(certstore, processLogFile);
            this.recoverIndexes();
            processLogFile.delete();
        }
        catch (Exception ex) {
            System.err.println("could not import OCSP certstore to database");
            throw ex;
        }
        System.out.println(" imported OCSP certstore to database");
    }

    private void importCertHashAlgo(String certHashAlgo) throws DataAccessException {
        String sql = "UPDATE DBSCHEMA SET VALUE2=? WHERE NAME='CERTHASH_ALGO'";
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            ps.setString(1, certHashAlgo);
            ps.executeUpdate();
            this.dbSchemaInfo.setVariable("CERTHASH_ALGO", certHashAlgo);
        }
        catch (SQLException ex) {
            System.err.println("could not import DBSCHEMA");
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importIssuer(CertstoreType.Issuers issuers) throws DataAccessException, CertificateException, IOException {
        System.out.println("importing table ISSUER");
        PreparedStatement ps = this.prepareStatement("INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,REV_INFO,CERT) VALUES (?,?,?,?,?,?,?)");
        try {
            for (IssuerType issuer : issuers.getIssuer()) {
                this.importIssuer0(issuer, ps);
            }
        }
        finally {
            this.releaseResources(ps, null);
        }
        System.out.println(" imported table ISSUER");
    }

    private void importIssuer0(IssuerType issuer, PreparedStatement ps) throws DataAccessException, CertificateException, IOException {
        try {
            Certificate cert;
            String certFilename = issuer.getCertFile();
            String b64Cert = new String(IoUtil.read((File)new File(this.baseDir, certFilename)));
            byte[] encodedCert = Base64.decode((String)b64Cert);
            try {
                cert = Certificate.getInstance((Object)encodedCert);
            }
            catch (RuntimeException ex) {
                LOG.error("could not parse certificate of issuer {}", (Object)issuer.getId());
                LOG.debug("could not parse certificate of issuer " + issuer.getId(), (Throwable)ex);
                throw new CertificateException(ex.getMessage(), ex);
            }
            int idx = 1;
            ps.setInt(idx++, issuer.getId());
            ps.setString(idx++, X509Util.cutX500Name((X500Name)cert.getSubject(), (int)this.maxX500nameLen));
            ps.setLong(idx++, cert.getTBSCertificate().getStartDate().getDate().getTime() / 1000L);
            ps.setLong(idx++, cert.getTBSCertificate().getEndDate().getDate().getTime() / 1000L);
            ps.setString(idx++, this.sha1(encodedCert));
            ps.setString(idx++, issuer.getRevInfo());
            ps.setString(idx++, b64Cert);
            ps.execute();
        }
        catch (SQLException ex) {
            System.err.println("could not import issuer with id=" + issuer.getId());
            throw this.translate("INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,REV_INFO,CERT) VALUES (?,?,?,?,?,?,?)", ex);
        }
        catch (CertificateException ex) {
            System.err.println("could not import issuer with id=" + issuer.getId());
            throw ex;
        }
    }

    /*
     * Exception decompiling
     */
    private void importCert(CertstoreType certstore, File processLogFile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importCert0(PreparedStatement psCert, String certsZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess) throws Exception {
        OcspCertsReader certs;
        ZipFile zipFile = new ZipFile(new File(certsZipFile));
        ZipEntry certsXmlEntry = zipFile.getEntry("certs.xml");
        try {
            certs = new OcspCertsReader(zipFile.getInputStream(certsXmlEntry));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)certsZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + certsZipFile, (Throwable)e2);
            }
            throw ex;
        }
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulCertId = 0L;
            while (certs.hasNext()) {
                boolean isLastBlock;
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                OcspCertType cert = (OcspCertType)certs.next();
                long id = cert.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                try {
                    int idx = 1;
                    psCert.setLong(idx++, id);
                    psCert.setInt(idx++, cert.getIid());
                    psCert.setString(idx++, cert.getSn());
                    psCert.setLong(idx++, cert.getUpdate());
                    psCert.setLong(idx++, cert.getNbefore());
                    psCert.setLong(idx++, cert.getNafter());
                    OcspCertstoreDbImporter.setBoolean(psCert, idx++, cert.getRev());
                    OcspCertstoreDbImporter.setInt(psCert, idx++, cert.getRr());
                    OcspCertstoreDbImporter.setLong(psCert, idx++, cert.getRt());
                    OcspCertstoreDbImporter.setLong(psCert, idx++, cert.getRit());
                    psCert.setString(idx++, cert.getHash());
                    psCert.setString(idx++, cert.getSubject());
                    psCert.addBatch();
                }
                catch (SQLException ex) {
                    throw this.translate("INSERT INTO CERT (ID,IID,SN,LUPDATE,NBEFORE,NAFTER,REV,RR,RT,RIT,HASH,SUBJECT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", ex);
                }
                boolean bl = isLastBlock = !certs.hasNext();
                if (numEntriesInBatch <= 0 || numEntriesInBatch % this.numCertsPerCommit != 0 && !isLastBlock) continue;
                try {
                    psCert.executeBatch();
                    this.commit("(commit import cert to OCSP)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteCertGreatherThan(lastSuccessfulCertId, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate("INSERT INTO CERT (ID,IID,SN,LUPDATE,NBEFORE,NAFTER,REV,RR,RT,RIT,HASH,SUBJECT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulCertId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                OcspCertstoreDbImporter.echoToFile((long)numProcessedInLastProcess + processLog.numProcessed() + ":" + lastSuccessfulCertId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulCertId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }
}

