/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ocsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.port.DbPortWorker;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.ca.dbtool.port.ocsp.OcspCertstoreDbExporter;
import org.xipki.ca.dbtool.port.ocsp.OcspDbImportWorker;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class OcspDbExportWorker
extends DbPortWorker {
    private static final Logger LOG = LoggerFactory.getLogger(OcspDbImportWorker.class);
    private final DataSourceWrapper datasource;
    private final String destFolder;
    private final boolean resume;
    private final int numCertsInBundle;
    private final int numCertsPerSelect;

    public OcspDbExportWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String destFolder, boolean resume, int numCertsInBundle, int numCertsPerSelect) throws PasswordResolverException, IOException {
        String[] children;
        ParamUtil.requireNonNull((String)"datasourceFactory", (Object)datasourceFactory);
        ParamUtil.requireNonNull((String)"dbConfFile", (Object)dbConfFile);
        this.destFolder = (String)ParamUtil.requireNonNull((String)destFolder, (Object)destFolder);
        Properties props = DbPorter.getDbConfProperties(new FileInputStream(IoUtil.expandFilepath((String)dbConfFile)));
        this.datasource = datasourceFactory.createDataSource("ds-" + dbConfFile, props, passwordResolver);
        File file = new File(destFolder);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            if (!file.isDirectory()) {
                throw new IOException(destFolder + " is not a folder");
            }
            if (!file.canWrite()) {
                throw new IOException(destFolder + " is not writable");
            }
        }
        if (!resume && (children = file.list()) != null && children.length > 0) {
            throw new IOException(destFolder + " is not empty");
        }
        this.resume = resume;
        this.numCertsInBundle = numCertsInBundle;
        this.numCertsPerSelect = numCertsPerSelect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run0() throws Exception {
        long start = System.currentTimeMillis();
        try {
            OcspCertstoreDbExporter certStoreExporter = new OcspCertstoreDbExporter(this.datasource, this.destFolder, this.numCertsInBundle, this.numCertsPerSelect, this.resume, this.stopMe);
            certStoreExporter.export();
            certStoreExporter.shutdown();
        }
        finally {
            try {
                this.datasource.close();
            }
            catch (Throwable th) {
                LOG.error("datasource.close()", th);
            }
            long end = System.currentTimeMillis();
            System.out.println("finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
        }
    }
}

