/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.port.ocsp;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.dbtool.port.DbPortWorker;
import org.xipki.ca.dbtool.port.DbPorter;
import org.xipki.ca.dbtool.port.ocsp.OcspCertStoreFromCaDbImporter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.IoUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class OcspFromCaDbImportWorker
extends DbPortWorker {
    private static final Logger LOG = LoggerFactory.getLogger(OcspFromCaDbImportWorker.class);
    private final DataSourceWrapper datasource;
    private final String publisherName;
    private final boolean resume;
    private final String srcFolder;
    private final int batchEntriesPerCommit;

    public OcspFromCaDbImportWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String publisherName, boolean resume, String srcFolder, int batchEntriesPerCommit, boolean evaluateOnly) throws PasswordResolverException, IOException {
        ParamUtil.requireNonNull((String)"dbConfFile", (Object)dbConfFile);
        ParamUtil.requireNonNull((String)"datasourceFactory", (Object)datasourceFactory);
        Properties props = DbPorter.getDbConfProperties(new FileInputStream(IoUtil.expandFilepath((String)dbConfFile)));
        this.datasource = datasourceFactory.createDataSource("ds-" + dbConfFile, props, passwordResolver);
        this.publisherName = publisherName;
        this.resume = resume;
        this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
        this.batchEntriesPerCommit = batchEntriesPerCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run0() throws Exception {
        long start = System.currentTimeMillis();
        try {
            OcspCertStoreFromCaDbImporter certStoreImporter = new OcspCertStoreFromCaDbImporter(this.datasource, this.srcFolder, this.publisherName, this.batchEntriesPerCommit, this.resume, this.stopMe);
            certStoreImporter.importToDb();
            certStoreImporter.shutdown();
        }
        finally {
            try {
                this.datasource.close();
            }
            catch (Throwable th) {
                LOG.error("datasource.close()", th);
            }
            long end = System.currentTimeMillis();
            System.out.println("finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
        }
    }
}

