/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.xmlio;

import javax.xml.stream.XMLStreamException;
import org.xipki.ca.dbtool.xmlio.DbiXmlWriter;
import org.xipki.ca.dbtool.xmlio.InvalidDataObjectException;
import org.xipki.util.StringUtil;

public abstract class DbDataObject {
    protected DbDataObject() {
    }

    protected void assertNotBlank(String name, String value) throws InvalidDataObjectException {
        if (StringUtil.isBlank((String)value)) {
            throw new InvalidDataObjectException(name + " must not be blank");
        }
    }

    protected void assertNotNull(String name, Object value) throws InvalidDataObjectException {
        if (value == null) {
            throw new InvalidDataObjectException(name + " must not be null");
        }
    }

    protected static void writeIfNotNull(DbiXmlWriter writer, String tag, Object value) throws XMLStreamException, InvalidDataObjectException {
        String valueS;
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            valueS = (String)value;
        } else if (value instanceof Number) {
            valueS = value.toString();
        } else if (value instanceof Boolean) {
            valueS = value.toString();
        } else {
            throw new InvalidDataObjectException("value is not a String or Number");
        }
        writer.writeElement(tag, valueS);
    }

    public abstract void validate() throws InvalidDataObjectException;

    public abstract void writeTo(DbiXmlWriter var1) throws InvalidDataObjectException, XMLStreamException;
}

