/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.xmlio;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xipki.ca.dbtool.xmlio.DbDataObject;
import org.xipki.ca.dbtool.xmlio.InvalidDataObjectException;
import org.xipki.util.ParamUtil;

public abstract class DbiXmlReader {
    protected final XMLStreamReader reader;
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private final String rootElementName;
    private DbDataObject next;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbiXmlReader(String rootElementName, InputStream xmlStream) throws XMLStreamException, InvalidDataObjectException {
        this.rootElementName = ParamUtil.requireNonBlank((String)"rootElementName", (String)rootElementName);
        ParamUtil.requireNonNull((String)"xmlStream", (Object)xmlStream);
        XMLInputFactory xMLInputFactory = this.factory;
        synchronized (xMLInputFactory) {
            this.reader = this.factory.createXMLStreamReader(xmlStream);
        }
        String thisRootElement = null;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            if (event != 1) continue;
            thisRootElement = this.reader.getLocalName();
            break;
        }
        if (!this.rootElementName.equals(thisRootElement)) {
            throw new InvalidDataObjectException("the given XML stream does not have root element '" + rootElementName + "', but '" + thisRootElement + "'");
        }
        this.next = this.retrieveNext();
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public DbDataObject next() throws InvalidDataObjectException, XMLStreamException {
        if (this.next == null) {
            throw new IllegalStateException("no more next element exists");
        }
        DbDataObject ret = this.next;
        this.next = this.retrieveNext();
        return ret;
    }

    protected int parseInt(String str) {
        return Integer.parseInt(str);
    }

    protected long parseLong(String str) {
        return Long.parseLong(str);
    }

    protected boolean parseBoolean(String str) {
        return Boolean.parseBoolean(str);
    }

    protected abstract DbDataObject retrieveNext() throws InvalidDataObjectException, XMLStreamException;
}

