/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.xmlio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xipki.util.ParamUtil;

public class DbiXmlWriter {
    private static final XMLOutputFactory FACTORY = XMLOutputFactory.newFactory();
    private final ByteArrayOutputStream stream;
    private final XMLStreamWriter writer;
    private boolean flushed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbiXmlWriter(String rootElementName, String version) throws XMLStreamException {
        ParamUtil.requireNonBlank((String)"version", (String)version);
        this.stream = new ByteArrayOutputStream();
        XMLOutputFactory xMLOutputFactory = FACTORY;
        synchronized (xMLOutputFactory) {
            this.writer = FACTORY.createXMLStreamWriter(this.stream, "UTF-8");
        }
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writeNewline();
        this.writer.writeStartElement(rootElementName);
        this.writer.writeAttribute("version", version);
        this.writeNewline();
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        ParamUtil.requireNonNull((String)"localName", (Object)localName);
        this.writer.writeStartElement(localName);
    }

    public void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    public void writeElement(String localName, String value) throws XMLStreamException {
        ParamUtil.requireNonNull((String)"localName", (Object)localName);
        ParamUtil.requireNonNull((String)"value", (Object)value);
        this.writer.writeStartElement(localName);
        this.writer.writeCharacters(value);
        this.writer.writeEndElement();
    }

    public void writeNewline() throws XMLStreamException {
        this.writer.writeCharacters("\n");
    }

    public void flush() throws IOException, XMLStreamException {
        if (this.flushed) {
            return;
        }
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.stream.flush();
        this.flushed = true;
    }

    public void rewriteToZipStream(ZipOutputStream zipStream) throws IOException, XMLStreamException {
        ParamUtil.requireNonNull((String)"zipStream", (Object)zipStream);
        this.flush();
        zipStream.write(this.stream.toByteArray());
    }
}

