/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.xmlio.ca;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.xipki.ca.dbtool.xmlio.DbDataObject;
import org.xipki.ca.dbtool.xmlio.DbiXmlReader;
import org.xipki.ca.dbtool.xmlio.InvalidDataObjectException;
import org.xipki.ca.dbtool.xmlio.ca.CertType;

public class CertsReader
extends DbiXmlReader {
    public CertsReader(InputStream xmlStream) throws XMLStreamException, InvalidDataObjectException {
        super("certs", xmlStream);
    }

    @Override
    protected DbDataObject retrieveNext() throws InvalidDataObjectException, XMLStreamException {
        CertType ret = null;
        StringBuilder buffer = new StringBuilder();
        int lastEvent = -1;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            String tagContent = null;
            if (event != 4) {
                tagContent = buffer.toString();
                if (lastEvent == 4) {
                    buffer.delete(0, buffer.length());
                }
            }
            lastEvent = event;
            if (event == 1) {
                if (!"cert".equals(this.reader.getLocalName())) continue;
                ret = new CertType();
                continue;
            }
            if (event == 4) {
                buffer.append(this.reader.getText());
                continue;
            }
            if (event != 2 || ret == null) continue;
            switch (this.reader.getLocalName()) {
                case "cert": {
                    ret.validate();
                    return ret;
                }
                case "caId": {
                    ret.setCaId(this.parseInt(tagContent));
                    break;
                }
                case "file": {
                    ret.setFile(tagContent);
                    break;
                }
                case "ee": {
                    ret.setEe(this.parseBoolean(tagContent));
                    break;
                }
                case "fpRs": {
                    ret.setFpRs(this.parseLong(tagContent));
                    break;
                }
                case "id": {
                    ret.setId(this.parseLong(tagContent));
                    break;
                }
                case "pid": {
                    ret.setPid(this.parseInt(tagContent));
                    break;
                }
                case "reqType": {
                    ret.setReqType(this.parseInt(tagContent));
                    break;
                }
                case "rev": {
                    ret.setRev(this.parseBoolean(tagContent));
                    break;
                }
                case "rid": {
                    ret.setRid(this.parseInt(tagContent));
                    break;
                }
                case "rit": {
                    ret.setRit(this.parseLong(tagContent));
                    break;
                }
                case "rr": {
                    ret.setRr(this.parseInt(tagContent));
                    break;
                }
                case "rs": {
                    ret.setRs(tagContent);
                    break;
                }
                case "rt": {
                    ret.setRt(this.parseLong(tagContent));
                    break;
                }
                case "sn": {
                    ret.setSn(tagContent);
                    break;
                }
                case "tid": {
                    ret.setTid(tagContent);
                    break;
                }
                case "uid": {
                    ret.setUid(this.parseInt(tagContent));
                    break;
                }
                case "update": {
                    ret.setUpdate(this.parseLong(tagContent));
                    break;
                }
            }
        }
        return null;
    }
}

