/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.xmlio.ca;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.xipki.ca.dbtool.xmlio.DbDataObject;
import org.xipki.ca.dbtool.xmlio.DbiXmlReader;
import org.xipki.ca.dbtool.xmlio.InvalidDataObjectException;
import org.xipki.ca.dbtool.xmlio.ca.RequestType;

public class RequestsReader
extends DbiXmlReader {
    public RequestsReader(InputStream xmlStream) throws XMLStreamException, InvalidDataObjectException {
        super("requests", xmlStream);
    }

    @Override
    protected DbDataObject retrieveNext() throws InvalidDataObjectException, XMLStreamException {
        RequestType ret = null;
        StringBuilder buffer = new StringBuilder();
        int lastEvent = -1;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            String tagContent = null;
            if (event != 4) {
                tagContent = buffer.toString();
                if (lastEvent == 4) {
                    buffer.delete(0, buffer.length());
                }
            }
            lastEvent = event;
            if (event == 1) {
                if (!"request".equals(this.reader.getLocalName())) continue;
                ret = new RequestType();
                continue;
            }
            if (event == 4) {
                buffer.append(this.reader.getText());
                continue;
            }
            if (event != 2 || ret == null) continue;
            switch (this.reader.getLocalName()) {
                case "request": {
                    ret.validate();
                    return ret;
                }
                case "update": {
                    ret.setUpdate(this.parseLong(tagContent));
                    break;
                }
                case "file": {
                    ret.setFile(tagContent);
                    break;
                }
                case "id": {
                    ret.setId(this.parseLong(tagContent));
                    break;
                }
            }
        }
        return null;
    }
}

