/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.dbtool.xmlio.ocsp;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.xipki.ca.dbtool.xmlio.DbDataObject;
import org.xipki.ca.dbtool.xmlio.DbiXmlReader;
import org.xipki.ca.dbtool.xmlio.InvalidDataObjectException;
import org.xipki.ca.dbtool.xmlio.ocsp.OcspCertType;

public class OcspCertsReader
extends DbiXmlReader {
    public OcspCertsReader(InputStream xmlStream) throws XMLStreamException, InvalidDataObjectException {
        super("certs", xmlStream);
    }

    @Override
    protected DbDataObject retrieveNext() throws InvalidDataObjectException, XMLStreamException {
        OcspCertType ret = null;
        StringBuilder buffer = new StringBuilder();
        int lastEvent = -1;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            String tagContent = null;
            if (event != 4) {
                tagContent = buffer.toString();
                if (lastEvent == 4) {
                    buffer.delete(0, buffer.length());
                }
            }
            lastEvent = event;
            if (event == 1) {
                if (!"cert".equals(this.reader.getLocalName())) continue;
                ret = new OcspCertType();
                continue;
            }
            if (event == 4) {
                buffer.append(this.reader.getText());
                continue;
            }
            if (event != 2 || ret == null) continue;
            switch (this.reader.getLocalName()) {
                case "cert": {
                    ret.validate();
                    return ret;
                }
                case "id": {
                    ret.setId(this.parseLong(tagContent));
                    break;
                }
                case "hash": {
                    ret.setHash(tagContent);
                    break;
                }
                case "iid": {
                    ret.setIid(this.parseInt(tagContent));
                    break;
                }
                case "nafter": {
                    ret.setNafter(this.parseLong(tagContent));
                    break;
                }
                case "nbefore": {
                    ret.setNbefore(this.parseLong(tagContent));
                    break;
                }
                case "rev": {
                    ret.setRev(this.parseBoolean(tagContent));
                    break;
                }
                case "rit": {
                    ret.setRit(this.parseLong(tagContent));
                    break;
                }
                case "rr": {
                    ret.setRr(this.parseInt(tagContent));
                    break;
                }
                case "rt": {
                    ret.setRt(this.parseLong(tagContent));
                    break;
                }
                case "sn": {
                    ret.setSn(tagContent);
                    break;
                }
                case "subject": {
                    ret.setSubject(tagContent);
                    break;
                }
                case "update": {
                    ret.setUpdate(this.parseLong(tagContent));
                    break;
                }
            }
        }
        return null;
    }
}

