/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import java.util.Collections;
import java.util.Set;
import org.xipki.ca.api.NameId;
import org.xipki.ca.server.mgmt.api.PermissionConstants;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class CaHasRequestorEntry {
    private final NameId requestorIdent;
    private boolean ra;
    private int permission;
    private Set<String> profiles;

    public CaHasRequestorEntry(NameId requestorIdent) {
        this.requestorIdent = (NameId)ParamUtil.requireNonNull((String)"requestorIdent", (Object)requestorIdent);
    }

    public boolean isRa() {
        return this.ra;
    }

    public void setRa(boolean ra) {
        this.ra = ra;
    }

    public int getPermission() {
        return this.permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public NameId getRequestorIdent() {
        return this.requestorIdent;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = CollectionUtil.isEmpty(profiles) ? Collections.emptySet() : CollectionUtil.unmodifiableSet((Set)CollectionUtil.toLowerCaseSet(profiles));
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public boolean isCertprofilePermitted(String certprofile) {
        if (CollectionUtil.isEmpty(this.profiles)) {
            return false;
        }
        return this.profiles.contains("all") || this.profiles.contains(certprofile.toLowerCase());
    }

    public boolean isPermitted(int permission) {
        return PermissionConstants.contains(this.permission, permission);
    }

    public String toString() {
        return StringUtil.concatObjectsCap((int)200, (Object)"requestor: ", (Object[])new Object[]{this.requestorIdent, ", ra: ", this.ra, ", profiles: ", this.profiles, ", permission: ", PermissionConstants.permissionToString(this.permission)});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CaHasRequestorEntry)) {
            return false;
        }
        return this.equals((CaHasRequestorEntry)obj, false);
    }

    public boolean equals(CaHasRequestorEntry obj, boolean ignoreId) {
        return obj != null && this.ra == obj.ra && this.requestorIdent.equals(obj.requestorIdent, ignoreId) && this.permission == obj.permission && CompareUtil.equalsObject(this.profiles, obj.profiles);
    }

    public int hashCode() {
        return this.requestorIdent.hashCode();
    }
}

