/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import org.xipki.ca.api.NameId;
import org.xipki.util.CompareUtil;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class CertprofileEntry {
    private final NameId ident;
    private final String type;
    private final String conf;
    private boolean faulty;

    public CertprofileEntry(NameId ident, String type, String conf) {
        this.ident = (NameId)ParamUtil.requireNonNull((String)"ident", (Object)ident);
        this.type = ParamUtil.requireNonBlankLower((String)"type", (String)type);
        this.conf = conf;
        if ("all".equalsIgnoreCase(ident.getName()) || "null".equalsIgnoreCase(ident.getName())) {
            throw new IllegalArgumentException("certificate profile name must not be 'all' and 'null'");
        }
    }

    public NameId getIdent() {
        return this.ident;
    }

    public String getType() {
        return this.type;
    }

    public String getConf() {
        return this.conf;
    }

    public boolean isFaulty() {
        return this.faulty;
    }

    public void setFaulty(boolean faulty) {
        this.faulty = faulty;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        boolean bo = verbose || this.conf == null || this.conf.length() < 301;
        return StringUtil.concatObjectsCap((int)200, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nfaulty: ", this.faulty, "\ntype: ", this.type, "\nconf: ", bo ? this.conf : StringUtil.concat((String)this.conf.substring(0, 297), (String[])new String[]{"..."})});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertprofileEntry)) {
            return false;
        }
        return this.equals((CertprofileEntry)obj, false);
    }

    public boolean equals(CertprofileEntry obj, boolean ignoreId) {
        if (!this.ident.equals(obj.ident, ignoreId)) {
            return false;
        }
        if (!this.type.equals(obj.type)) {
            return false;
        }
        return CompareUtil.equalsObject((Object)this.conf, (Object)obj.conf);
    }

    public int hashCode() {
        return this.ident.hashCode();
    }
}

