/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import org.xipki.ca.api.profile.CertValidity;
import org.xipki.security.CrlReason;
import org.xipki.util.ConfPairs;
import org.xipki.util.ParamUtil;

public class RevokeSuspendedCertsControl {
    public static final String KEY_REVOCATION_ENABLED = "revokeSuspendedCerts.enabled";
    public static final String KEY_REVOCATION_REASON = "revokeSuspendedCerts.targetReason";
    public static final String KEY_UNCHANGED_SINCE = "revokeSuspendedCerts.unchangedSince";
    private final CrlReason targetReason;
    private final CertValidity unchangedSince;

    public RevokeSuspendedCertsControl(CrlReason targetReason, CertValidity unchangedSince) {
        this.targetReason = (CrlReason)ParamUtil.requireNonNull((String)"targetReason", (Object)targetReason);
        this.unchangedSince = (CertValidity)ParamUtil.requireNonNull((String)"unchangedSince", (Object)unchangedSince);
        switch (targetReason) {
            case AFFILIATION_CHANGED: 
            case CESSATION_OF_OPERATION: 
            case KEY_COMPROMISE: 
            case PRIVILEGE_WITHDRAWN: 
            case SUPERSEDED: 
            case UNSPECIFIED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid targetReason " + targetReason);
            }
        }
    }

    public CrlReason getTargetReason() {
        return this.targetReason;
    }

    public CertValidity getUnchangedSince() {
        return this.unchangedSince;
    }

    public String toString() {
        ConfPairs pairs = new ConfPairs();
        pairs.putPair(KEY_REVOCATION_REASON, this.targetReason.getDescription());
        pairs.putPair(KEY_UNCHANGED_SINCE, this.unchangedSince.toString());
        return pairs.getEncoded();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RevokeSuspendedCertsControl)) {
            return false;
        }
        RevokeSuspendedCertsControl obj2 = (RevokeSuspendedCertsControl)obj;
        return this.targetReason == obj2.targetReason && this.unchangedSince != obj2.unchangedSince;
    }
}

