/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.xipki.ca.server.mgmt.api.InternUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.CompareUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;

public class SignerEntry {
    private final String name;
    private final String type;
    private String conf;
    private boolean certFaulty;
    private boolean confFaulty;
    private final String base64Cert;
    private X509Certificate certificate;

    public SignerEntry(String name, String type, String conf, String base64Cert) {
        this.name = ParamUtil.requireNonBlankLower((String)"name", (String)name);
        this.type = ParamUtil.requireNonBlankLower((String)"type", (String)type);
        this.conf = conf;
        this.base64Cert = base64Cert;
        if (base64Cert == null) {
            return;
        }
        try {
            this.certificate = X509Util.parseCert((byte[])base64Cert.getBytes());
        }
        catch (Throwable th) {
            this.certFaulty = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public String getConf() {
        return this.conf;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        if (this.base64Cert != null) {
            throw new IllegalStateException("certificate is already specified by base64Cert");
        }
        this.certificate = certificate;
    }

    public String getBase64Cert() {
        return this.base64Cert;
    }

    public boolean isFaulty() {
        return this.confFaulty || this.certFaulty;
    }

    public void setConfFaulty(boolean confFaulty) {
        this.confFaulty = confFaulty;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        return this.toString(verbose, true);
    }

    public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("name: ").append(this.name).append('\n');
        sb.append("faulty: ").append(this.isFaulty()).append('\n');
        sb.append("type: ").append(this.type).append('\n');
        sb.append("conf: ");
        if (this.conf == null) {
            sb.append("null");
        } else {
            sb.append(InternUtil.signerConfToString(this.conf, verbose, ignoreSensitiveInfo));
        }
        sb.append('\n');
        sb.append("certificate: ").append("\n");
        if (this.certificate != null || this.base64Cert != null) {
            if (this.certificate != null) {
                sb.append("\tissuer: ").append(X509Util.getRfc4519Name((X500Principal)this.certificate.getIssuerX500Principal())).append('\n');
                sb.append("\tserialNumber: ").append(LogUtil.formatCsn((BigInteger)this.certificate.getSerialNumber())).append('\n');
                sb.append("\tsubject: ").append(X509Util.getRfc4519Name((X500Principal)this.certificate.getSubjectX500Principal()));
            }
            if (verbose) {
                sb.append("\n\tencoded: ");
                try {
                    sb.append(Base64.encodeToString((byte[])this.certificate.getEncoded()));
                }
                catch (CertificateEncodingException ex) {
                    sb.append("ERROR");
                }
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SignerEntry)) {
            return false;
        }
        SignerEntry objB = (SignerEntry)obj;
        return this.name.equals(objB.name) && this.type.equals(objB.type) && CompareUtil.equalsObject((Object)this.conf, (Object)objB.conf) && CompareUtil.equalsObject((Object)this.base64Cert, (Object)objB.base64Cert);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

