/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import java.util.Map;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.util.ConfPairs;
import org.xipki.util.Validity;
import org.xipki.util.exception.InvalidConfException;

public class CaConfColumn {
    @JSONField(ordinal=1)
    private int version = 1;
    @JSONField(ordinal=3)
    private int snSize;
    @JSONField(ordinal=5)
    private List<String> cacertUris;
    @JSONField(ordinal=7)
    private List<String> ocspUris;
    @JSONField(ordinal=9)
    private List<String> crlUris;
    @JSONField(ordinal=11)
    private List<String> deltaCrlUris;
    @JSONField(ordinal=13)
    private String maxValidity;
    @JSONField(ordinal=15)
    private Map<String, String> crlControl;
    @JSONField(ordinal=25)
    private Map<String, String> ctlogControl;
    @JSONField(ordinal=27)
    private Map<String, String> revokeSuspendedControl;
    @JSONField(ordinal=29)
    private List<String> keypairGenNames;
    @JSONField(ordinal=33)
    private boolean saveCert;
    @JSONField(ordinal=35)
    private boolean saveKeypair;
    @JSONField(ordinal=39)
    private String validityMode;
    @JSONField(ordinal=41)
    private int permission;
    @JSONField(ordinal=43)
    private int numCrls = 30;
    @JSONField(ordinal=45)
    private int expirationPeriod = 365;
    @JSONField(ordinal=47)
    private int keepExpiredCertDays = -1;
    @JSONField(ordinal=99)
    private Map<String, String> extraControl;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getSnSize() {
        return this.snSize;
    }

    public void setSnSize(int snSize) {
        this.snSize = snSize;
    }

    public List<String> getCacertUris() {
        return this.cacertUris;
    }

    public void setCacertUris(List<String> cacertUris) {
        this.cacertUris = cacertUris;
    }

    public List<String> getOcspUris() {
        return this.ocspUris;
    }

    public void setOcspUris(List<String> ocspUris) {
        this.ocspUris = ocspUris;
    }

    public List<String> getCrlUris() {
        return this.crlUris;
    }

    public void setCrlUris(List<String> crlUris) {
        this.crlUris = crlUris;
    }

    public List<String> getDeltaCrlUris() {
        return this.deltaCrlUris;
    }

    public void setDeltaCrlUris(List<String> deltaCrlUris) {
        this.deltaCrlUris = deltaCrlUris;
    }

    public String getMaxValidity() {
        return this.maxValidity;
    }

    public void setMaxValidity(String maxValidity) {
        this.maxValidity = maxValidity;
    }

    public Map<String, String> getCrlControl() {
        return this.crlControl;
    }

    public void setCrlControl(Map<String, String> crlControl) {
        this.crlControl = crlControl;
    }

    public Map<String, String> getCtlogControl() {
        return this.ctlogControl;
    }

    public void setCtlogControl(Map<String, String> ctlogControl) {
        this.ctlogControl = ctlogControl;
    }

    public Map<String, String> getRevokeSuspendedControl() {
        return this.revokeSuspendedControl;
    }

    public void setRevokeSuspendedControl(Map<String, String> revokeSuspendedControl) {
        this.revokeSuspendedControl = revokeSuspendedControl;
    }

    public List<String> getKeypairGenNames() {
        return this.keypairGenNames;
    }

    public void setKeypairGenNames(List<String> keypairGenNames) {
        this.keypairGenNames = keypairGenNames;
    }

    public boolean isSaveCert() {
        return this.saveCert;
    }

    public void setSaveCert(boolean saveCert) {
        this.saveCert = saveCert;
    }

    public boolean isSaveKeypair() {
        return this.saveKeypair;
    }

    public void setSaveKeypair(boolean saveKeypair) {
        this.saveKeypair = saveKeypair;
    }

    public String getValidityMode() {
        return this.validityMode;
    }

    public void setValidityMode(String validityMode) {
        this.validityMode = validityMode;
    }

    public int getPermission() {
        return this.permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public int getNumCrls() {
        return this.numCrls;
    }

    public void setNumCrls(int numCrls) {
        this.numCrls = numCrls;
    }

    public int getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public void setExpirationPeriod(int expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
    }

    public int getKeepExpiredCertDays() {
        return this.keepExpiredCertDays;
    }

    public void setKeepExpiredCertDays(int keepExpiredCertDays) {
        this.keepExpiredCertDays = keepExpiredCertDays;
    }

    public Map<String, String> getExtraControl() {
        return this.extraControl;
    }

    public void setExtraControl(Map<String, String> extraControl) {
        this.extraControl = extraControl;
    }

    public CaConfColumn clone() {
        return CaConfColumn.decode(this.encode());
    }

    public static CaConfColumn decode(String encoded) {
        return (CaConfColumn)JSON.parseObject((String)encoded, CaConfColumn.class);
    }

    public void fillCaEntry(CaEntry entry) throws CaMgmtException {
        entry.setRevokeSuspendedControl(this.revokeSuspendedControl());
        entry.setMaxValidity(this.maxValidity());
        entry.setKeepExpiredCertInDays(this.keepExpiredCertDays);
        entry.setKeypairGenNames(this.keypairGenNames);
        entry.setExtraControl(this.extraControl());
        entry.setCrlControl(this.crlControl());
        entry.setCtlogControl(this.ctlogControl());
        entry.setSaveCert(this.isSaveCert());
        entry.setSaveKeypair(this.isSaveKeypair());
        entry.setPermission(this.permission);
        entry.setValidityMode(this.validityMode());
    }

    public String encode() {
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField, SerializerFeature.QuoteFieldNames, SerializerFeature.IgnoreNonFieldGetter});
    }

    public CaUris caUris() {
        return new CaUris(this.cacertUris, this.ocspUris, this.crlUris, this.deltaCrlUris);
    }

    public int snSize() {
        if (this.snSize > 20) {
            return 20;
        }
        if (this.snSize < 1) {
            return 1;
        }
        return this.snSize;
    }

    private RevokeSuspendedControl revokeSuspendedControl() {
        return this.revokeSuspendedControl == null ? new RevokeSuspendedControl(false) : new RevokeSuspendedControl(new ConfPairs(this.revokeSuspendedControl));
    }

    private Validity maxValidity() {
        return this.maxValidity == null ? null : Validity.getInstance((String)this.maxValidity);
    }

    private CrlControl crlControl() throws CaMgmtException {
        ConfPairs pairs = new ConfPairs(this.crlControl);
        try {
            return new CrlControl(pairs);
        }
        catch (InvalidConfException ex) {
            throw new CaMgmtException("invalid CRL_CONTROL: " + pairs, ex);
        }
    }

    private CtlogControl ctlogControl() throws CaMgmtException {
        if (this.ctlogControl == null) {
            return null;
        }
        ConfPairs pairs = new ConfPairs(this.ctlogControl);
        try {
            return new CtlogControl(pairs);
        }
        catch (InvalidConfException ex) {
            throw new CaMgmtException("invalid CTLOG_CONTROL: " + pairs.getEncoded(), ex);
        }
    }

    private ConfPairs extraControl() {
        return this.extraControl == null ? null : new ConfPairs(this.extraControl).unmodifiable();
    }

    private ValidityMode validityMode() {
        return this.validityMode == null ? ValidityMode.STRICT : ValidityMode.forName(this.validityMode);
    }
}

