/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.ValidatableConf;
import org.xipki.util.exception.InvalidConfException;

public class CaConfType {

    public static class Signer
    extends ValidatableConf {
        private String type;
        private FileOrValue conf;
        private FileOrBinary cert;
        private String name;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            Signer.notBlank((String)this.name, (String)"name");
            Signer.notBlank((String)this.type, (String)"type");
            Signer.notNull((Object)this.conf, (String)"conf");
            Signer.validate((ValidatableConf[])new ValidatableConf[]{this.conf, this.cert});
        }
    }

    public static class Requestor
    extends ValidatableConf {
        private String name;
        private String type;
        private FileOrValue conf;
        private FileOrBinary binaryConf;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public FileOrBinary getBinaryConf() {
            return this.binaryConf;
        }

        public void setBinaryConf(FileOrBinary binaryConf) {
            this.binaryConf = binaryConf;
        }

        public void validate() throws InvalidConfException {
            Requestor.notBlank((String)this.name, (String)"name");
            Requestor.notBlank((String)this.type, (String)"type");
            this.exactOne(this.conf, "conf", this.binaryConf, "binaryConf");
            Requestor.validate((ValidatableConf[])new ValidatableConf[]{this.conf, this.binaryConf});
        }
    }

    public static class NameTypeConf
    extends ValidatableConf {
        private String name;
        private String type;
        private FileOrValue conf;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public void validate() throws InvalidConfException {
            NameTypeConf.notBlank((String)this.name, (String)"name");
            NameTypeConf.notBlank((String)this.type, (String)"type");
            NameTypeConf.validate((ValidatableConf[])new ValidatableConf[]{this.conf});
        }
    }

    public static class GenSelfIssued
    extends ValidatableConf {
        private String subject;
        private String profile;
        private String serialNumber;
        private String notBefore;
        private String notAfter;

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getProfile() {
            return this.profile;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getNotBefore() {
            return this.notBefore;
        }

        public void setNotBefore(String notBefore) {
            this.notBefore = notBefore;
        }

        public String getNotAfter() {
            return this.notAfter;
        }

        public void setNotAfter(String notAfter) {
            this.notAfter = notAfter;
        }

        public void validate() throws InvalidConfException {
            GenSelfIssued.notBlank((String)this.subject, (String)"subject");
        }
    }

    public static class CaUris
    extends ValidatableConf {
        private List<String> cacertUris;
        private List<String> crlUris;
        private List<String> deltaCrlUris;
        private List<String> ocspUris;

        public List<String> getCacertUris() {
            if (this.cacertUris == null) {
                this.cacertUris = new LinkedList<String>();
            }
            return this.cacertUris;
        }

        public void setCacertUris(List<String> cacertUris) {
            this.cacertUris = cacertUris;
        }

        public List<String> getCrlUris() {
            if (this.crlUris == null) {
                this.crlUris = new LinkedList<String>();
            }
            return this.crlUris;
        }

        public void setCrlUris(List<String> crlUris) {
            this.crlUris = crlUris;
        }

        public List<String> getDeltaCrlUris() {
            if (this.deltaCrlUris == null) {
                this.deltaCrlUris = new LinkedList<String>();
            }
            return this.deltaCrlUris;
        }

        public void setDeltaCrlUris(List<String> deltaCrlUris) {
            this.deltaCrlUris = deltaCrlUris;
        }

        public List<String> getOcspUris() {
            if (this.ocspUris == null) {
                this.ocspUris = new LinkedList<String>();
            }
            return this.ocspUris;
        }

        public void setOcspUris(List<String> ocspUris) {
            this.ocspUris = ocspUris;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class Ca
    extends ValidatableConf {
        private String name;
        private CaInfo caInfo;
        private List<String> aliases;
        private List<String> profiles;
        private List<CaHasRequestor> requestors;
        private List<String> publishers;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CaInfo getCaInfo() {
            return this.caInfo;
        }

        public void setCaInfo(CaInfo caInfo) {
            this.caInfo = caInfo;
        }

        public List<String> getAliases() {
            if (this.aliases == null) {
                this.aliases = new LinkedList<String>();
            }
            return this.aliases;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        public List<String> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<String>();
            }
            return this.profiles;
        }

        public void setProfiles(List<String> profiles) {
            this.profiles = profiles;
        }

        public List<CaHasRequestor> getRequestors() {
            if (this.requestors == null) {
                this.requestors = new LinkedList<CaHasRequestor>();
            }
            return this.requestors;
        }

        public void setRequestors(List<CaHasRequestor> requestors) {
            this.requestors = requestors;
        }

        public List<String> getPublishers() {
            if (this.publishers == null) {
                this.publishers = new LinkedList<String>();
            }
            return this.publishers;
        }

        public void setPublishers(List<String> publishers) {
            this.publishers = publishers;
        }

        public void validate() throws InvalidConfException {
            Ca.notBlank((String)this.name, (String)"name");
            Ca.validate((ValidatableConf[])new ValidatableConf[]{this.caInfo});
            Ca.validate((Collection[])new Collection[]{this.requestors});
        }
    }

    public static class CaInfo
    extends ValidatableConf {
        private FileOrBinary cert;
        private List<FileOrBinary> certchain;
        private Integer expirationPeriod;
        private Map<String, String> extraControl;
        private GenSelfIssued genSelfIssued;
        private Integer keepExpiredCertDays;
        private List<String> permissions;
        private String maxValidity;
        private Map<String, Object> crlControl;
        private Map<String, Object> ctlogControl;
        private Map<String, Object> revokeSuspendedControl;
        private String crlSignerName;
        private List<String> keypairGenNames;
        private boolean saveCert = true;
        private boolean saveKeyPair;
        private String signerType;
        private FileOrValue signerConf;
        private String status;
        private String validityMode;
        private long nextCrlNo;
        private Integer numCrls;
        private int snSize;
        private CaUris caUris;

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public List<FileOrBinary> getCertchain() {
            return this.certchain;
        }

        public void setCertchain(List<FileOrBinary> certchain) {
            this.certchain = certchain;
        }

        public Integer getExpirationPeriod() {
            return this.expirationPeriod;
        }

        public void setExpirationPeriod(Integer expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        public Map<String, String> getExtraControl() {
            return this.extraControl;
        }

        public void setExtraControl(Map<String, String> extraControl) {
            this.extraControl = extraControl;
        }

        public GenSelfIssued getGenSelfIssued() {
            return this.genSelfIssued;
        }

        public void setGenSelfIssued(GenSelfIssued genSelfIssued) {
            this.genSelfIssued = genSelfIssued;
        }

        public Integer getKeepExpiredCertDays() {
            return this.keepExpiredCertDays;
        }

        public void setKeepExpiredCertDays(Integer keepExpiredCertDays) {
            this.keepExpiredCertDays = keepExpiredCertDays;
        }

        public List<String> getPermissions() {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            return this.permissions;
        }

        public void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        public String getMaxValidity() {
            return this.maxValidity;
        }

        public void setMaxValidity(String maxValidity) {
            this.maxValidity = maxValidity;
        }

        public Map<String, Object> getCrlControl() {
            return this.crlControl;
        }

        public void setCrlControl(Map<String, Object> crlControl) {
            this.crlControl = crlControl;
        }

        public Map<String, Object> getCtlogControl() {
            return this.ctlogControl;
        }

        public void setCtlogControl(Map<String, Object> ctlogControl) {
            this.ctlogControl = ctlogControl;
        }

        public Map<String, Object> getRevokeSuspendedControl() {
            return this.revokeSuspendedControl;
        }

        public void setRevokeSuspendedControl(Map<String, Object> revokeSuspendedControl) {
            this.revokeSuspendedControl = revokeSuspendedControl;
        }

        public String getCrlSignerName() {
            return this.crlSignerName;
        }

        public void setCrlSignerName(String crlSignerName) {
            this.crlSignerName = crlSignerName;
        }

        public List<String> getKeypairGenNames() {
            return this.keypairGenNames;
        }

        public void setKeypairGenNames(List<String> keypairGenNames) {
            this.keypairGenNames = keypairGenNames;
        }

        public boolean isSaveCert() {
            return this.saveCert;
        }

        public void setSaveCert(boolean saveCert) {
            this.saveCert = saveCert;
        }

        public boolean isSaveKeyPair() {
            return this.saveKeyPair;
        }

        public void setSaveKeyPair(boolean saveKeyPair) {
            this.saveKeyPair = saveKeyPair;
        }

        public String getSignerType() {
            return this.signerType;
        }

        public void setSignerType(String signerType) {
            this.signerType = signerType;
        }

        public FileOrValue getSignerConf() {
            return this.signerConf;
        }

        public void setSignerConf(FileOrValue signerConf) {
            this.signerConf = signerConf;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getValidityMode() {
            return this.validityMode;
        }

        public void setValidityMode(String validityMode) {
            this.validityMode = validityMode;
        }

        public long getNextCrlNo() {
            return this.nextCrlNo;
        }

        public void setNextCrlNo(long nextCrlNo) {
            this.nextCrlNo = nextCrlNo;
        }

        public Integer getNumCrls() {
            return this.numCrls;
        }

        public void setNumCrls(Integer numCrls) {
            this.numCrls = numCrls;
        }

        public int getSnSize() {
            return this.snSize;
        }

        public void setSnSize(int snSize) {
            this.snSize = snSize > 20 ? 20 : Math.max(snSize, 1);
        }

        public CaUris getCaUris() {
            return this.caUris;
        }

        public void setCaUris(CaUris caUris) {
            this.caUris = caUris;
        }

        public void validate() throws InvalidConfException {
            if (this.genSelfIssued != null && this.cert != null) {
                throw new InvalidConfException("cert and genSelfIssued may not be both non-null");
            }
            CaInfo.notBlank((String)this.maxValidity, (String)"maxValidity");
            CaInfo.notBlank((String)this.signerType, (String)"signerType");
            CaInfo.notNull((Object)this.signerConf, (String)"signerConf");
            CaInfo.notBlank((String)this.status, (String)this.status);
            CaInfo.validate((ValidatableConf[])new ValidatableConf[]{this.genSelfIssued, this.cert, this.signerConf, this.caUris});
        }
    }

    public static class CaHasRequestor
    extends ValidatableConf {
        private String requestorName;
        private List<String> permissions;
        private List<String> profiles;

        public String getRequestorName() {
            return this.requestorName;
        }

        public void setRequestorName(String requestorName) {
            this.requestorName = requestorName;
        }

        public List<String> getPermissions() {
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            return this.permissions;
        }

        public void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        public List<String> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<String>();
            }
            return this.profiles;
        }

        public void setProfiles(List<String> profiles) {
            this.profiles = profiles;
        }

        public void validate() throws InvalidConfException {
            CaHasRequestor.notBlank((String)this.requestorName, (String)"requestorName");
            CaHasRequestor.notEmpty(this.permissions, (String)"permissions");
        }
    }

    public static class CaSystem
    extends ValidatableConf {
        private String basedir;
        private Map<String, String> properties;
        private Map<String, String> dbSchemas;
        private List<Signer> signers;
        private List<Requestor> requestors;
        private List<NameTypeConf> publishers;
        private List<NameTypeConf> profiles;
        private List<NameTypeConf> keypairGens;
        private List<Ca> cas;

        public String getBasedir() {
            return this.basedir;
        }

        public void setBasedir(String basedir) {
            this.basedir = basedir;
        }

        public Map<String, String> getProperties() {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public Map<String, String> getDbSchemas() {
            if (this.dbSchemas == null) {
                this.dbSchemas = new HashMap<String, String>();
            }
            return this.dbSchemas;
        }

        public void setDbSchemas(Map<String, String> dbSchemas) {
            this.dbSchemas = dbSchemas;
        }

        public List<Signer> getSigners() {
            if (this.signers == null) {
                this.signers = new LinkedList<Signer>();
            }
            return this.signers;
        }

        public void setSigners(List<Signer> signers) {
            this.signers = signers;
        }

        public List<Requestor> getRequestors() {
            if (this.requestors == null) {
                this.requestors = new LinkedList<Requestor>();
            }
            return this.requestors;
        }

        public void setRequestors(List<Requestor> requestors) {
            this.requestors = requestors;
        }

        public List<NameTypeConf> getPublishers() {
            if (this.publishers == null) {
                this.publishers = new LinkedList<NameTypeConf>();
            }
            return this.publishers;
        }

        public void setPublishers(List<NameTypeConf> publishers) {
            this.publishers = publishers;
        }

        public List<NameTypeConf> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<NameTypeConf>();
            }
            return this.profiles;
        }

        public void setProfiles(List<NameTypeConf> profiles) {
            this.profiles = profiles;
        }

        public List<NameTypeConf> getKeypairGens() {
            if (this.keypairGens == null) {
                this.keypairGens = new LinkedList<NameTypeConf>();
            }
            return this.keypairGens;
        }

        public void setKeypairGens(List<NameTypeConf> keypairGens) {
            this.keypairGens = keypairGens;
        }

        public List<Ca> getCas() {
            if (this.cas == null) {
                this.cas = new LinkedList<Ca>();
            }
            return this.cas;
        }

        public void setCas(List<Ca> cas) {
            this.cas = cas;
        }

        public void validate() throws InvalidConfException {
            CaSystem.validate((Collection[])new Collection[]{this.signers, this.requestors, this.publishers, this.profiles, this.cas});
        }
    }
}

