/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.List;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.HourMinute;
import org.xipki.util.StringUtil;
import org.xipki.util.TripleState;
import org.xipki.util.Validity;
import org.xipki.util.exception.InvalidConfException;

public class CrlControl {
    public static final String KEY_FULLCRL_INTERVALS = "fullcrl.intervals";
    public static final String KEY_DELTACRL_INTERVALS = "deltacrl.intervals";
    public static final String KEY_OVERLAP_MINUTES = "overlap.minutes";
    public static final String KEY_OVERLAP_DAYS = "overlap.days";
    public static final String KEY_OVERLAP = "overlap";
    public static final String KEY_INTERVAL_HOURS = "interval.hours";
    public static final String KEY_INTERVAL_TIME = "interval.time";
    public static final String KEY_FULLCRL_EXTENDED_NEXTUPDATE = "fullcrl.extended.nextupdate";
    public static final String KEY_EXCLUDE_REASON = "exclude.reason";
    public static final String KEY_INCLUDE_EXPIREDCERTS = "include.expiredcerts";
    public static final String KEY_INVALIDITY_DATE = "invalidity.date";
    private final int fullCrlIntervals;
    private final int deltaCrlIntervals;
    private final int intervalHours;
    private final long intervalMillis;
    private final Validity overlap;
    private final boolean extendedNextUpdate;
    private final HourMinute intervalDayTime;
    private final boolean excludeReason;
    private final boolean includeExpiredCerts;
    private TripleState invalidityDateMode = TripleState.optional;

    public CrlControl(String conf) throws InvalidConfException {
        this(CrlControl.toConfPairs(conf));
    }

    private static ConfPairs toConfPairs(String conf) throws InvalidConfException {
        try {
            return new ConfPairs(conf);
        }
        catch (RuntimeException ex) {
            throw new InvalidConfException(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    public CrlControl(ConfPairs props) throws InvalidConfException {
        HourMinute hm;
        Args.notNull((Object)props, (String)"props");
        String str = props.value(KEY_INVALIDITY_DATE);
        if (str != null) {
            this.invalidityDateMode = TripleState.valueOf((String)str);
        }
        this.excludeReason = CrlControl.getBoolean(props, KEY_EXCLUDE_REASON, false);
        this.includeExpiredCerts = CrlControl.getBoolean(props, KEY_INCLUDE_EXPIREDCERTS, false);
        this.fullCrlIntervals = CrlControl.getInteger(props, KEY_FULLCRL_INTERVALS, 7);
        this.deltaCrlIntervals = CrlControl.getInteger(props, KEY_DELTACRL_INTERVALS, 0);
        this.extendedNextUpdate = CrlControl.getBoolean(props, KEY_FULLCRL_EXTENDED_NEXTUPDATE, false);
        Validity ov = props.value(KEY_OVERLAP_DAYS) != null ? new Validity(CrlControl.getInteger(props, KEY_OVERLAP_DAYS, 1), Validity.Unit.DAY) : (props.value(KEY_OVERLAP_MINUTES) != null ? new Validity(CrlControl.getInteger(props, KEY_OVERLAP_MINUTES, 1440), Validity.Unit.MINUTE) : (props.value(KEY_OVERLAP) != null ? Validity.getInstance((String)props.value(KEY_OVERLAP)) : new Validity(1, Validity.Unit.DAY)));
        this.overlap = ov.getValidity() < 1 ? new Validity(3, Validity.Unit.DAY) : ov;
        int hours = CrlControl.getInteger(props, KEY_INTERVAL_HOURS, 24);
        if (hours < 1 || hours > 24 || 24 - 24 / hours * hours != 0) {
            throw new InvalidConfException("interval.hours " + hours + " not in [1,2,3,4,6,8,12,24]");
        }
        this.intervalHours = hours;
        this.intervalMillis = (long)hours * 60L * 60L * 1000L;
        str = props.value(KEY_INTERVAL_TIME);
        if (str == null) {
            hm = new HourMinute(1, 0);
        } else {
            List tokens = StringUtil.split((String)str.trim(), (String)":");
            if (tokens.size() != 2) {
                throw new InvalidConfException("invalid interval.time: '" + str + "'");
            }
            try {
                int hour = Integer.parseInt((String)tokens.get(0));
                int minute = Integer.parseInt((String)tokens.get(1));
                hm = new HourMinute(hour, minute);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidConfException("invalid interval.time: '" + str + "'");
            }
        }
        int i = 0;
        while (hm.getHour() - (i + 1) * this.intervalHours >= 0) {
            ++i;
        }
        this.intervalDayTime = i == 0 ? hm : new HourMinute(hm.getHour() - i * this.intervalHours, hm.getMinute());
        this.validate();
    }

    public String getConf() {
        return this.getConfPairs().getEncoded();
    }

    public ConfPairs getConfPairs() {
        return new ConfPairs().putPair(KEY_DELTACRL_INTERVALS, Integer.toString(this.deltaCrlIntervals)).putPair(KEY_EXCLUDE_REASON, Boolean.toString(this.excludeReason)).putPair(KEY_INCLUDE_EXPIREDCERTS, Boolean.toString(this.includeExpiredCerts)).putPair(KEY_FULLCRL_EXTENDED_NEXTUPDATE, Boolean.toString(this.extendedNextUpdate)).putPair(KEY_FULLCRL_INTERVALS, Integer.toString(this.fullCrlIntervals)).putPair(KEY_INTERVAL_HOURS, Integer.toString(this.intervalHours)).putPair(KEY_INTERVAL_TIME, this.intervalDayTime.toString()).putPair(KEY_INVALIDITY_DATE, this.invalidityDateMode.name()).putPair(KEY_OVERLAP, this.overlap.toString());
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        return StringUtil.concatObjects((Object)"  interval unit: ", (Object[])new Object[]{this.intervalHours, " hours", "\n  full CRL intervals: ", this.fullCrlIntervals, "\n  delta CRL intervals: ", this.deltaCrlIntervals, "\n  overlap: ", this.overlap, "\n  use extended nextUpdate: ", this.extendedNextUpdate, "\n  exclude reason: ", this.excludeReason, "\n  include expired certs: ", this.includeExpiredCerts, "\n  invalidity date mode: ", this.invalidityDateMode, "\n  intervalDayTime: ", "generate CRL at " + this.intervalDayTime, " UTC", verbose ? "\n  encoded: " : "", verbose ? this.getConf() : ""});
    }

    public int getFullCrlIntervals() {
        return this.fullCrlIntervals;
    }

    public int getDeltaCrlIntervals() {
        return this.deltaCrlIntervals;
    }

    public Validity getOverlap() {
        return this.overlap;
    }

    public HourMinute getIntervalDayTime() {
        return this.intervalDayTime;
    }

    public boolean isExtendedNextUpdate() {
        return this.extendedNextUpdate;
    }

    public boolean isExcludeReason() {
        return this.excludeReason;
    }

    public boolean isIncludeExpiredcerts() {
        return this.includeExpiredCerts;
    }

    public TripleState getInvalidityDateMode() {
        return this.invalidityDateMode;
    }

    public int getIntervalHours() {
        return this.intervalHours;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    public final void validate() throws InvalidConfException {
        if (this.fullCrlIntervals < this.deltaCrlIntervals) {
            throw new InvalidConfException("fullCRLIntervals may not be less than deltaCRLIntervals " + this.fullCrlIntervals + " < " + this.deltaCrlIntervals);
        }
        if (this.fullCrlIntervals < 1) {
            throw new InvalidConfException("fullCRLIntervals may not be less than 1: " + this.fullCrlIntervals);
        }
        if (this.deltaCrlIntervals < 0) {
            throw new InvalidConfException("deltaCRLIntervals may not be less than 0: " + this.deltaCrlIntervals);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrlControl)) {
            return false;
        }
        CrlControl obj2 = (CrlControl)obj;
        return this.deltaCrlIntervals == obj2.deltaCrlIntervals && this.excludeReason == obj2.excludeReason && this.extendedNextUpdate == obj2.extendedNextUpdate && this.fullCrlIntervals == obj2.fullCrlIntervals && this.includeExpiredCerts == obj2.includeExpiredCerts && this.intervalDayTime.equals((Object)obj2.intervalDayTime) && this.intervalHours == obj2.intervalHours && this.invalidityDateMode.equals((Object)obj2.invalidityDateMode) && this.overlap.equals((Object)obj2.overlap);
    }

    private static int getInteger(ConfPairs props, String propKey, int dfltValue) throws InvalidConfException {
        String str = props.value(propKey);
        if (str != null) {
            try {
                return Integer.parseInt(str.trim());
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfException(propKey + " does not have numeric value: " + str);
            }
        }
        return dfltValue;
    }

    private static boolean getBoolean(ConfPairs props, String propKey, boolean dfltValue) throws InvalidConfException {
        String str = props.value(propKey);
        if (str != null) {
            if ("true".equalsIgnoreCase(str = str.trim())) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            throw new InvalidConfException(propKey + " does not have boolean value: " + str);
        }
        return dfltValue;
    }
}

