/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.security.cert.CertificateException;
import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.Validity;
import org.xipki.util.exception.InvalidConfException;

public abstract class MgmtMessage {

    public static class CaEntryWrapper {
        private NameId ident;
        private CaStatus status;
        private Validity maxValidity;
        private String signerType;
        private String signerConf;
        private String crlControl;
        private String crlSignerName;
        private String ctlogControl;
        private String revokeSuspended;
        private List<String> keypairGenNames;
        private boolean saveCert;
        private boolean saveKeypair;
        private ValidityMode validityMode = ValidityMode.STRICT;
        private int permission;
        private int expirationPeriod;
        private int keepExpiredCertInDays;
        private String extraControl;
        private CaUris caUris;
        private byte[] certBytes;
        private List<byte[]> certchainBytes;
        private int serialNoLen;
        private long nextCrlNumber;
        private int numCrls;
        private CertRevocationInfo revocationInfo;

        public CaEntryWrapper() {
        }

        public CaEntryWrapper(CaEntry caEntry) {
            this.caUris = caEntry.getCaUris();
            if (caEntry.getCert() != null) {
                this.certBytes = caEntry.getCert().getEncoded();
            }
            if (CollectionUtil.isNotEmpty(caEntry.getCertchain())) {
                this.certchainBytes = new LinkedList<byte[]>();
                for (X509Cert m : caEntry.getCertchain()) {
                    this.certchainBytes.add(m.getEncoded());
                }
            }
            if (caEntry.getCrlControl() != null) {
                this.crlControl = caEntry.getCrlControl().getConf();
            }
            this.crlSignerName = caEntry.getCrlSignerName();
            if (caEntry.getCtlogControl() != null) {
                this.ctlogControl = caEntry.getCtlogControl().getConf();
            }
            this.expirationPeriod = caEntry.getExpirationPeriod();
            if (caEntry.getExtraControl() != null) {
                this.extraControl = caEntry.getExtraControl().getEncoded();
            }
            this.ident = caEntry.getIdent();
            this.keepExpiredCertInDays = caEntry.getKeepExpiredCertInDays();
            this.maxValidity = caEntry.getMaxValidity();
            this.nextCrlNumber = caEntry.getNextCrlNumber();
            this.numCrls = caEntry.getNumCrls();
            this.permission = caEntry.getPermission();
            this.revocationInfo = caEntry.getRevocationInfo();
            if (caEntry.getRevokeSuspendedControl() != null) {
                this.revokeSuspended = caEntry.getRevokeSuspendedControl().getConf();
            }
            this.saveCert = caEntry.isSaveCert();
            this.saveKeypair = caEntry.isSaveKeypair();
            this.keypairGenNames = caEntry.getKeypairGenNames();
            this.serialNoLen = caEntry.getSerialNoLen();
            this.signerConf = caEntry.getSignerConf();
            this.signerType = caEntry.getSignerType();
            this.status = caEntry.getStatus();
            this.validityMode = caEntry.getValidityMode();
        }

        public NameId getIdent() {
            return this.ident;
        }

        public void setIdent(NameId ident) {
            this.ident = ident;
        }

        public CaStatus getStatus() {
            return this.status;
        }

        public void setStatus(CaStatus status) {
            this.status = status;
        }

        public Validity getMaxValidity() {
            return this.maxValidity;
        }

        public void setMaxValidity(Validity maxValidity) {
            this.maxValidity = maxValidity;
        }

        public String getSignerType() {
            return this.signerType;
        }

        public void setSignerType(String signerType) {
            this.signerType = signerType;
        }

        public String getSignerConf() {
            return this.signerConf;
        }

        public void setSignerConf(String signerConf) {
            this.signerConf = signerConf;
        }

        public String getCrlControl() {
            return this.crlControl;
        }

        public void setCrlControl(String crlControl) {
            this.crlControl = crlControl;
        }

        public String getRevokeSuspended() {
            return this.revokeSuspended;
        }

        public void setRevokeSuspended(String revokeSuspended) {
            this.revokeSuspended = revokeSuspended;
        }

        public String getCrlSignerName() {
            return this.crlSignerName;
        }

        public void setCrlSignerName(String crlSignerName) {
            this.crlSignerName = crlSignerName;
        }

        public List<String> getKeypairGenNames() {
            return this.keypairGenNames;
        }

        public void setKeypairGenNames(List<String> keypairGenNames) {
            this.keypairGenNames = keypairGenNames;
        }

        public String getCtlogControl() {
            return this.ctlogControl;
        }

        public void setCtlogControl(String ctlogControl) {
            this.ctlogControl = ctlogControl;
        }

        public boolean isSaveCert() {
            return this.saveCert;
        }

        public void setSaveCert(boolean saveCert) {
            this.saveCert = saveCert;
        }

        public boolean isSaveKeypair() {
            return this.saveKeypair;
        }

        public void setSaveKeypair(boolean saveKeypair) {
            this.saveKeypair = saveKeypair;
        }

        public ValidityMode getValidityMode() {
            return this.validityMode;
        }

        public void setValidityMode(ValidityMode validityMode) {
            this.validityMode = validityMode;
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public int getExpirationPeriod() {
            return this.expirationPeriod;
        }

        public void setExpirationPeriod(int expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        public int getKeepExpiredCertInDays() {
            return this.keepExpiredCertInDays;
        }

        public void setKeepExpiredCertInDays(int keepExpiredCertInDays) {
            this.keepExpiredCertInDays = keepExpiredCertInDays;
        }

        public String getExtraControl() {
            return this.extraControl;
        }

        public void setExtraControl(String extraControl) {
            this.extraControl = extraControl;
        }

        public CaUris getCaUris() {
            return this.caUris;
        }

        public void setCaUris(CaUris caUris) {
            this.caUris = caUris;
        }

        public byte[] getCertBytes() {
            return this.certBytes;
        }

        public void setCertBytes(byte[] certBytes) {
            this.certBytes = certBytes;
        }

        public List<byte[]> getCertchainBytes() {
            return this.certchainBytes;
        }

        public void setCertchainBytes(List<byte[]> certchainBytes) {
            this.certchainBytes = certchainBytes;
        }

        public int getSerialNoLen() {
            return this.serialNoLen;
        }

        public void setSerialNoLen(int serialNoLen) {
            this.serialNoLen = serialNoLen;
        }

        public long getNextCrlNumber() {
            return this.nextCrlNumber;
        }

        public void setNextCrlNumber(long nextCrlNumber) {
            this.nextCrlNumber = nextCrlNumber;
        }

        public int getNumCrls() {
            return this.numCrls;
        }

        public void setNumCrls(int numCrls) {
            this.numCrls = numCrls;
        }

        public CertRevocationInfo getRevocationInfo() {
            return this.revocationInfo;
        }

        public void setRevocationInfo(CertRevocationInfo revocationInfo) {
            this.revocationInfo = revocationInfo;
        }

        public CaEntry toCaEntry() throws CertificateException, CaMgmtException, InvalidConfException {
            CaEntry rv = new CaEntry(this.ident, this.serialNoLen, this.nextCrlNumber, this.signerType, this.signerConf, this.caUris, this.numCrls, this.expirationPeriod);
            if (this.certBytes != null) {
                rv.setCert(X509Util.parseCert((byte[])this.certBytes));
            }
            if (CollectionUtil.isNotEmpty(this.certchainBytes)) {
                LinkedList<X509Cert> certchain = new LinkedList<X509Cert>();
                for (byte[] m : this.certchainBytes) {
                    certchain.add(X509Util.parseCert((byte[])m));
                }
                rv.setCertchain(certchain);
            }
            if (this.crlControl != null) {
                rv.setCrlControl(new CrlControl(this.crlControl));
            }
            if (this.ctlogControl != null) {
                rv.setCtlogControl(new CtlogControl(this.ctlogControl));
            }
            rv.setCrlSignerName(this.crlSignerName);
            rv.setKeypairGenNames(this.keypairGenNames);
            if (this.extraControl != null) {
                rv.setExtraControl(new ConfPairs(this.extraControl));
            }
            rv.setKeepExpiredCertInDays(this.keepExpiredCertInDays);
            rv.setMaxValidity(this.maxValidity);
            rv.setNextCrlNumber(this.nextCrlNumber);
            rv.setPermission(this.permission);
            rv.setRevocationInfo(this.revocationInfo);
            rv.setSaveCert(this.saveCert);
            rv.setSaveKeypair(this.saveKeypair);
            if (this.revokeSuspended != null) {
                rv.setRevokeSuspendedControl(new RevokeSuspendedControl(this.revokeSuspended));
            }
            rv.setSerialNoLen(this.serialNoLen);
            rv.setSignerConf(this.signerConf);
            rv.setStatus(this.status);
            rv.setValidityMode(this.validityMode);
            return rv;
        }
    }

    public static class SignerEntryWrapper {
        private String name;
        private String type;
        private String conf;
        private byte[] encodedCert;
        private boolean faulty;

        public SignerEntryWrapper() {
        }

        public SignerEntryWrapper(SignerEntry signerEntry) {
            this.name = signerEntry.getName();
            this.type = signerEntry.getType();
            this.conf = signerEntry.getConf();
            this.faulty = signerEntry.isFaulty();
            if (signerEntry.getBase64Cert() != null) {
                this.encodedCert = Base64.decode((String)signerEntry.getBase64Cert());
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setConf(String conf) {
            this.conf = conf;
        }

        public byte[] getEncodedCert() {
            return this.encodedCert;
        }

        public void setEncodedCert(byte[] encodedCert) {
            this.encodedCert = encodedCert;
        }

        public String getConf() {
            return this.conf;
        }

        public boolean isFaulty() {
            return this.faulty;
        }

        public void setFaulty(boolean faulty) {
            this.faulty = faulty;
        }

        public SignerEntry toSignerEntry() {
            String base64Cert = null;
            if (this.encodedCert != null) {
                base64Cert = Base64.encodeToString((byte[])this.encodedCert);
            }
            SignerEntry ret = new SignerEntry(this.name, this.type, this.conf, base64Cert);
            ret.setConfFaulty(this.faulty);
            return ret;
        }
    }

    public static enum MgmtAction {
        addCa,
        addCaAlias,
        addCertprofile,
        addCertprofileToCa,
        addDbSchema,
        addKeypairGen,
        addPublisher,
        addPublisherToCa,
        addRequestor,
        addRequestorToCa,
        addSigner,
        changeCa,
        changeCertprofile,
        changeDbSchema,
        changeKeypairGen,
        changePublisher,
        changeRequestor,
        changeSigner,
        clearPublishQueue,
        exportConf,
        generateCertificate,
        generateKeyCert,
        generateCrossCertificate,
        generateCrlOnDemand,
        generateRootCa,
        getAliasesForCa,
        getCa,
        getCaAliasNames,
        getCaNameForAlias,
        getCaNames,
        getCaSystemStatus,
        getCert,
        getCertprofile,
        getCertprofileNames,
        getCertprofilesForCa,
        getCrl,
        getCurrentCrl,
        getDbSchemas,
        getFailedCaNames,
        getInactiveCaNames,
        getKeypairGen,
        getKeypairGenNames,
        getPublisher,
        getPublisherNames,
        getPublishersForCa,
        getRequestor,
        getRequestorNames,
        getRequestorsForCa,
        getSigner,
        getSignerNames,
        getSuccessfulCaNames,
        getSupportedCertprofileTypes,
        getSupportedPublisherTypes,
        getSupportedSignerTypes,
        listCertificates,
        loadConf,
        notifyCaChange,
        removeCa,
        removeCaAlias,
        removeCertificate,
        removeCertprofile,
        removeCertprofileFromCa,
        removeDbSchema,
        removeKeypairGen,
        removePublisher,
        removePublisherFromCa,
        removeRequestor,
        removeRequestorFromCa,
        removeSigner,
        republishCertificates,
        restartCa,
        restartCaSystem,
        revokeCa,
        revokeCertficate,
        revokeCertificate,
        tokenInfoP11,
        unlockCa,
        unrevokeCa,
        unsuspendCertificate;


        public static MgmtAction ofName(String str) {
            for (MgmtAction action : MgmtAction.values()) {
                if (!action.name().equalsIgnoreCase(str)) continue;
                return action;
            }
            return null;
        }
    }
}

