/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.KeypairGenEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.KeyCertBytesPair;
import org.xipki.security.X509Cert;

public interface CaManager {
    public static final String NULL = "null";
    public static final int MIN_SERIALNUMBER_SIZE = 1;
    public static final int MAX_SERIALNUMBER_SIZE = 20;

    public CaSystemStatus getCaSystemStatus() throws CaMgmtException;

    public void unlockCa() throws CaMgmtException;

    public void notifyCaChange() throws CaMgmtException;

    public void addDbSchema(String var1, String var2) throws CaMgmtException;

    public void changeDbSchema(String var1, String var2) throws CaMgmtException;

    public void removeDbSchema(String var1) throws CaMgmtException;

    public Map<String, String> getDbSchemas() throws CaMgmtException;

    public void republishCertificates(String var1, List<String> var2, int var3) throws CaMgmtException;

    public void clearPublishQueue(String var1, List<String> var2) throws CaMgmtException;

    public void removeCa(String var1) throws CaMgmtException;

    public void restartCa(String var1) throws CaMgmtException;

    public void restartCaSystem() throws CaMgmtException;

    public void addCaAlias(String var1, String var2) throws CaMgmtException;

    public void removeCaAlias(String var1) throws CaMgmtException;

    public Set<String> getAliasesForCa(String var1) throws CaMgmtException;

    public String getCaNameForAlias(String var1) throws CaMgmtException;

    public Set<String> getCaAliasNames() throws CaMgmtException;

    public Set<String> getCertprofileNames() throws CaMgmtException;

    public Set<String> getKeypairGenNames() throws CaMgmtException;

    public Set<String> getPublisherNames() throws CaMgmtException;

    public Set<String> getRequestorNames() throws CaMgmtException;

    public Set<String> getSignerNames() throws CaMgmtException;

    public Set<String> getCaNames() throws CaMgmtException;

    public Set<String> getSuccessfulCaNames() throws CaMgmtException;

    public Set<String> getFailedCaNames() throws CaMgmtException;

    public Set<String> getInactiveCaNames() throws CaMgmtException;

    public void addCa(CaEntry var1) throws CaMgmtException;

    public CaEntry getCa(String var1) throws CaMgmtException;

    public void changeCa(ChangeCaEntry var1) throws CaMgmtException;

    public void removeCertprofileFromCa(String var1, String var2) throws CaMgmtException;

    public void addCertprofileToCa(String var1, String var2) throws CaMgmtException;

    public void removePublisherFromCa(String var1, String var2) throws CaMgmtException;

    public void addPublisherToCa(String var1, String var2) throws CaMgmtException;

    public Set<String> getCertprofilesForCa(String var1) throws CaMgmtException;

    public Set<CaHasRequestorEntry> getRequestorsForCa(String var1) throws CaMgmtException;

    public RequestorEntry getRequestor(String var1) throws CaMgmtException;

    public void addRequestor(RequestorEntry var1) throws CaMgmtException;

    public void removeRequestor(String var1) throws CaMgmtException;

    public void changeRequestor(String var1, String var2, String var3) throws CaMgmtException;

    public void removeRequestorFromCa(String var1, String var2) throws CaMgmtException;

    public void addRequestorToCa(CaHasRequestorEntry var1, String var2) throws CaMgmtException;

    public CertprofileEntry getCertprofile(String var1) throws CaMgmtException;

    public void removeCertprofile(String var1) throws CaMgmtException;

    public void changeCertprofile(String var1, String var2, String var3) throws CaMgmtException;

    public void addCertprofile(CertprofileEntry var1) throws CaMgmtException;

    public KeypairGenEntry getKeypairGen(String var1) throws CaMgmtException;

    public void removeKeypairGen(String var1) throws CaMgmtException;

    public void changeKeypairGen(String var1, String var2, String var3) throws CaMgmtException;

    public void addKeypairGen(KeypairGenEntry var1) throws CaMgmtException;

    public void addSigner(SignerEntry var1) throws CaMgmtException;

    public void removeSigner(String var1) throws CaMgmtException;

    public SignerEntry getSigner(String var1) throws CaMgmtException;

    public void changeSigner(String var1, String var2, String var3, String var4) throws CaMgmtException;

    public void addPublisher(PublisherEntry var1) throws CaMgmtException;

    public List<PublisherEntry> getPublishersForCa(String var1) throws CaMgmtException;

    public PublisherEntry getPublisher(String var1) throws CaMgmtException;

    public void removePublisher(String var1) throws CaMgmtException;

    public void changePublisher(String var1, String var2, String var3) throws CaMgmtException;

    public void revokeCa(String var1, CertRevocationInfo var2) throws CaMgmtException;

    public void unrevokeCa(String var1) throws CaMgmtException;

    public void revokeCertificate(String var1, BigInteger var2, CrlReason var3, Instant var4) throws CaMgmtException;

    public void unsuspendCertificate(String var1, BigInteger var2) throws CaMgmtException;

    public void removeCertificate(String var1, BigInteger var2) throws CaMgmtException;

    public X509Cert generateCertificate(String var1, String var2, byte[] var3, Instant var4, Instant var5) throws CaMgmtException;

    public KeyCertBytesPair generateKeyCert(String var1, String var2, String var3, Instant var4, Instant var5) throws CaMgmtException;

    public X509Cert generateCrossCertificate(String var1, String var2, byte[] var3, byte[] var4, Instant var5, Instant var6) throws CaMgmtException;

    public X509Cert generateRootCa(CaEntry var1, String var2, String var3, String var4, Instant var5, Instant var6) throws CaMgmtException;

    public X509CRLHolder generateCrlOnDemand(String var1) throws CaMgmtException;

    public X509CRLHolder getCrl(String var1, BigInteger var2) throws CaMgmtException;

    public X509CRLHolder getCurrentCrl(String var1) throws CaMgmtException;

    public CertWithRevocationInfo getCert(String var1, BigInteger var2) throws CaMgmtException;

    public CertWithRevocationInfo getCert(X500Name var1, BigInteger var2) throws CaMgmtException;

    public Map<String, X509Cert> loadConf(InputStream var1) throws CaMgmtException, IOException;

    public InputStream exportConf(List<String> var1) throws CaMgmtException, IOException;

    public List<CertListInfo> listCertificates(String var1, X500Name var2, Instant var3, Instant var4, CertListOrderBy var5, int var6) throws CaMgmtException;

    public Set<String> getSupportedSignerTypes() throws CaMgmtException;

    public Set<String> getSupportedCertprofileTypes() throws CaMgmtException;

    public Set<String> getSupportedPublisherTypes() throws CaMgmtException;

    public String getTokenInfoP11(String var1, Integer var2, boolean var3) throws CaMgmtException;
}

