/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.security.util.JSON;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class CaConfs {
    private static final String APP_DIR = "APP_DIR";

    private CaConfs() {
    }

    public static void marshal(CaConfType.CaSystem root, OutputStream out) throws InvalidConfException, IOException {
        Args.notNull((Object)((Object)root), (String)"root");
        Args.notNull((Object)out, (String)"out");
        root.validate();
        JSON.writePrettyJSON((Object)((Object)root), (OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream convertFileConfToZip(String confFilename) throws IOException, InvalidConfException {
        Args.notNull((Object)confFilename, (String)"confFilename");
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream(0x100000);
        try (ZipOutputStream zipStream = new ZipOutputStream(bytesStream);){
            byte[] bytes;
            Object value;
            String zipEntryName;
            String name;
            zipStream.setLevel(1);
            File confFile = new File(confFilename);
            confFile = IoUtil.expandFilepath((File)confFile, (boolean)false);
            CaConfType.CaSystem root = (CaConfType.CaSystem)((Object)JSON.parseObject((File)confFile, CaConfType.CaSystem.class));
            String baseDir = root.getBasedir();
            if (StringUtil.isBlank((String)baseDir)) {
                File confFileParent = confFile.getParentFile();
                baseDir = confFileParent == null ? "." : confFileParent.getPath();
            } else if (APP_DIR.equalsIgnoreCase(baseDir)) {
                baseDir = ".";
            }
            root.setBasedir(null);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (root.getProperties() != null) {
                properties.putAll(root.getProperties());
            }
            if (root.getSigners() != null) {
                for (CaConfType.Signer signer : root.getSigners()) {
                    name = signer.getName();
                    if (signer.getConf() != null) {
                        String conf = CaConfs.convertSignerConf(signer.getConf(), properties, baseDir);
                        if (conf.length() > 200) {
                            String zipEntryName2 = "files/signer-" + name + ".conf";
                            CaConfs.createFileOrValue(zipStream, conf, zipEntryName2);
                            signer.getConf().setFile(zipEntryName2);
                            signer.getConf().setValue(null);
                        } else {
                            signer.getConf().setFile(null);
                            signer.getConf().setValue(conf);
                        }
                    }
                    if (signer.getCert() == null || signer.getCert().getFile() == null) continue;
                    zipEntryName = "files/signer-" + name + ".crt";
                    value = CaConfs.getBinary(signer.getConf().getFile(), properties, baseDir);
                    CaConfs.createFileOrBinary(zipStream, value, zipEntryName);
                    signer.getCert().setFile(zipEntryName);
                }
            }
            if (root.getRequestors() != null) {
                for (CaConfType.Requestor requestor : root.getRequestors()) {
                    name = requestor.getName();
                    if (requestor.getConf() != null && requestor.getConf().getFile() != null) {
                        zipEntryName = "files/requestor-" + name + ".conf";
                        value = CaConfs.getValue(requestor.getConf().getFile(), properties, baseDir);
                        CaConfs.createFileOrValue(zipStream, (String)value, zipEntryName);
                        requestor.getConf().setFile(zipEntryName);
                    }
                    if (requestor.getBinaryConf() == null || requestor.getBinaryConf().getFile() == null) continue;
                    zipEntryName = "files/requestor-" + name + ".bin";
                    value = CaConfs.getBinary(requestor.getBinaryConf().getFile(), properties, baseDir);
                    CaConfs.createFileOrBinary(zipStream, value, zipEntryName);
                    requestor.getBinaryConf().setFile(zipEntryName);
                }
            }
            if (root.getPublishers() != null) {
                for (CaConfType.NameTypeConf nameTypeConf : root.getPublishers()) {
                    if (nameTypeConf.getConf() == null || nameTypeConf.getConf().getFile() == null) continue;
                    name = nameTypeConf.getName();
                    zipEntryName = "files/publisher-" + name + ".conf";
                    value = CaConfs.getValue(nameTypeConf.getConf().getFile(), properties, baseDir);
                    CaConfs.createFileOrValue(zipStream, (String)value, zipEntryName);
                    nameTypeConf.getConf().setFile(zipEntryName);
                }
            }
            if (root.getProfiles() != null) {
                for (CaConfType.NameTypeConf nameTypeConf : root.getProfiles()) {
                    if (nameTypeConf.getConf() == null || nameTypeConf.getConf().getFile() == null) continue;
                    name = nameTypeConf.getName();
                    zipEntryName = "files/certprofile-" + name + ".conf";
                    value = CaConfs.getValue(nameTypeConf.getConf().getFile(), properties, baseDir);
                    CaConfs.createFileOrValue(zipStream, (String)value, zipEntryName);
                    nameTypeConf.getConf().setFile(zipEntryName);
                }
            }
            if (root.getCas() != null) {
                for (CaConfType.Ca ca : root.getCas()) {
                    if (ca.getCaInfo() == null) continue;
                    name = ca.getName();
                    CaConfType.CaInfo ci = ca.getCaInfo();
                    if (ci.getSignerConf() != null) {
                        FileOrValue fv = ci.getSignerConf();
                        String conf = CaConfs.convertSignerConf(fv, properties, baseDir);
                        if (conf.length() > 200) {
                            String zipEntryName3 = "files/ca-" + name + "-signer.conf";
                            CaConfs.createFileOrValue(zipStream, conf, zipEntryName3);
                            fv.setFile(zipEntryName3);
                            fv.setValue(null);
                        } else {
                            fv.setFile(null);
                            fv.setValue(conf);
                        }
                    }
                    if (ci.getGenSelfIssued() == null) {
                        if (ci.getCert() != null && ci.getCert().getFile() != null) {
                            String zipEntryName4 = "files/ca-" + name + ".crt";
                            byte[] value2 = CaConfs.getBinary(ci.getCert().getFile(), properties, baseDir);
                            CaConfs.createFileOrBinary(zipStream, value2, zipEntryName4);
                            ci.getCert().setFile(zipEntryName4);
                        }
                        if (!CollectionUtil.isNotEmpty(ci.getCertchain())) continue;
                        for (int i = 0; i < ci.getCertchain().size(); ++i) {
                            FileOrBinary fi = ci.getCertchain().get(i);
                            if (fi.getFile() == null) continue;
                            String zipEntryName2 = "files/cacerts-" + name + "-" + i + ".crt";
                            byte[] value3 = CaConfs.getBinary(fi.getFile(), properties, baseDir);
                            CaConfs.createFileOrBinary(zipStream, value3, zipEntryName2);
                            fi.setFile(zipEntryName2);
                        }
                        continue;
                    }
                    if (ci.getCert() == null) continue;
                    throw new InvalidConfException("cert of CA " + name + " may not be set");
                }
            }
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                CaConfs.marshal(root, byteArrayOutputStream);
                bytes = byteArrayOutputStream.toByteArray();
            }
            zipStream.putNextEntry(new ZipEntry("caconf.json"));
            try {
                zipStream.write(bytes);
            }
            finally {
                zipStream.closeEntry();
            }
        }
        return new ByteArrayInputStream(bytesStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileOrValue(ZipOutputStream zipStream, String content, String fileName) throws IOException {
        ZipEntry certZipEntry = new ZipEntry(fileName);
        zipStream.putNextEntry(certZipEntry);
        try {
            zipStream.write(StringUtil.toUtf8Bytes((String)content));
        }
        finally {
            zipStream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileOrBinary(ZipOutputStream zipStream, byte[] content, String fileName) throws IOException {
        ZipEntry certZipEntry = new ZipEntry(fileName);
        zipStream.putNextEntry(certZipEntry);
        try {
            zipStream.write(content);
        }
        finally {
            zipStream.closeEntry();
        }
    }

    private static String getValue(String fileName, Map<String, String> properties, String baseDir) throws IOException {
        byte[] binary = CaConfs.getBinary(fileName, properties, baseDir);
        return StringUtil.toUtf8String((byte[])binary);
    }

    private static byte[] getBinary(String fileName, Map<String, String> properties, String baseDir) throws IOException {
        fileName = CaConfs.expandConf(fileName, properties);
        return IoUtil.read((File)Paths.get(CaConfs.resolveFilePath(fileName, baseDir), new String[0]).toFile());
    }

    private static String expandConf(String confStr, Map<String, String> properties) {
        if (confStr == null || !confStr.contains("${") || confStr.indexOf(125) == -1) {
            return confStr;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String placeHolder = "${" + name + "}";
            while (confStr.contains(placeHolder)) {
                confStr = confStr.replace(placeHolder, entry.getValue());
            }
        }
        return confStr;
    }

    private static String resolveFilePath(String filePath, String baseDir) {
        File file = new File(filePath);
        return file.isAbsolute() ? filePath : new File(baseDir, filePath).getPath();
    }

    private static String convertSignerConf(FileOrValue confFv, Map<String, String> properties, String baseDir) throws IOException {
        String conf = confFv.getValue() != null ? confFv.getValue() : CaConfs.getValue(confFv.getFile(), properties, baseDir);
        if (!(conf = CaConfs.expandConf(conf, properties)).contains("file:")) {
            return conf;
        }
        ConfPairs confPairs = new ConfPairs(conf);
        boolean changed = false;
        for (String name : confPairs.names()) {
            String value = confPairs.value(name);
            if (!value.startsWith("file:")) continue;
            changed = true;
            String fileName = value.substring("file:".length());
            byte[] binValue = CaConfs.getBinary(fileName, properties, baseDir);
            confPairs.putPair(name, "base64:" + Base64.encodeToString((byte[])binValue));
        }
        return changed ? confPairs.getEncoded() : conf;
    }

    public static void checkName(String param, String paramName) throws InvalidConfException {
        if (param == null || param.isEmpty()) {
            throw new InvalidConfException(paramName + " must not be blank");
        }
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '_' || c == '.') continue;
            throw new InvalidConfException("invalid char '" + c + "' in " + paramName);
        }
    }
}

