/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class CaProfileEntry {
    private final String profileName;
    private final List<String> profileAliases;
    private final String encoded;

    public static CaProfileEntry decode(String encoded) {
        String[] tokens = encoded.split(":");
        if (tokens.length < 1) {
            throw new IllegalArgumentException("invalid encoded '" + encoded + "'");
        }
        String name = tokens[0];
        String[] list = tokens.length == 1 ? null : tokens[1].split(",");
        List<String> aliases = list == null ? null : List.of(list);
        return new CaProfileEntry(name, aliases);
    }

    public CaProfileEntry(String profileName, List<String> profileAliases) {
        this.profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        if (profileAliases == null) {
            this.profileAliases = Collections.emptyList();
        } else {
            this.profileAliases = new ArrayList<String>(profileAliases.size());
            for (String alias : profileAliases) {
                String lcAlias = alias.toLowerCase(Locale.ROOT);
                if (this.profileName.equals(lcAlias) || this.profileAliases.contains(lcAlias)) continue;
                this.profileAliases.add(lcAlias);
            }
            Collections.sort(this.profileAliases);
        }
        if (CollectionUtil.isEmpty(this.profileAliases)) {
            this.encoded = profileName;
        } else {
            StringBuilder str = new StringBuilder(profileName + ":" + this.profileAliases.get(0));
            if (this.profileAliases.size() > 1) {
                for (int i = 1; i < this.profileAliases.size(); ++i) {
                    str.append(",").append(this.profileAliases.get(i));
                }
            }
            this.encoded = str.toString();
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public List<String> getProfileAliases() {
        return this.profileAliases;
    }

    public boolean containsNameOrAlias(String nameOrAlias) {
        String lcNameOrAlias = Args.toNonBlankLower((String)nameOrAlias, (String)"nameOrAlias");
        return this.profileName.equals(lcNameOrAlias) || this.profileAliases.contains(lcNameOrAlias);
    }

    public String containedNameOrAlias(CaProfileEntry other) {
        if (this.containsNameOrAlias(other.profileName)) {
            return other.profileName;
        }
        for (String alias : other.getProfileAliases()) {
            if (!this.containsNameOrAlias(alias)) continue;
            return alias;
        }
        return null;
    }

    public String getEncoded() {
        return this.encoded;
    }

    public String toString() {
        return this.encoded;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CaProfileEntry)) {
            return false;
        }
        return this.encoded.equals(((CaProfileEntry)other).encoded);
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }
}

