/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import java.util.Arrays;
import java.util.List;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class CtlogControl {
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_SERVERS = "servers";
    public static final String KEY_SSLCONTEXT_NAME = "sslcontext.name";
    private boolean enabled;
    private String sslContextName;
    private List<String> servers;
    private ConfPairs confPairs;

    public CtlogControl(String conf) throws InvalidConfException {
        this(new ConfPairs((String)Args.notNull((Object)conf, (String)"conf")));
    }

    public CtlogControl(ConfPairs pairs) throws InvalidConfException {
        Args.notNull((Object)pairs, (String)"pairs");
        this.enabled = CtlogControl.getBoolean(pairs, KEY_ENABLED, false);
        pairs.putPair(KEY_ENABLED, Boolean.toString(this.enabled));
        this.sslContextName = pairs.value(KEY_SSLCONTEXT_NAME);
        String serverList = pairs.value(KEY_SERVERS);
        List<String> list = this.servers = serverList == null ? null : Arrays.asList(serverList.split(";"));
        if (this.servers == null || this.servers.isEmpty()) {
            throw new InvalidConfException("servers is not specified");
        }
        this.confPairs = pairs;
    }

    public CtlogControl(Boolean enabled, List<String> servers, String sslContextName) {
        Args.notEmpty(servers, (String)KEY_SERVERS);
        ConfPairs pairs = new ConfPairs();
        this.enabled = enabled != null && enabled != false;
        pairs.putPair(KEY_ENABLED, Boolean.toString(this.enabled)).putPair(KEY_SERVERS, StringUtil.collectionAsString(servers, (String)";"));
        this.servers = servers;
        this.sslContextName = sslContextName;
        if (sslContextName != null) {
            pairs.putPair(KEY_SSLCONTEXT_NAME, sslContextName);
        }
        this.confPairs = pairs;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getConf() {
        return this.getConfPairs().getEncoded();
    }

    public ConfPairs getConfPairs() {
        return this.confPairs;
    }

    public String getSslContextName() {
        return this.sslContextName;
    }

    public void setSslContextName(String sslContextName) {
        this.sslContextName = sslContextName;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConf(ConfPairs confPairs) {
        this.confPairs = confPairs;
    }

    public int hashCode() {
        return this.getConf().hashCode();
    }

    public String toString() {
        return StringUtil.concatObjects((Object)"  enabled:          ", (Object[])new Object[]{this.enabled, "\n  SSL context name: ", this.sslContextName, "\n  Servers:          ", this.servers});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CtlogControl)) {
            return false;
        }
        return this.confPairs.equals((Object)((CtlogControl)obj).confPairs);
    }

    private static boolean getBoolean(ConfPairs pairs, String key, boolean defaultValue) {
        String str = pairs.value(key);
        boolean ret = StringUtil.isBlank((String)str) ? defaultValue : Boolean.parseBoolean(str);
        pairs.putPair(key, Boolean.toString(ret));
        return ret;
    }
}

