/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.util.Collections;
import java.util.Set;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.PermissionConstants;

public class CaHasRequestorEntry
extends MgmtEntry {
    private NameId requestorIdent;
    private int permission;
    private Set<String> profiles;

    private CaHasRequestorEntry() {
    }

    public CaHasRequestorEntry(NameId requestorIdent) {
        this.requestorIdent = (NameId)Args.notNull((Object)requestorIdent, (String)"requestorIdent");
    }

    public int getPermission() {
        return this.permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public NameId getRequestorIdent() {
        return this.requestorIdent;
    }

    public void setRequestorIdent(NameId requestorIdent) {
        this.requestorIdent = requestorIdent;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = CollectionUtil.isEmpty(profiles) ? Collections.emptySet() : CollectionUtil.unmodifiableSet((Set)CollectionUtil.toLowerCaseSet(profiles));
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public boolean isCertprofilePermitted(String certprofile) {
        if (CollectionUtil.isEmpty(this.profiles)) {
            return false;
        }
        return this.profiles.contains("all") || this.profiles.contains(certprofile.toLowerCase());
    }

    public boolean isPermitted(int permission) {
        return PermissionConstants.contains((int)this.permission, (int)permission);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return indent + "requestor:  " + this.requestorIdent + "\n" + indent + "profiles:   " + this.profiles + "\n" + indent + "permission: " + PermissionConstants.permissionToString((int)this.permission);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaHasRequestorEntry)) {
            return false;
        }
        return this.equals((CaHasRequestorEntry)obj, false);
    }

    public boolean equals(CaHasRequestorEntry obj, boolean ignoreId) {
        return obj != null && this.requestorIdent.equals(obj.requestorIdent, ignoreId) && this.permission == obj.permission && CompareUtil.equalsObject(this.profiles, obj.profiles);
    }

    public int hashCode() {
        return this.requestorIdent.hashCode();
    }
}

