/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.util.Arrays;
import java.util.Collections;
import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;

public class KeypairGenEntry
extends MgmtEntry {
    private String name;
    private String type;
    private String conf;
    private boolean faulty;

    private KeypairGenEntry() {
    }

    public KeypairGenEntry(String name, String type, String conf) {
        this.name = Args.toNonBlankLower((String)name, (String)"name");
        this.type = Args.toNonBlankLower((String)type, (String)"type");
        this.conf = conf;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getConf() {
        return this.conf;
    }

    public void faulty(boolean faulty) {
        this.faulty = faulty;
    }

    public boolean faulty() {
        return this.faulty;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean ignoreSensitiveInfo) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("name:   ").append(this.name).append('\n');
        sb.append("faulty: ").append(this.faulty()).append('\n');
        sb.append("type:   ").append(this.type).append('\n');
        sb.append("conf:   ");
        if (this.conf == null) {
            sb.append("null");
        } else if (ignoreSensitiveInfo) {
            try {
                sb.append(new ConfPairs(this.conf).toStringOmitSensitive(Arrays.asList("key", "password"), Collections.singletonList("keyspec")));
            }
            catch (Exception ex) {
                sb.append(this.conf);
            }
        } else {
            sb.append(this.conf);
        }
        sb.append('\n');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeypairGenEntry)) {
            return false;
        }
        KeypairGenEntry objB = (KeypairGenEntry)obj;
        return this.name.equals(objB.name) && this.type.equals(objB.type) && CompareUtil.equalsObject((Object)this.conf, (Object)objB.conf);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

