/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.security.cert.CertificateException;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class RequestorEntry
extends MgmtEntry {
    public static final String TYPE_CERT = "cert";
    private NameId ident;
    private String type;
    private String conf;
    private boolean faulty;

    private RequestorEntry() {
    }

    public RequestorEntry(NameId ident, String type, String conf) {
        this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        String name = ident.getName();
        if ("by-ca".equals(name)) {
            throw new IllegalArgumentException("Requestor name could not be " + name);
        }
        this.type = Args.notBlank((String)type, (String)"type");
        this.conf = Args.notBlank((String)conf, (String)"conf");
    }

    public void setIdent(NameId ident) {
        this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        String name = ident.getName();
        if ("by-ca".equals(name)) {
            throw new IllegalArgumentException("Requestor name could not be " + name);
        }
    }

    public void setType(String type) {
        this.type = Args.notBlank((String)type, (String)"type");
    }

    public void setConf(String conf) {
        this.conf = Args.notBlank((String)conf, (String)"conf");
    }

    public NameId getIdent() {
        return this.ident;
    }

    public String getType() {
        return this.type;
    }

    public String getConf() {
        return this.conf;
    }

    public void faulty(boolean faulty) {
        this.faulty = faulty;
    }

    public boolean faulty() {
        return this.faulty;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder(500);
        sb.append("id:     ").append(this.ident.getId());
        sb.append("\nname:   ").append(this.ident.getName());
        sb.append("\ntype:   ").append(this.type);
        sb.append("\nconf:   ");
        if (verbose || this.conf.length() < 101) {
            sb.append(this.conf);
        } else {
            sb.append(this.conf, 0, 97).append("...");
        }
        sb.append("\nfaulty: ").append(this.faulty).append('\n');
        if (!this.faulty && TYPE_CERT.equalsIgnoreCase(this.type)) {
            sb.append("cert:\n");
            try {
                X509Cert cert = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)this.conf));
                sb.append(X509Util.formatCert((X509Cert)cert, (boolean)false));
            }
            catch (CertificateException ex) {
                sb.append("  ERROR(").append(ex.getMessage()).append(")\n");
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequestorEntry)) {
            return false;
        }
        return this.equals((RequestorEntry)obj, false);
    }

    public boolean equals(RequestorEntry obj, boolean ignoreId) {
        return obj != null && this.ident.equals(obj.ident, ignoreId) && this.type.equals(obj.type) && this.conf.equals(obj.conf);
    }

    public int hashCode() {
        return this.ident.hashCode();
    }
}

