/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;
import org.xipki.util.StringUtil;

public class SignerEntry
extends MgmtEntry {
    private final String name;
    private final String type;
    private String conf;
    private boolean certFaulty;
    private boolean confFaulty;
    private final String base64Cert;
    private X509Cert certificate;

    public SignerEntry(String name, String type, String conf, String base64Cert) {
        this.name = Args.toNonBlankLower((String)name, (String)"name");
        this.type = Args.toNonBlankLower((String)type, (String)"type");
        this.conf = conf;
        this.base64Cert = base64Cert;
        if (base64Cert == null) {
            return;
        }
        try {
            this.certificate = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)base64Cert));
        }
        catch (Throwable th) {
            this.certFaulty = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public String getConf() {
        return this.conf;
    }

    public X509Cert getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Cert certificate) {
        if (this.base64Cert != null) {
            throw new IllegalStateException("certificate is already specified by base64Cert");
        }
        this.certificate = certificate;
    }

    public String getBase64Cert() {
        return this.base64Cert;
    }

    public boolean isFaulty() {
        return this.confFaulty || this.certFaulty;
    }

    public void setConfFaulty(boolean confFaulty) {
        this.confFaulty = confFaulty;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        return this.toString(verbose, true);
    }

    public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("name:   ").append(this.name).append('\n');
        sb.append("faulty: ").append(this.isFaulty()).append('\n');
        sb.append("type:   ").append(this.type).append('\n');
        sb.append("conf:   ");
        if (this.conf == null) {
            sb.append("null");
        } else {
            sb.append(SignerEntry.signerConfToString(this.conf, verbose, ignoreSensitiveInfo));
        }
        sb.append('\n');
        sb.append("cert:   ").append("\n");
        if (this.certificate != null || this.base64Cert != null) {
            if (this.certificate != null) {
                sb.append(X509Util.formatCert((X509Cert)this.certificate, (boolean)verbose));
            } else {
                sb.append("  encoded: ").append(this.base64Cert);
            }
        } else {
            sb.append("  null");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SignerEntry)) {
            return false;
        }
        SignerEntry objB = (SignerEntry)obj;
        return this.name.equals(objB.name) && this.type.equals(objB.type) && CompareUtil.equalsObject((Object)this.conf, (Object)objB.conf) && CompareUtil.equalsObject((Object)this.base64Cert, (Object)objB.base64Cert);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static String signerConfToString(String signerConf, boolean verbose, boolean ignoreSensitiveInfo) {
        Args.notBlank((String)signerConf, (String)"signerConf");
        if (ignoreSensitiveInfo) {
            signerConf = SignerConf.eraseSensitiveData((String)signerConf);
        }
        if (verbose || signerConf.length() < 101) {
            return signerConf;
        }
        return StringUtil.concat((String)signerConf.substring(0, 97), (String[])new String[]{"..."});
    }
}

