/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.util.List;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.Permissions;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.security.CertRevocationInfo;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;
import org.xipki.util.exception.InvalidConfException;

public abstract class BaseCaInfo
extends MgmtEntry {
    private CaUris caUris;
    private String crlSignerName;
    private int expirationPeriod = 365;
    private int keepExpiredCertDays = -1;
    private List<String> keypairGenNames;
    private long nextCrlNo;
    private Validity maxValidity;
    private int numCrls = 30;
    private CertRevocationInfo revocationInfo;
    private boolean saveCert = true;
    private boolean saveKeypair = false;
    private String signerType;
    private int snSize = 20;
    private CaStatus status = CaStatus.active;
    private Permissions permissions;
    private CrlControl crlControl;
    private CtlogControl ctlogControl;
    private RevokeSuspendedControl revokeSuspendedControl;
    private ConfPairs extraControl;
    private ValidityMode validityMode = ValidityMode.strict;

    public final CaUris getCaUris() {
        return this.caUris;
    }

    public final void setCaUris(CaUris caUris) {
        this.caUris = caUris;
    }

    public final String getCrlSignerName() {
        return this.crlSignerName;
    }

    public final void setCrlSignerName(String crlSignerName) {
        this.crlSignerName = StringUtil.lowercase((String)crlSignerName);
    }

    public final int getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public final void setExpirationPeriod(int expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
    }

    public int getKeepExpiredCertDays() {
        return this.keepExpiredCertDays;
    }

    public void setKeepExpiredCertDays(int keepExpiredCertDays) {
        this.keepExpiredCertDays = keepExpiredCertDays;
    }

    public final List<String> getKeypairGenNames() {
        return this.keypairGenNames;
    }

    public final void setKeypairGenNames(List<String> keypairGenNames) {
        this.keypairGenNames = StringUtil.lowercase(keypairGenNames);
    }

    public final long getNextCrlNo() {
        return this.nextCrlNo;
    }

    public final void setNextCrlNo(long nextCrlNo) {
        this.nextCrlNo = nextCrlNo;
    }

    public final Validity getMaxValidity() {
        return this.maxValidity;
    }

    public final void setMaxValidity(Validity maxValidity) {
        this.maxValidity = maxValidity;
    }

    public final int getNumCrls() {
        return this.numCrls;
    }

    public final void setNumCrls(int numCrls) {
        this.numCrls = numCrls;
    }

    public final CertRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }

    public final void setRevocationInfo(CertRevocationInfo revocationInfo) {
        this.revocationInfo = revocationInfo;
    }

    public final boolean isSaveCert() {
        return this.saveCert;
    }

    public final void setSaveCert(boolean saveCert) {
        this.saveCert = saveCert;
    }

    public final boolean isSaveKeypair() {
        return this.saveKeypair;
    }

    public final void setSaveKeypair(boolean saveKeypair) {
        this.saveKeypair = saveKeypair;
    }

    public final String getSignerType() {
        return this.signerType;
    }

    public final void setSignerType(String signerType) {
        this.signerType = signerType;
    }

    public final int getSnSize() {
        return this.snSize;
    }

    public final void setSnSize(int snSize) {
        this.snSize = snSize > 20 ? 20 : Math.max(snSize, 1);
    }

    public final CaStatus getStatus() {
        return this.status;
    }

    public final void setStatus(CaStatus status) {
        this.status = status;
    }

    public final ValidityMode getValidityMode() {
        return this.validityMode;
    }

    public final void setValidityMode(ValidityMode validityMode) {
        this.validityMode = validityMode;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public final CrlControl getCrlControl() {
        return this.crlControl;
    }

    public final void setCrlControl(CrlControl crlControl) {
        this.crlControl = crlControl;
    }

    public final CtlogControl getCtlogControl() {
        return this.ctlogControl;
    }

    public final void setCtlogControl(CtlogControl ctlogControl) {
        this.ctlogControl = ctlogControl;
    }

    public final RevokeSuspendedControl getRevokeSuspendedControl() {
        return this.revokeSuspendedControl;
    }

    public final void setRevokeSuspendedControl(RevokeSuspendedControl revokeSuspendedControl) {
        this.revokeSuspendedControl = revokeSuspendedControl;
    }

    public final ConfPairs getExtraControl() {
        return this.extraControl;
    }

    public final void setExtraControl(ConfPairs extraControl) {
        this.extraControl = extraControl;
    }

    @Override
    public void validate() throws InvalidConfException {
        BaseCaInfo.notNull((Object)this.maxValidity, (String)"maxValidity");
        BaseCaInfo.notBlank((String)this.signerType, (String)"signerType");
        BaseCaInfo.notNull((Object)((Object)this.status), (String)"status");
    }

    protected boolean equals(BaseCaInfo obj, boolean ignoreDynamicFields) {
        if (!ignoreDynamicFields && this.nextCrlNo != obj.nextCrlNo) {
            return false;
        }
        return CompareUtil.equalsObject((Object)this.caUris, (Object)obj.caUris) && CompareUtil.equalsObject((Object)this.crlSignerName, (Object)obj.crlSignerName) && this.expirationPeriod == obj.expirationPeriod && this.keepExpiredCertDays == obj.keepExpiredCertDays && CompareUtil.equalsObject(this.keypairGenNames, obj.keypairGenNames) && CompareUtil.equalsObject((Object)this.maxValidity, (Object)obj.maxValidity) && this.numCrls == obj.numCrls && CompareUtil.equalsObject((Object)this.revocationInfo, (Object)obj.revocationInfo) && this.saveCert == obj.saveCert && this.saveKeypair == obj.saveKeypair && this.signerType.equals(obj.signerType) && this.snSize == obj.snSize && CompareUtil.equalsObject((Object)((Object)this.status), (Object)((Object)obj.status)) && CompareUtil.equalsObject((Object)((Object)this.validityMode), (Object)((Object)obj.validityMode)) && CompareUtil.equalsObject((Object)this.permissions, (Object)obj.permissions) && CompareUtil.equalsObject((Object)this.crlControl, (Object)obj.crlControl) && CompareUtil.equalsObject((Object)this.ctlogControl, (Object)obj.ctlogControl) && CompareUtil.equalsObject((Object)this.extraControl, (Object)obj.extraControl) && CompareUtil.equalsObject((Object)this.revokeSuspendedControl, (Object)obj.revokeSuspendedControl);
    }

    public void copyBaseInfoTo(BaseCaInfo dest) {
        dest.nextCrlNo = this.nextCrlNo;
        dest.caUris = this.caUris;
        if (this.caUris == null) {
            dest.caUris = CaUris.EMPTY_INSTANCE;
        }
        dest.crlSignerName = this.crlSignerName;
        dest.expirationPeriod = this.expirationPeriod;
        dest.keepExpiredCertDays = this.keepExpiredCertDays;
        dest.keypairGenNames = this.keypairGenNames;
        dest.maxValidity = this.maxValidity;
        dest.numCrls = this.numCrls;
        dest.revocationInfo = this.revocationInfo;
        dest.saveCert = this.saveCert;
        dest.saveKeypair = this.saveKeypair;
        dest.signerType = this.signerType;
        dest.snSize = this.snSize;
        dest.status = this.status;
        dest.validityMode = this.validityMode;
        dest.permissions = this.permissions;
        dest.crlControl = this.crlControl;
        dest.ctlogControl = this.ctlogControl;
        dest.revokeSuspendedControl = this.revokeSuspendedControl;
        dest.extraControl = this.extraControl;
    }

    protected String toString(boolean verbose) {
        String extraCtrlText;
        if (this.extraControl == null) {
            extraCtrlText = "-";
        } else {
            extraCtrlText = this.extraControl.getEncoded();
            if (!verbose && extraCtrlText.length() > 100) {
                extraCtrlText = StringUtil.concat((String)extraCtrlText.substring(0, 97), (String[])new String[]{"..."});
            }
        }
        String revInfoText = "";
        if (this.revocationInfo != null) {
            revInfoText = StringUtil.concatObjectsCap((int)30, (Object)"\n\treason: ", (Object[])new Object[]{this.revocationInfo.getReason().getDescription(), "\n\trevoked at ", this.revocationInfo.getRevocationTime()});
        }
        return StringUtil.concatObjectsCap((int)1500, (Object)"\nsigner type:          ", (Object[])new Object[]{this.signerType, "\nstatus:               ", this.status == null ? "-" : this.status.getStatus(), "\nmax. validity:        ", this.maxValidity, "\nexpiration period:    ", this.expirationPeriod, "d", "\nCRL signer name:      ", this.crlSignerName == null ? "-" : this.crlSignerName, "\nsave certificate:     ", this.saveCert, "\nsave keypair:         ", this.saveKeypair, "\nvalidity mode:        ", this.validityMode, "\npermission:           ", this.permissions, "\nkeep expired certs:   ", this.keepExpiredCertDays < 0 ? "forever" : this.keepExpiredCertDays + " days", "\nextra control:        ", extraCtrlText, "\nserial number length: ", this.snSize, " bytes", "\nrevocation:           ", this.revocationInfo == null ? "not revoked" : "revoked", revInfoText, "\nnext CRL number:      ", this.nextCrlNo, "\nKeyPair generation names: ", this.keypairGenNames == null ? "-" : this.keypairGenNames, "\n", this.getCaUris(), "\nCRL control:\n", this.crlControl == null ? "  -" : this.crlControl.toString(verbose), "\nCTLog control:\n", this.ctlogControl == null ? "  -" : this.ctlogControl.toString(verbose), "\nrevoke suspended certificates control: \n", this.revokeSuspendedControl == null ? "  -" : this.revokeSuspendedControl.toString(verbose)});
    }
}

