/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.BaseCaInfo;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;

public class CaEntry
extends BaseCaInfo {
    protected NameId ident;
    protected String signerConf;
    protected X509Cert cert;
    protected int pathLenConstraint;
    protected List<X509Cert> certchain;
    protected String subject;
    protected String hexSha1OfCert;

    private CaEntry() {
    }

    public CaEntry(NameId ident) {
        this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
    }

    public CaEntry copy() {
        CaEntry ret = new CaEntry(this.ident);
        this.copyBaseInfoTo(ret);
        ret.pathLenConstraint = this.pathLenConstraint;
        ret.cert = this.cert;
        ret.certchain = this.certchain;
        ret.subject = this.subject;
        ret.hexSha1OfCert = this.hexSha1OfCert;
        return ret;
    }

    public static List<CaSignerConf> splitCaSignerConfs(String conf) throws XiSecurityException {
        ConfPairs pairs = new ConfPairs(conf);
        String str = pairs.value("algo");
        if (str == null) {
            throw new XiSecurityException("no algo is defined in CA signerConf");
        }
        List list = StringUtil.split((String)str, (String)":");
        if (CollectionUtil.isEmpty((Collection)list)) {
            throw new XiSecurityException("empty algo is defined in CA signerConf");
        }
        ArrayList<CaSignerConf> signerConfs = new ArrayList<CaSignerConf>(list.size());
        for (String n : list) {
            SignAlgo signAlgo;
            try {
                signAlgo = SignAlgo.getInstance((String)n);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
            }
            pairs.putPair("algo", signAlgo.getJceName());
            signerConfs.add(new CaSignerConf(signAlgo, pairs.getEncoded()));
        }
        return signerConfs;
    }

    public NameId getIdent() {
        return this.ident;
    }

    public void setSignerConf(String signerConf) {
        this.signerConf = Args.notBlank((String)signerConf, (String)"signerConf");
    }

    public String getSignerConf() {
        return this.signerConf;
    }

    public void setIdent(NameId ident) {
        this.ident = ident;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean verbose) {
        return this.toString(verbose, true);
    }

    public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
        int certchainSize = this.certchain == null ? 0 : this.certchain.size();
        StringBuilder certchainStr = new StringBuilder(20 + certchainSize * 200);
        certchainStr.append("\ncertchain: ");
        if (certchainSize > 0) {
            for (int i = 0; i < certchainSize; ++i) {
                certchainStr.append("\ncert[").append(i).append("]:\n");
                certchainStr.append(X509Util.formatCert((X509Cert)this.certchain.get(i), (boolean)verbose));
            }
        } else {
            certchainStr.append("-");
        }
        return StringUtil.concatObjectsCap((int)1500, (Object)"id:                   ", (Object[])new Object[]{this.ident.getId(), "\nname:                 ", this.ident.getName(), "\nsigner conf:          ", this.signerConf == null ? "-" : SignerEntry.signerConfToString(this.signerConf, verbose, ignoreSensitiveInfo), super.toString(verbose), "\ncert: \n", X509Util.formatCert((X509Cert)this.cert, (boolean)verbose), certchainStr.toString()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaEntry)) {
            return false;
        }
        return this.equals((CaEntry)((Object)obj), false, false);
    }

    public boolean equals(CaEntry obj, boolean ignoreDynamicFields, boolean ignoreId) {
        return super.equals(obj, ignoreDynamicFields) && CompareUtil.equalsObject((Object)this.cert, (Object)obj.cert) && CompareUtil.equalsObject(this.certchain, obj.certchain) && this.ident.equals(obj.ident, ignoreId) && CompareUtil.equalsObject((Object)this.signerConf, (Object)obj.signerConf);
    }

    public int hashCode() {
        return this.ident.hashCode();
    }

    public void setCert(X509Cert cert) throws CaMgmtException {
        if (cert == null) {
            this.cert = null;
            this.subject = null;
            this.hexSha1OfCert = null;
        } else {
            if (!cert.hasKeyusage(KeyUsage.keyCertSign)) {
                throw new CaMgmtException("CA certificate does not have keyusage keyCertSign");
            }
            this.cert = cert;
            this.pathLenConstraint = cert.getBasicConstraints();
            if (this.pathLenConstraint < 0) {
                throw new CaMgmtException("given certificate is not a CA certificate");
            }
            this.subject = cert.getSubjectText();
            byte[] encodedCert = cert.getEncoded();
            this.hexSha1OfCert = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{encodedCert});
        }
    }

    public X509Cert getCert() {
        return this.cert;
    }

    public List<X509Cert> getCertchain() {
        return this.certchain;
    }

    public void setCertchain(List<X509Cert> certchain) {
        this.certchain = certchain;
    }

    public int pathLenConstraint() {
        return this.pathLenConstraint;
    }

    public String subject() {
        return this.subject;
    }

    public String hexSha1OfCert() {
        return this.hexSha1OfCert;
    }

    public static class CaSignerConf {
        private final SignAlgo algo;
        private final String conf;

        private CaSignerConf(SignAlgo algo, String conf) {
            this.algo = algo;
            this.conf = conf;
        }

        public SignAlgo getAlgo() {
            return this.algo;
        }

        public String getConf() {
            return this.conf;
        }
    }
}

