/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt.entry;

import java.util.Collections;
import java.util.Set;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.Permissions;
import org.xipki.ca.api.mgmt.entry.MgmtEntry;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.StringUtil;

public class CaHasRequestorEntry
extends MgmtEntry {
    private NameId requestorIdent;
    private Permissions permissions;
    private Set<String> profiles;

    private CaHasRequestorEntry() {
    }

    public CaHasRequestorEntry(NameId requestorIdent) {
        this.requestorIdent = (NameId)Args.notNull((Object)requestorIdent, (String)"requestorIdent");
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public NameId getRequestorIdent() {
        return this.requestorIdent;
    }

    public void setRequestorIdent(NameId requestorIdent) {
        this.requestorIdent = requestorIdent;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = CollectionUtil.isEmpty(profiles) ? Collections.emptySet() : CollectionUtil.unmodifiableSet((Set)StringUtil.lowercase(profiles));
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public boolean isCertprofilePermitted(String certprofile) {
        if (CollectionUtil.isEmpty(this.profiles)) {
            return false;
        }
        return this.profiles.contains("all") || this.profiles.contains(certprofile.toLowerCase());
    }

    public boolean isPermitted(int permission) {
        return this.permissions.isPermitted(permission);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return indent + "requestor:  " + this.requestorIdent + "\n" + indent + "profiles:   " + this.profiles + "\n" + indent + "permission: " + this.permissions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaHasRequestorEntry)) {
            return false;
        }
        return this.equals((CaHasRequestorEntry)((Object)obj), false);
    }

    public boolean equals(CaHasRequestorEntry obj, boolean ignoreId) {
        return obj != null && this.requestorIdent.equals(obj.requestorIdent, ignoreId) && CompareUtil.equalsObject((Object)this.permissions, (Object)obj.permissions) && CompareUtil.equalsObject(this.profiles, obj.profiles);
    }

    public int hashCode() {
        return this.requestorIdent.hashCode();
    }
}

