/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import org.xipki.security.CrlReason;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class RevokeSuspendedControl {
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_REVOCATION_REASON = "targetReason";
    public static final String KEY_UNCHANGED_SINCE = "unchangedSince";
    private final boolean enabled;
    private final CrlReason targetReason;
    private final Validity unchangedSince;

    public RevokeSuspendedControl(String conf) {
        this(new ConfPairs(conf));
    }

    public RevokeSuspendedControl(ConfPairs conf) {
        Args.notNull((Object)conf, (String)"conf");
        this.enabled = RevokeSuspendedControl.getBoolean(conf, KEY_ENABLED, false);
        String str = conf.value(KEY_REVOCATION_REASON);
        this.targetReason = str == null ? CrlReason.CESSATION_OF_OPERATION : CrlReason.forNameOrText((String)str);
        str = conf.value(KEY_UNCHANGED_SINCE);
        this.unchangedSince = str == null ? new Validity(15, Validity.Unit.DAY) : Validity.getInstance((String)str);
    }

    public RevokeSuspendedControl(boolean enabled) {
        this(enabled, null, null);
    }

    public RevokeSuspendedControl(boolean enabled, CrlReason targetReason, Validity unchangedSince) {
        this.enabled = enabled;
        this.targetReason = targetReason == null ? CrlReason.CESSATION_OF_OPERATION : targetReason;
        this.unchangedSince = unchangedSince == null ? new Validity(15, Validity.Unit.DAY) : unchangedSince;
        switch (this.targetReason) {
            case AFFILIATION_CHANGED: 
            case CESSATION_OF_OPERATION: 
            case KEY_COMPROMISE: 
            case PRIVILEGE_WITHDRAWN: 
            case SUPERSEDED: 
            case UNSPECIFIED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid targetReason " + targetReason);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CrlReason getTargetReason() {
        return this.targetReason;
    }

    public Validity getUnchangedSince() {
        return this.unchangedSince;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        String str = "  enabled:         " + this.enabled + "\n  target reason:   " + this.targetReason + "\n  unchanged since: " + this.unchangedSince;
        if (verbose) {
            str = str + "\n  Encoded:          " + this.getConf();
        }
        return str;
    }

    public String getConf() {
        return this.getConfPairs().getEncoded();
    }

    public ConfPairs getConfPairs() {
        return new ConfPairs().putPair(KEY_ENABLED, Boolean.toString(this.enabled)).putPair(KEY_REVOCATION_REASON, this.targetReason.getDescription()).putPair(KEY_UNCHANGED_SINCE, this.unchangedSince.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RevokeSuspendedControl)) {
            return false;
        }
        RevokeSuspendedControl obj2 = (RevokeSuspendedControl)obj;
        return this.enabled == obj2.enabled && this.targetReason == obj2.targetReason && this.unchangedSince != obj2.unchangedSince;
    }

    private static boolean getBoolean(ConfPairs pairs, String key, boolean defaultValue) {
        String str = pairs.value(key);
        boolean ret = StringUtil.isBlank((String)str) ? defaultValue : Boolean.parseBoolean(str);
        pairs.putPair(key, Boolean.toString(ret));
        return ret;
    }
}

