/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Args;

public class DbSchemaInfo {
    private final Map<String, String> variables = new HashMap<String, String>();

    public DbSchemaInfo(DataSourceWrapper datasource) throws DataAccessException {
        Args.notNull((Object)datasource, (String)"datasource");
        String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = datasource.createStatement();
            if (stmt == null) {
                throw new DataAccessException("could not create statement");
            }
            rs = stmt.executeQuery("SELECT NAME,VALUE2 FROM DBSCHEMA");
            while (rs.next()) {
                this.variables.put(rs.getString("NAME"), rs.getString("VALUE2"));
            }
        }
        catch (SQLException ex) {
            try {
                throw datasource.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex);
            }
            catch (Throwable throwable) {
                datasource.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        datasource.releaseResources(stmt, rs);
    }

    public Set<String> getVariableNames() {
        return Collections.unmodifiableSet(this.variables.keySet());
    }

    public String getVariableValue(String variableName) {
        return this.variables.get(Args.notNull((Object)variableName, (String)"variableName"));
    }

    public void setVariable(String name, String value) {
        this.variables.put(name, value);
    }
}

