/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.diffdb;

import java.io.Closeable;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xipki.ca.mgmt.db.diffdb.CertsBundle;
import org.xipki.ca.mgmt.db.diffdb.DbType;
import org.xipki.ca.mgmt.db.diffdb.DigestDiffReporter;
import org.xipki.ca.mgmt.db.diffdb.DigestEntry;
import org.xipki.ca.mgmt.db.diffdb.RefDigestReader;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.DatabaseType;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;

class TargetDigestReader
implements Closeable {
    private final DbType dbType;
    private final HashAlgo certhashAlgo;
    private final DataSourceWrapper datasource;
    private final int numPerSelect;
    private final String singleCertSql;
    private final String inArrayCertsSql;
    private final AtomicBoolean stopMe;
    private Exception exception;
    private ExecutorService executor;
    private final RefDigestReader reader;
    private final DigestDiffReporter reporter;
    private final ProcessLog processLog;
    private final List<Retriever> retrievers;

    /*
     * WARNING - void declaration
     */
    public TargetDigestReader(boolean revokedOnly, ProcessLog processLog, RefDigestReader reader, DigestDiffReporter reporter, DataSourceWrapper datasource, DbType dbType, HashAlgo certHashAlgo, int caId, int numPerSelect, int numThreads, AtomicBoolean stopMe) throws DataAccessException {
        int i;
        String singleSql;
        String certHashAlgoInDb;
        this.processLog = (ProcessLog)Args.notNull((Object)processLog, (String)"processLog");
        this.numPerSelect = numPerSelect;
        this.dbType = (DbType)((Object)Args.notNull((Object)((Object)dbType), (String)"dbControl"));
        this.reader = (RefDigestReader)Args.notNull((Object)reader, (String)"reader");
        this.reporter = (DigestDiffReporter)Args.notNull((Object)reporter, (String)"reporter");
        this.stopMe = (AtomicBoolean)Args.notNull((Object)stopMe, (String)"stopMe");
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.certhashAlgo = (HashAlgo)Args.notNull((Object)certHashAlgo, (String)"certhashAlgo");
        if (dbType == DbType.XIPKI_OCSP_v4 && certHashAlgo != HashAlgo.getInstance((String)(certHashAlgoInDb = (String)datasource.getFirstValue(null, "DBSCHEMA", "VALUE2", "NAME='CERTHASH_ALGO'", String.class)))) {
            throw new IllegalArgumentException("certHashAlgo in parameter (" + certHashAlgo + ") != in DB (" + certHashAlgoInDb + ")");
        }
        StringBuilder arrayBuffer = new StringBuilder(200);
        if (dbType == DbType.XIPKI_OCSP_v4) {
            singleSql = StringUtil.concat((String)"REV,RR,RT,RIT,HASH FROM CERT WHERE IID=", (String[])new String[]{Integer.toString(caId), " AND SN=?"});
            arrayBuffer.append("SN,REV,RR,RT,RIT,HASH FROM CERT WHERE IID=").append(caId).append(" AND SN IN (?");
            for (i = 1; i < numPerSelect; ++i) {
                arrayBuffer.append(",?");
            }
            arrayBuffer.append(")");
        } else if (dbType == DbType.XIPKI_CA_v4) {
            void var15_19;
            String hashOrCertColumn = certHashAlgo == HashAlgo.SHA1 ? "SHA1" : "CERT";
            singleSql = StringUtil.concat((String)"REV,RR,RT,RIT,", (String[])new String[]{hashOrCertColumn, " FROM CERT WHERE CA_ID=", Integer.toString(caId), " AND SN=?"});
            arrayBuffer.append("SN,REV,RR,RT,RIT,").append(hashOrCertColumn).append(" FROM CERT WHERE CA_ID=").append(caId).append(" AND SN IN (?");
            boolean bl = true;
            while (var15_19 < numPerSelect) {
                arrayBuffer.append(",?");
                ++var15_19;
            }
            arrayBuffer.append(")");
        } else {
            throw new IllegalArgumentException("unknown dbControl " + (Object)((Object)dbType));
        }
        this.singleCertSql = datasource.buildSelectFirstSql(1, singleSql);
        this.inArrayCertsSql = datasource.buildSelectFirstSql(numPerSelect, arrayBuffer.toString());
        this.retrievers = new ArrayList<Retriever>(numThreads);
        try {
            for (i = 0; i < numThreads; ++i) {
                Retriever retriever = new Retriever(revokedOnly);
                this.retrievers.add(retriever);
            }
            this.executor = Executors.newFixedThreadPool(numThreads);
            for (Runnable runnable : this.retrievers) {
                this.executor.execute(runnable);
            }
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public final void close() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    private Map<BigInteger, DigestEntry> getCertsViaSingleSelect(PreparedStatement singleSelectStmt, List<BigInteger> serialNumbers) throws DataAccessException {
        HashMap<BigInteger, DigestEntry> ret = new HashMap<BigInteger, DigestEntry>(serialNumbers.size());
        for (BigInteger serialNumber : serialNumbers) {
            DigestEntry certB = this.getSingleCert(singleSelectStmt, serialNumber);
            if (certB == null) continue;
            ret.put(serialNumber, certB);
        }
        return ret;
    }

    private Map<BigInteger, DigestEntry> getCertsViaInArraySelect(PreparedStatement batchSelectStmt, List<BigInteger> serialNumbers) throws DataAccessException {
        int n = serialNumbers.size();
        if (n != this.numPerSelect) {
            throw new IllegalArgumentException("size of serialNumbers is not '" + this.numPerSelect + "': " + n);
        }
        Collections.sort(serialNumbers);
        ResultSet rs = null;
        try {
            for (int i = 0; i < n; ++i) {
                batchSelectStmt.setString(i + 1, serialNumbers.get(i).toString(16));
            }
            rs = batchSelectStmt.executeQuery();
            Map<BigInteger, DigestEntry> i = this.buildResult(rs, serialNumbers);
            this.releaseResources(null, rs);
            return i;
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(this.inArrayCertsSql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(null, rs);
                throw throwable;
            }
        }
    }

    private Map<BigInteger, DigestEntry> buildResult(ResultSet rs, List<BigInteger> serialNumbers) throws SQLException {
        HashMap<BigInteger, DigestEntry> ret = new HashMap<BigInteger, DigestEntry>(serialNumbers.size());
        while (rs.next()) {
            BigInteger serialNumber = new BigInteger(rs.getString("SN"), 16);
            if (!serialNumbers.contains(serialNumber)) continue;
            boolean revoked = rs.getBoolean("REV");
            Integer revReason = null;
            Long revTime = null;
            Long revInvTime = null;
            if (revoked) {
                revReason = rs.getInt("RR");
                revTime = rs.getLong("RT");
                revInvTime = rs.getLong("RIT");
                if (revInvTime == 0L) {
                    revInvTime = null;
                }
            }
            String base64Certhash = this.getBase64HashValue(rs);
            DigestEntry certB = new DigestEntry(serialNumber, revoked, revReason, revTime, revInvTime, base64Certhash);
            ret.put(serialNumber, certB);
        }
        return ret;
    }

    private DigestEntry getSingleCert(PreparedStatement singleSelectStmt, BigInteger serialNumber) throws DataAccessException {
        ResultSet rs;
        block7: {
            rs = null;
            singleSelectStmt.setString(1, serialNumber.toString(16));
            rs = singleSelectStmt.executeQuery();
            if (rs.next()) break block7;
            DigestEntry digestEntry = null;
            this.releaseResources(null, rs);
            return digestEntry;
        }
        try {
            boolean revoked = rs.getBoolean("REV");
            Integer revReason = null;
            Long revTime = null;
            Long revInvTime = null;
            if (revoked) {
                revReason = rs.getInt("RR");
                revTime = rs.getLong("RT");
                revInvTime = rs.getLong("RIT");
                if (revInvTime == 0L) {
                    revInvTime = null;
                }
            }
            DigestEntry digestEntry = new DigestEntry(serialNumber, revoked, revReason, revTime, revInvTime, this.getBase64HashValue(rs));
            this.releaseResources(null, rs);
            return digestEntry;
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(this.singleCertSql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(null, rs);
                throw throwable;
            }
        }
    }

    private void releaseResources(Statement ps, ResultSet rs) {
        this.datasource.releaseResources(ps, rs);
    }

    public void awaitTerminiation() throws Exception {
        this.executor.shutdown();
        while (!this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
            if (this.exception == null) continue;
            throw this.exception;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private String getBase64HashValue(ResultSet rs) throws SQLException {
        if (this.dbType == DbType.XIPKI_OCSP_v4) {
            return rs.getString("HASH");
        }
        if (this.certhashAlgo == HashAlgo.SHA1) {
            return rs.getString("SHA1");
        }
        String b64Cert = rs.getString("CERT");
        byte[] encodedCert = Base64.decodeFast((String)b64Cert);
        return this.certhashAlgo.base64Hash((byte[][])new byte[][]{encodedCert});
    }

    private class Retriever
    implements Runnable {
        private final boolean revokedOnly;
        private Connection conn;
        private PreparedStatement singleSelectStmt;
        private PreparedStatement inArraySelectStmt;

        Retriever(boolean revokedOnly) throws DataAccessException {
            this.revokedOnly = revokedOnly;
            this.conn = TargetDigestReader.this.datasource.getConnection();
            try {
                this.singleSelectStmt = TargetDigestReader.this.datasource.prepareStatement(this.conn, TargetDigestReader.this.singleCertSql);
                this.inArraySelectStmt = TargetDigestReader.this.datasource.prepareStatement(this.conn, TargetDigestReader.this.inArrayCertsSql);
            }
            catch (DataAccessException ex) {
                TargetDigestReader.this.releaseResources(this.singleSelectStmt, null);
                TargetDigestReader.this.releaseResources(this.inArraySelectStmt, null);
                TargetDigestReader.this.datasource.returnConnection(this.conn);
                throw ex;
            }
        }

        @Override
        public void run() {
            while (!TargetDigestReader.this.stopMe.get()) {
                CertsBundle bundle = null;
                try {
                    bundle = TargetDigestReader.this.reader.nextCerts();
                }
                catch (Exception ex) {
                    TargetDigestReader.this.exception = ex;
                    break;
                }
                if (bundle == null) break;
                try {
                    Map<BigInteger, DigestEntry> refCerts = bundle.getCerts();
                    Map<BigInteger, DigestEntry> resp = this.query(bundle);
                    List<BigInteger> serialNumbers = bundle.getSerialNumbers();
                    int size = serialNumbers.size();
                    for (BigInteger serialNumber : serialNumbers) {
                        DigestEntry refCert = refCerts.get(serialNumber);
                        DigestEntry targetCert = resp.get(serialNumber);
                        if (this.revokedOnly && !refCert.isRevoked() && targetCert != null) {
                            TargetDigestReader.this.reporter.addUnexpected(serialNumber);
                            continue;
                        }
                        if (targetCert != null) {
                            if (refCert.contentEquals(targetCert)) {
                                TargetDigestReader.this.reporter.addGood(serialNumber);
                                continue;
                            }
                            TargetDigestReader.this.reporter.addDiff(refCert, targetCert);
                            continue;
                        }
                        TargetDigestReader.this.reporter.addMissing(serialNumber);
                    }
                    TargetDigestReader.this.processLog.addNumProcessed((long)size);
                    TargetDigestReader.this.processLog.printStatus();
                }
                catch (Exception ex) {
                    TargetDigestReader.this.exception = ex;
                    break;
                }
            }
            TargetDigestReader.this.releaseResources(this.singleSelectStmt, null);
            TargetDigestReader.this.releaseResources(this.inArraySelectStmt, null);
            TargetDigestReader.this.datasource.returnConnection(this.conn);
        }

        private Map<BigInteger, DigestEntry> query(CertsBundle bundle) throws DataAccessException {
            List<BigInteger> serialNumbers = bundle.getSerialNumbers();
            int size = serialNumbers.size();
            boolean batchSupported = TargetDigestReader.this.datasource.getDatabaseType() != DatabaseType.H2;
            return batchSupported && size == TargetDigestReader.this.numPerSelect ? TargetDigestReader.this.getCertsViaInArraySelect(this.inArraySelectStmt, serialNumbers) : TargetDigestReader.this.getCertsViaSingleSelect(this.singleSelectStmt, serialNumbers);
        }
    }
}

