/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.diffdb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.diffdb.DigestDiff;
import org.xipki.ca.mgmt.db.port.DbPortWorker;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class DigestDiffWorker
extends DbPortWorker {
    private static final Logger LOG = LoggerFactory.getLogger(DigestDiffWorker.class);
    private final boolean revokedOnly;
    private final Set<byte[]> includeCaCerts;
    private final DataSourceWrapper targetDatasource;
    private final String reportDir;
    private final int numCertsPerSelect;
    private final int numThreads;

    public DigestDiffWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, boolean revokedOnly, String refDbConfFile, String targetDbConfFile, String reportDirName, int numCertsPerSelect, int numThreads, Set<byte[]> includeCaCerts) throws PasswordResolverException, IOException {
        super(datasourceFactory, passwordResolver, refDbConfFile);
        this.reportDir = reportDirName;
        this.numThreads = Args.positive((int)numThreads, (String)"numThreads");
        this.numCertsPerSelect = numCertsPerSelect;
        this.includeCaCerts = includeCaCerts;
        this.revokedOnly = revokedOnly;
        File file = new File(reportDirName);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            if (!file.isDirectory()) {
                throw new IOException(reportDirName + " is not a folder");
            }
            if (!file.canWrite()) {
                throw new IOException(reportDirName + " is not writable");
            }
        }
        String[] children = file.list();
        if (children != null && children.length > 0) {
            throw new IOException(reportDirName + " is not empty");
        }
        Properties props = DbPorter.getDbConfProperties(Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)targetDbConfFile), new String[0]), new OpenOption[0]));
        this.targetDatasource = datasourceFactory.createDataSource("ds-" + targetDbConfFile, props, passwordResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run0() throws Exception {
        long start = System.currentTimeMillis();
        try {
            DigestDiff diff = new DigestDiff(this.datasource, this.targetDatasource, this.reportDir, this.revokedOnly, this.stopMe, this.numCertsPerSelect, this.numThreads);
            diff.setIncludeCaCerts(this.includeCaCerts);
            diff.diff();
        }
        finally {
            try {
                this.datasource.close();
            }
            catch (Throwable th) {
                LOG.error("refDatasource.close()", th);
            }
            try {
                this.targetDatasource.close();
            }
            catch (Throwable th) {
                LOG.error("datasource.close()", th);
            }
            long end = System.currentTimeMillis();
            System.out.println("finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
        }
    }
}

