/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.DbSchemaInfo;
import org.xipki.ca.mgmt.db.DbToolBase;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class DbPorter
extends DbToolBase {
    public static final String FILENAME_CA_CONFIGURATION = "ca-configuration.json";
    public static final String FILENAME_CA_CERTSTORE = "ca-certstore.json";
    public static final String FILENAME_OCSP_CERTSTORE = "ocsp-certstore.json";
    public static final String EXPORT_PROCESS_LOG_FILENAME = "export.process";
    public static final String IMPORT_PROCESS_LOG_FILENAME = "import.process";
    public static final String IMPORT_TO_OCSP_PROCESS_LOG_FILENAME = "import-to-ocsp.process";
    public static final int VERSION = 1;
    protected final int dbSchemaVersion;
    protected final int maxX500nameLen;
    protected final DbSchemaInfo dbSchemaInfo;

    public DbPorter(DataSourceWrapper datasource, String baseDir, AtomicBoolean stopMe) throws DataAccessException {
        super(datasource, baseDir, stopMe);
        this.dbSchemaInfo = new DbSchemaInfo(datasource);
        this.dbSchemaVersion = Integer.parseInt(this.dbSchemaInfo.getVariableValue("VERSION"));
        this.maxX500nameLen = Integer.parseInt(this.dbSchemaInfo.getVariableValue("X500NAME_MAXLEN"));
    }

    protected FileOrValue buildFileOrValue(String content, String fileName) throws IOException {
        if (content == null) {
            return null;
        }
        Args.notNull((Object)fileName, (String)"fileName");
        FileOrValue ret = new FileOrValue();
        if (content.length() < 256) {
            ret.setValue(content);
            return ret;
        }
        File file = new File(this.baseDir, fileName);
        IoUtil.mkdirsParent((Path)file.toPath());
        IoUtil.save((File)file, (byte[])StringUtil.toUtf8Bytes((String)content));
        ret.setFile(fileName);
        return ret;
    }

    protected FileOrBinary buildFileOrBase64Binary(String base64Content, String fileName) throws IOException {
        if (base64Content == null) {
            return null;
        }
        return this.buildFileOrBinary(Base64.decode((String)base64Content), fileName);
    }

    protected FileOrBinary buildFileOrBinary(byte[] content, String fileName) throws IOException {
        if (content == null) {
            return null;
        }
        Args.notNull((Object)fileName, (String)"fileName");
        FileOrBinary ret = new FileOrBinary();
        if (content.length < 256) {
            ret.setBinary(content);
            return ret;
        }
        File file = new File(this.baseDir, fileName);
        IoUtil.mkdirsParent((Path)file.toPath());
        IoUtil.save((File)file, (byte[])content);
        ret.setFile(fileName);
        return ret;
    }

    protected byte[] readContent(FileOrBinary fileOrBinary) throws IOException {
        if (fileOrBinary == null) {
            return null;
        }
        if (fileOrBinary.getBinary() != null) {
            return fileOrBinary.getBinary();
        }
        File file = new File(this.baseDir, fileOrBinary.getFile());
        return IoUtil.read((File)file);
    }

    protected String readContent(FileOrValue fileOrValue) throws IOException {
        if (fileOrValue == null) {
            return null;
        }
        if (fileOrValue.getValue() != null) {
            return fileOrValue.getValue();
        }
        File file = new File(this.baseDir, fileOrValue.getFile());
        return new String(IoUtil.read((File)file), StandardCharsets.UTF_8);
    }

    public static void echoToFile(String content, File file) throws IOException {
        Files.write(((File)Args.notNull((Object)file, (String)"file")).toPath(), StringUtil.toUtf8Bytes((String)((String)Args.notNull((Object)content, (String)"content"))), new OpenOption[0]);
    }

    public static class DbPortFileNameIterator
    implements Iterator<String>,
    Closeable {
        private static final Logger LOG = LoggerFactory.getLogger(DbPortFileNameIterator.class);
        private final BufferedReader reader;
        private String nextFilename;

        public DbPortFileNameIterator(String filename) throws IOException {
            Args.notNull((Object)filename, (String)"filename");
            this.reader = Files.newBufferedReader(Paths.get(filename, new String[0]));
            this.nextFilename = this.readNextFilenameLine();
        }

        @Override
        public boolean hasNext() {
            return this.nextFilename != null;
        }

        @Override
        public String next() {
            String str = this.nextFilename;
            this.nextFilename = null;
            try {
                this.nextFilename = this.readNextFilenameLine();
            }
            catch (IOException ex) {
                throw new IllegalStateException("could not read next file name");
            }
            return str;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not close reader");
            }
        }

        private String readNextFilenameLine() throws IOException {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (StringUtil.isBlank((String)(line = line.trim())) || line.startsWith("#") || !line.endsWith(".zip")) continue;
                return line;
            }
            return null;
        }
    }

    public static enum CaDbEntryType {
        CERT("certs", "CERT", 1.0f),
        CRL("crls", "CRL", 0.1f),
        REQUEST("requests", "REQUEST", 0.1f),
        REQCERT("reqcerts", "REQCERT", 50.0f);

        private final String dirName;
        private final String tableName;
        private final float sqlBatchFactor;

        private CaDbEntryType(String dirName, String tableName, float sqlBatchFactor) {
            this.dirName = dirName;
            this.tableName = tableName;
            this.sqlBatchFactor = sqlBatchFactor;
        }

        public String getDirName() {
            return this.dirName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public float getSqlBatchFactor() {
            return this.sqlBatchFactor;
        }
    }

    public static enum OcspDbEntryType {
        CERT("certs", "CERT", 1.0f);

        private final String dirName;
        private final String tableName;
        private final float sqlBatchFactor;

        private OcspDbEntryType(String dirName, String tableName, float sqlBatchFactor) {
            this.dirName = dirName;
            this.tableName = tableName;
            this.sqlBatchFactor = sqlBatchFactor;
        }

        public String getDirName() {
            return this.dirName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public float getSqlBatchFactor() {
            return this.sqlBatchFactor;
        }
    }
}

