/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.ca.mgmt.db.port.OcspCertstore;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;

class OcspCertstoreDbExporter
extends DbPorter {
    public static final String PROCESS_LOG_FILENAME = "export.process";
    private static final Logger LOG = LoggerFactory.getLogger(OcspCertstoreDbExporter.class);
    private final int numCertsInBundle;
    private final int numCertsPerSelect;
    private final boolean resume;

    OcspCertstoreDbExporter(DataSourceWrapper datasource, String baseDir, int numCertsInBundle, int numCertsPerSelect, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, baseDir, stopMe);
        File processLogFile;
        this.numCertsInBundle = Args.positive((int)numCertsInBundle, (String)"numCertsInBundle");
        this.numCertsPerSelect = Args.positive((int)numCertsPerSelect, (String)"numCertsPerSelect");
        if (resume && !(processLogFile = new File(baseDir, PROCESS_LOG_FILENAME)).exists()) {
            throw new Exception("could not process with '--resume' option");
        }
        this.resume = resume;
    }

    public void export() throws Exception {
        OcspCertstore certstore;
        if (this.resume) {
            try (InputStream is = Files.newInputStream(Paths.get(this.baseDir, "ocsp-certstore.json"), new OpenOption[0]);){
                certstore = (OcspCertstore)((Object)JSON.parseObject((InputStream)is, OcspCertstore.class, (Feature[])new Feature[0]));
            }
            certstore.validate();
            if (certstore.getVersion() > 1) {
                throw new Exception("could not continue with Certstore greater than 1: " + certstore.getVersion());
            }
        } else {
            certstore = new OcspCertstore();
            certstore.setVersion(1);
        }
        System.out.println("exporting OCSP certstore from database");
        if (!this.resume) {
            this.exportHashAlgo(certstore);
            this.exportIssuer(certstore);
            this.exportCrlInfo(certstore);
        }
        File processLogFile = new File(this.baseDir, PROCESS_LOG_FILENAME);
        Exception exception = this.exportCert(certstore, processLogFile);
        try (OutputStream os = Files.newOutputStream(Paths.get(this.baseDir, "ocsp-certstore.json"), new OpenOption[0]);){
            JSON.writeJSONString((OutputStream)os, (Object)((Object)certstore), (SerializerFeature[])new SerializerFeature[0]);
        }
        if (exception != null) {
            throw exception;
        }
        System.out.println(" exported OCSP certstore from database");
    }

    private void exportHashAlgo(OcspCertstore certstore) throws DataAccessException {
        String certHashAlgoStr = this.dbSchemaInfo.getVariableValue("CERTHASH_ALGO");
        if (certHashAlgoStr == null) {
            throw new DataAccessException("CERTHASH_ALGO is not defined in table DBSCHEMA");
        }
        certstore.setCerthashAlgo(certHashAlgoStr);
    }

    private void exportIssuer(OcspCertstore certstore) throws DataAccessException, IOException {
        System.out.println("exporting table ISSUER");
        LinkedList<OcspCertstore.Issuer> issuers = new LinkedList<OcspCertstore.Issuer>();
        certstore.setIssuers(issuers);
        String sql = "SELECT ID,CERT,REV_INFO,CRL_ID FROM ISSUER";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,CERT,REV_INFO,CRL_ID FROM ISSUER");
            while (rs.next()) {
                int id = rs.getInt("ID");
                OcspCertstore.Issuer issuer = new OcspCertstore.Issuer();
                issuer.setId(id);
                String certFileName = "issuer-conf/cert-issuer-" + id;
                IoUtil.save((File)new File(this.baseDir, certFileName), (byte[])StringUtil.toUtf8Bytes((String)rs.getString("CERT")));
                issuer.setCertFile(certFileName);
                issuer.setRevInfo(rs.getString("REV_INFO"));
                int crlId = rs.getInt("CRL_ID");
                if (crlId != 0) {
                    issuer.setCrlId(crlId);
                }
                issuers.add(issuer);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,CERT,REV_INFO,CRL_ID FROM ISSUER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(" exported table ISSUER");
    }

    private void exportCrlInfo(OcspCertstore certstore) throws DataAccessException {
        System.out.println("exporting table CRL_INFO");
        LinkedList<OcspCertstore.CrlInfo> crlInfos = new LinkedList<OcspCertstore.CrlInfo>();
        certstore.setCrlInfos(crlInfos);
        String sql = "SELECT ID,NAME,INFO FROM CRL_INFO";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery("SELECT ID,NAME,INFO FROM CRL_INFO");
            while (rs.next()) {
                OcspCertstore.CrlInfo crlInfo = new OcspCertstore.CrlInfo();
                crlInfo.setId(rs.getInt("ID"));
                crlInfo.setName(rs.getString("NAME"));
                crlInfo.setInfo(rs.getString("INFO"));
                crlInfos.add(crlInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,INFO FROM CRL_INFO", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(" exported table CRL_INFO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception exportCert(OcspCertstore certstore, File processLogFile) {
        new File(this.baseDir, DbPorter.OcspDbEntryType.CERT.getDirName()).mkdirs();
        OutputStream certsFileOs = null;
        try {
            certsFileOs = Files.newOutputStream(Paths.get(this.baseDir, DbPorter.OcspDbEntryType.CERT.getDirName() + ".mf"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            this.exportCert0(certstore, processLogFile, certsFileOs);
            Exception exception = null;
            IoUtil.closeQuietly((Closeable)certsFileOs);
            return exception;
        }
        catch (Exception ex) {
            OcspCertstoreDbExporter.deleteTmpFiles(this.baseDir, "tmp-certs-");
            System.err.println("\nexporting table CERT has been cancelled due to error,\nplease continue with the option '--resume'");
            LOG.error("Exception", (Throwable)ex);
            Exception exception = ex;
            return exception;
        }
        finally {
            IoUtil.closeQuietly(certsFileOs);
        }
    }

    private void exportCert0(OcspCertstore certstore, File processLogFile, OutputStream certsFileOs) throws Exception {
        byte[] content;
        File certsDir = new File(this.baseDir, DbPorter.OcspDbEntryType.CERT.getDirName());
        Long minId = null;
        if (processLogFile.exists() && (content = IoUtil.read((File)processLogFile)) != null && content.length > 0) {
            Long l = minId = Long.valueOf(Long.parseLong(new String(content).trim()));
            Long l2 = minId = Long.valueOf(minId + 1L);
        }
        if (minId == null) {
            minId = this.min("CERT", "ID");
        }
        System.out.println("exporting table CERT from ID " + minId);
        String coreSql = "ID,SN,IID,LUPDATE,REV,RR,RT,RIT,NAFTER,NBEFORE,HASH,SUBJECT,CRL_ID FROM CERT WHERE ID>=?";
        String certSql = this.datasource.buildSelectFirstSql(this.numCertsPerSelect, "ID ASC", "ID,SN,IID,LUPDATE,REV,RR,RT,RIT,NAFTER,NBEFORE,HASH,SUBJECT,CRL_ID FROM CERT WHERE ID>=?");
        long maxId = this.max("CERT", "ID");
        int numProcessedBefore = certstore.getCountCerts();
        long total = this.count("CERT") - numProcessedBefore;
        ProcessLog processLog = new ProcessLog(total);
        PreparedStatement certPs = this.prepareStatement(certSql);
        int sum = 0;
        int numCertInCurrentFile = 0;
        OcspCertstore.Certs certsInCurrentFile = new OcspCertstore.Certs();
        File currentCertsZipFile = new File(this.baseDir, "tmp-certs-" + System.currentTimeMillis() + ".zip");
        ZipOutputStream currentCertsZip = OcspCertstoreDbExporter.getZipOutputStream(currentCertsZipFile);
        long minCertIdOfCurrentFile = -1L;
        long maxCertIdOfCurrentFile = -1L;
        processLog.printHeader();
        String sql = null;
        Long id = null;
        try {
            boolean interrupted = false;
            long lastMaxId = minId - 1L;
            while (true) {
                if (this.stopMe.get()) {
                    interrupted = true;
                    break;
                }
                sql = certSql;
                certPs.setLong(1, lastMaxId + 1L);
                ResultSet rs = certPs.executeQuery();
                if (!rs.next()) break;
                do {
                    int crlId;
                    long nbefore;
                    long nafter;
                    String subject;
                    String hash;
                    if (lastMaxId < (id = Long.valueOf(rs.getLong("ID")))) {
                        lastMaxId = id;
                    }
                    if (minCertIdOfCurrentFile == -1L) {
                        minCertIdOfCurrentFile = id;
                    } else if (minCertIdOfCurrentFile > id) {
                        minCertIdOfCurrentFile = id;
                    }
                    if (maxCertIdOfCurrentFile == -1L) {
                        maxCertIdOfCurrentFile = id;
                    } else if (maxCertIdOfCurrentFile < id) {
                        maxCertIdOfCurrentFile = id;
                    }
                    OcspCertstore.Cert cert = new OcspCertstore.Cert();
                    cert.setId(id);
                    cert.setIid(rs.getInt("IID"));
                    cert.setSn(rs.getString("SN"));
                    cert.setUpdate(rs.getLong("LUPDATE"));
                    boolean revoked = rs.getBoolean("REV");
                    cert.setRev(revoked);
                    if (revoked) {
                        cert.setRr(rs.getInt("RR"));
                        cert.setRt(rs.getLong("RT"));
                        long rit = rs.getLong("RIT");
                        if (rit != 0L) {
                            cert.setRit(rit);
                        }
                    }
                    if ((hash = rs.getString("HASH")) != null) {
                        cert.setHash(hash);
                    }
                    if ((subject = rs.getString("SUBJECT")) != null) {
                        cert.setSubject(subject);
                    }
                    if ((nafter = rs.getLong("NAFTER")) != 0L) {
                        cert.setNafter(nafter);
                    }
                    if ((nbefore = rs.getLong("NBEFORE")) != 0L) {
                        cert.setNbefore(nbefore);
                    }
                    if ((crlId = rs.getInt("CRL_ID")) != 0) {
                        cert.setCrlId(crlId);
                    }
                    certsInCurrentFile.add(cert);
                    ++sum;
                    if (++numCertInCurrentFile != this.numCertsInBundle) continue;
                    this.finalizeZip(currentCertsZip, certsInCurrentFile);
                    String currentCertsFilename = OcspCertstoreDbExporter.buildFilename("certs_", ".zip", minCertIdOfCurrentFile, maxCertIdOfCurrentFile, maxId);
                    currentCertsZipFile.renameTo(new File(certsDir, currentCertsFilename));
                    OcspCertstoreDbExporter.writeLine(certsFileOs, currentCertsFilename);
                    certstore.setCountCerts(numProcessedBefore + sum);
                    OcspCertstoreDbExporter.echoToFile(Long.toString(id), processLogFile);
                    processLog.addNumProcessed((long)numCertInCurrentFile);
                    processLog.printStatus();
                    certsInCurrentFile = new OcspCertstore.Certs();
                    numCertInCurrentFile = 0;
                    minCertIdOfCurrentFile = -1L;
                    maxCertIdOfCurrentFile = -1L;
                    currentCertsZipFile = new File(this.baseDir, "tmp-certs-" + System.currentTimeMillis() + ".zip");
                    currentCertsZip = OcspCertstoreDbExporter.getZipOutputStream(currentCertsZipFile);
                } while (rs.next());
                rs.close();
            }
            if (interrupted) {
                throw new InterruptedException("interrupted by the user");
            }
            if (numCertInCurrentFile > 0) {
                this.finalizeZip(currentCertsZip, certsInCurrentFile);
                String currentCertsFilename = OcspCertstoreDbExporter.buildFilename("certs_", ".zip", minCertIdOfCurrentFile, maxCertIdOfCurrentFile, maxId);
                currentCertsZipFile.renameTo(new File(certsDir, currentCertsFilename));
                OcspCertstoreDbExporter.writeLine(certsFileOs, currentCertsFilename);
                certstore.setCountCerts(numProcessedBefore + sum);
                OcspCertstoreDbExporter.echoToFile(Long.toString(id), processLogFile);
                processLog.addNumProcessed((long)numCertInCurrentFile);
            } else {
                currentCertsZip.close();
                currentCertsZipFile.delete();
            }
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(certPs, null);
        }
        processLog.printTrailer();
        processLogFile.delete();
        System.out.println(" exported " + processLog.numProcessed() + " certificates from tables CERT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeZip(ZipOutputStream zipOutStream, OcspCertstore.Certs certs) throws IOException {
        ZipEntry certZipEntry = new ZipEntry("certs.json");
        zipOutStream.putNextEntry(certZipEntry);
        try {
            JSON.writeJSONString((OutputStream)zipOutStream, (Charset)StandardCharsets.UTF_8, (Object)((Object)certs), (SerializerFeature[])new SerializerFeature[0]);
        }
        finally {
            zipOutStream.closeEntry();
        }
        zipOutStream.close();
    }
}

