/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.ProcessLog;

class CaCertstoreDbImporter
extends DbPorter {
    private static final Logger LOG = LoggerFactory.getLogger(CaCertstoreDbImporter.class);
    private static final String SQL_ADD_CERT = "INSERT INTO CERT (ID,LUPDATE,SN,SUBJECT,FP_S,FP_RS,NBEFORE,NAFTER,REV,RR,RT,RIT,PID,CA_ID,RID,UID,EE,RTYPE,TID,SHA1,REQ_SUBJECT,CRL_SCOPE,CERT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_ADD_CRL = "INSERT INTO CRL (ID,CA_ID,CRL_NO,THISUPDATE,NEXTUPDATE,DELTACRL,BASECRL_NO,CRL_SCOPE,CRL) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_ADD_REQUEST = "INSERT INTO REQUEST (ID,LUPDATE,DATA) VALUES (?,?,?)";
    private static final String SQL_ADD_REQCERT = "INSERT INTO REQCERT (ID,RID,CID) VALUES (?,?,?)";
    private final int numCertsPerCommit;

    CaCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, int numCertsPerCommit, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
        this.numCertsPerCommit = Args.positive((int)numCertsPerCommit, (String)"numCertsPerCommit");
        File processLogFile = new File(this.baseDir, "import.process");
        if (resume) {
            if (!processLogFile.exists()) {
                throw new Exception("could not process with '--resume' option");
            }
        } else if (processLogFile.exists()) {
            throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
        }
    }

    public void importToDb() throws Exception {
        CaCertstore certstore;
        try (InputStream is = Files.newInputStream(Paths.get(this.baseDir, "ca-certstore.json"), new OpenOption[0]);){
            certstore = (CaCertstore)((Object)JSON.parseObject((InputStream)is, CaCertstore.class, (Feature[])new Feature[0]));
        }
        certstore.validate();
        if (certstore.getVersion() > 1) {
            throw new Exception("could not import Certstore greater than 1: " + certstore.getVersion());
        }
        File processLogFile = new File(this.baseDir, "import.process");
        System.out.println("importing CA certstore to database");
        try {
            byte[] content;
            Enum typeProcessedInLastProcess = null;
            Integer numProcessedInLastProcess = null;
            Long idProcessedInLastProcess = null;
            if (processLogFile.exists() && (content = IoUtil.read((File)processLogFile)) != null && content.length > 5) {
                String str = new String(content);
                StringTokenizer st = new StringTokenizer(str, ":");
                String type = st.nextToken();
                typeProcessedInLastProcess = DbPorter.CaDbEntryType.valueOf(type);
                numProcessedInLastProcess = Integer.parseInt(st.nextToken());
                idProcessedInLastProcess = Long.parseLong(st.nextToken());
            }
            boolean entriesFinished = false;
            if (typeProcessedInLastProcess != null && idProcessedInLastProcess == -1L) {
                numProcessedInLastProcess = 0;
                idProcessedInLastProcess = 0L;
                switch (1.$SwitchMap$org$xipki$ca$mgmt$db$port$DbPorter$CaDbEntryType[typeProcessedInLastProcess.ordinal()]) {
                    case 1: {
                        typeProcessedInLastProcess = DbPorter.CaDbEntryType.CERT;
                        break;
                    }
                    case 2: {
                        typeProcessedInLastProcess = DbPorter.CaDbEntryType.REQUEST;
                        break;
                    }
                    case 3: {
                        typeProcessedInLastProcess = DbPorter.CaDbEntryType.REQCERT;
                        break;
                    }
                    case 4: {
                        entriesFinished = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unsupported CaDbEntryType " + typeProcessedInLastProcess);
                    }
                }
            }
            if (!entriesFinished) {
                DbPorter.CaDbEntryType[] types;
                Exception exception = null;
                if (DbPorter.CaDbEntryType.CRL == typeProcessedInLastProcess || typeProcessedInLastProcess == null) {
                    exception = this.importEntries(DbPorter.CaDbEntryType.CRL, certstore, processLogFile, numProcessedInLastProcess, idProcessedInLastProcess);
                    typeProcessedInLastProcess = null;
                    numProcessedInLastProcess = null;
                    idProcessedInLastProcess = null;
                }
                for (DbPorter.CaDbEntryType type : types = new DbPorter.CaDbEntryType[]{DbPorter.CaDbEntryType.CERT, DbPorter.CaDbEntryType.REQUEST, DbPorter.CaDbEntryType.REQCERT}) {
                    if (exception != null || type != typeProcessedInLastProcess && typeProcessedInLastProcess != null) continue;
                    exception = this.importEntries(type, certstore, processLogFile, numProcessedInLastProcess, idProcessedInLastProcess);
                }
                if (exception != null) {
                    throw exception;
                }
            }
            this.importPublishQueue(certstore.getPublishQueue());
            processLogFile.delete();
        }
        catch (Exception ex) {
            System.err.println("could not import CA certstore to database");
            throw ex;
        }
        System.out.println(" imported CA certstore to database");
    }

    /*
     * Exception decompiling
     */
    private void importPublishQueue(List<CaCertstore.ToPublish> publishQueue) throws DataAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Exception importEntries(DbPorter.CaDbEntryType type, CaCertstore certstore, File processLogFile, Integer numProcessedInLastProcess, Long idProcessedInLastProcess) {
        String tablesText = "table " + type.getTableName();
        try {
            PreparedStatement stmt;
            ProcessLog processLog;
            int numProcessedBefore;
            block43: {
                String sql;
                long total;
                numProcessedBefore = 0;
                long minId = 1L;
                if (idProcessedInLastProcess != null) {
                    minId = idProcessedInLastProcess + 1L;
                    numProcessedBefore = numProcessedInLastProcess;
                }
                this.deleteFromTableWithLargerId(type.getTableName(), "ID", minId - 1L, LOG);
                switch (type) {
                    case CERT: {
                        total = certstore.getCountCerts();
                        sql = SQL_ADD_CERT;
                        break;
                    }
                    case CRL: {
                        total = certstore.getCountCrls();
                        sql = SQL_ADD_CRL;
                        break;
                    }
                    case REQUEST: {
                        total = certstore.getCountRequests();
                        sql = SQL_ADD_REQUEST;
                        break;
                    }
                    case REQCERT: {
                        total = certstore.getCountReqCerts();
                        sql = SQL_ADD_REQCERT;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unsupported DbEntryType " + (Object)((Object)type));
                    }
                }
                long remainingTotal = total - (long)numProcessedBefore;
                processLog = new ProcessLog(remainingTotal);
                System.out.println("importing entries to " + tablesText + " from ID " + minId);
                processLog.printHeader();
                stmt = null;
                try {
                    DbPorter.DbPortFileNameIterator entriesFileIterator = new DbPorter.DbPortFileNameIterator(this.baseDir + File.separator + type.getDirName() + ".mf");
                    Throwable throwable = null;
                    try {
                        stmt = this.prepareStatement(sql);
                        while (entriesFileIterator.hasNext()) {
                            String entriesFile;
                            block42: {
                                entriesFile = this.baseDir + File.separator + type.getDirName() + File.separator + entriesFileIterator.next();
                                int fromIdx = entriesFile.indexOf(45);
                                int toIdx = entriesFile.indexOf(".zip");
                                if (fromIdx != -1 && toIdx != -1) {
                                    try {
                                        long toId = Integer.parseInt(entriesFile.substring(fromIdx + 1, toIdx));
                                        if (toId < minId) {
                                            continue;
                                        }
                                        break block42;
                                    }
                                    catch (Exception ex) {
                                        LOG.warn("invalid file name '{}', but will still be processed", (Object)entriesFile);
                                        break block42;
                                    }
                                }
                                LOG.warn("invalid file name '{}', but will still be processed", (Object)entriesFile);
                            }
                            try {
                                long lastId;
                                switch (type) {
                                    case CERT: {
                                        lastId = this.importCerts(entriesFile, minId, processLogFile, processLog, numProcessedBefore, stmt, sql);
                                        break;
                                    }
                                    case CRL: {
                                        lastId = this.importCrls(entriesFile, minId, processLogFile, processLog, numProcessedBefore, stmt, sql);
                                        break;
                                    }
                                    case REQUEST: {
                                        lastId = this.importRequests(entriesFile, minId, processLogFile, processLog, numProcessedBefore, stmt, sql);
                                        break;
                                    }
                                    case REQCERT: {
                                        lastId = this.importReqCerts(entriesFile, minId, processLogFile, processLog, numProcessedBefore, stmt, sql);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException("unknown CaDbEntryType " + (Object)((Object)type));
                                    }
                                }
                                minId = lastId + 1L;
                            }
                            catch (Exception ex) {
                                System.err.println("\ncould not import entries from file " + entriesFile + ".\nplease continue with the option '--resume'");
                                LOG.error("Exception", (Throwable)ex);
                                Exception exception = ex;
                                if (entriesFileIterator != null) {
                                    if (throwable != null) {
                                        try {
                                            entriesFileIterator.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    } else {
                                        entriesFileIterator.close();
                                    }
                                }
                                this.releaseResources(stmt, null);
                                return exception;
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (entriesFileIterator == null) throw throwable4;
                            if (throwable == null) {
                                entriesFileIterator.close();
                                throw throwable4;
                            }
                            try {
                                entriesFileIterator.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                    if (entriesFileIterator == null) break block43;
                    if (throwable != null) {
                        try {
                            entriesFileIterator.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        entriesFileIterator.close();
                    }
                }
                catch (Throwable throwable) {
                    this.releaseResources(stmt, null);
                    throw throwable;
                }
            }
            this.releaseResources(stmt, null);
            processLog.printTrailer();
            CaCertstoreDbImporter.echoToFile((Object)((Object)type) + ":" + ((long)numProcessedBefore + processLog.numProcessed()) + ":-1", processLogFile);
            System.out.println(" imported " + processLog.numProcessed() + " entries");
            return null;
        }
        catch (Exception ex) {
            System.err.println("\nimporting " + tablesText + " has been cancelled due to error,\nplease continue with the option '--resume'");
            LOG.error("Exception", (Throwable)ex);
            return ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importCerts(String entriesZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess, PreparedStatement stmt, String sql) throws Exception {
        CaCertstore.Certs certs;
        DbPorter.CaDbEntryType type = DbPorter.CaDbEntryType.CERT;
        int numEntriesPerCommit = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerCommit));
        ZipFile zipFile = new ZipFile(new File(entriesZipFile));
        ZipEntry entriesEntry = zipFile.getEntry("overview.json");
        try {
            certs = (CaCertstore.Certs)((Object)JSON.parseObject((InputStream)zipFile.getInputStream(entriesEntry), CaCertstore.Certs.class, (Feature[])new Feature[0]));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)entriesZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + entriesZipFile, (Throwable)e2);
            }
            throw ex;
        }
        certs.validate();
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulEntryId = 0L;
            List<CaCertstore.Cert> list = certs.getCerts();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                TBSCertificate tbsCert;
                CaCertstore.Cert cert = list.get(i);
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                long id = cert.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                String filename = cert.getFile();
                ZipEntry certZipEnty = zipFile.getEntry(filename);
                byte[] encodedCert = IoUtil.read((InputStream)zipFile.getInputStream(certZipEnty));
                try {
                    Certificate cc = Certificate.getInstance((Object)encodedCert);
                    tbsCert = cc.getTBSCertificate();
                }
                catch (RuntimeException ex) {
                    LOG.error("could not parse certificate in file {}", (Object)filename);
                    LOG.debug("could not parse certificate in file " + filename, (Throwable)ex);
                    throw new CertificateException(ex.getMessage(), ex);
                }
                String b64Sha1FpCert = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encodedCert});
                String subjectText = X509Util.cutX500Name((X500Name)tbsCert.getSubject(), (int)this.maxX500nameLen);
                try {
                    int idx = 1;
                    stmt.setLong(idx++, id);
                    stmt.setLong(idx++, cert.getUpdate());
                    stmt.setString(idx++, tbsCert.getSerialNumber().getPositiveValue().toString(16));
                    stmt.setString(idx++, subjectText);
                    long fpSubject = X509Util.fpCanonicalizedName((X500Name)tbsCert.getSubject());
                    stmt.setLong(idx++, fpSubject);
                    if (cert.getFpRs() != null) {
                        stmt.setLong(idx++, cert.getFpRs());
                    } else {
                        stmt.setNull(idx++, -5);
                    }
                    stmt.setLong(idx++, tbsCert.getStartDate().getDate().getTime() / 1000L);
                    stmt.setLong(idx++, tbsCert.getEndDate().getDate().getTime() / 1000L);
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getRev());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getRr());
                    CaCertstoreDbImporter.setLong(stmt, idx++, cert.getRt());
                    CaCertstoreDbImporter.setLong(stmt, idx++, cert.getRit());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getPid());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getCaId());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getRid());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getUid());
                    Extension extension = tbsCert.getExtensions().getExtension(Extension.basicConstraints);
                    boolean ee = true;
                    if (extension != null) {
                        ASN1Encodable asn1 = extension.getParsedValue();
                        ee = !BasicConstraints.getInstance((Object)asn1).isCA();
                    }
                    stmt.setInt(idx++, ee ? 1 : 0);
                    stmt.setInt(idx++, cert.getReqType());
                    String tidS = null;
                    if (cert.getTid() != null) {
                        tidS = cert.getTid();
                    }
                    stmt.setString(idx++, tidS);
                    stmt.setString(idx++, b64Sha1FpCert);
                    stmt.setString(idx++, cert.getRs());
                    stmt.setInt(idx++, cert.getCrlScope());
                    stmt.setString(idx, Base64.encodeToString((byte[])encodedCert));
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    throw this.translate(sql, ex);
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numEntriesInBatch <= 0 || numEntriesInBatch % numEntriesPerCommit != 0 && !isLastBlock) continue;
                try {
                    stmt.executeBatch();
                    this.commit("(commit import to CA)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteFromTableWithLargerId(type.getTableName(), "ID", id, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate(sql, (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulEntryId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                CaCertstoreDbImporter.echoToFile((Object)((Object)type) + ":" + ((long)numProcessedInLastProcess + processLog.numProcessed()) + ":" + lastSuccessfulEntryId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulEntryId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importCrls(String entriesZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess, PreparedStatement stmt, String sql) throws Exception {
        CaCertstore.Crls crls;
        DbPorter.CaDbEntryType type = DbPorter.CaDbEntryType.CRL;
        int numEntriesPerCommit = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerCommit));
        ZipFile zipFile = new ZipFile(new File(entriesZipFile));
        ZipEntry entriesEntry = zipFile.getEntry("overview.json");
        try {
            crls = (CaCertstore.Crls)((Object)JSON.parseObject((InputStream)zipFile.getInputStream(entriesEntry), CaCertstore.Crls.class, (Feature[])new Feature[0]));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)entriesZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + entriesZipFile, (Throwable)e2);
            }
            throw ex;
        }
        crls.validate();
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulEntryId = 0L;
            List<CaCertstore.Crl> list = crls.getCrls();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                X509CRLHolder x509crl;
                CaCertstore.Crl crl = list.get(i);
                long id = crl.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                String filename = crl.getFile();
                ZipEntry zipEnty = zipFile.getEntry(filename);
                byte[] encodedCrl = IoUtil.read((InputStream)zipFile.getInputStream(zipEnty));
                try {
                    x509crl = X509Util.parseCrl((byte[])encodedCrl);
                }
                catch (Exception ex) {
                    LOG.error("could not parse CRL in file {}", (Object)filename);
                    LOG.debug("could not parse CRL in file " + filename, (Throwable)ex);
                    if (ex instanceof CRLException) {
                        throw ex;
                    }
                    throw new CRLException(ex.getMessage(), ex);
                }
                try {
                    Extensions extns = x509crl.getExtensions();
                    byte[] extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.cRLNumber);
                    if (extnValue == null) {
                        LOG.warn("CRL without CRL number, ignore it");
                        continue;
                    }
                    BigInteger crlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                    BigInteger baseCrlNumber = null;
                    extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.deltaCRLIndicator);
                    if (extnValue != null) {
                        baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                    }
                    int idx = 1;
                    stmt.setLong(idx++, crl.getId());
                    stmt.setInt(idx++, crl.getCaId());
                    stmt.setLong(idx++, crlNumber.longValue());
                    stmt.setLong(idx++, x509crl.getThisUpdate().getTime() / 1000L);
                    if (x509crl.getNextUpdate() != null) {
                        stmt.setLong(idx++, x509crl.getNextUpdate().getTime() / 1000L);
                    } else {
                        stmt.setNull(idx++, 4);
                    }
                    if (baseCrlNumber == null) {
                        CaCertstoreDbImporter.setBoolean(stmt, idx++, false);
                        stmt.setNull(idx++, -5);
                    } else {
                        CaCertstoreDbImporter.setBoolean(stmt, idx++, true);
                        stmt.setLong(idx++, baseCrlNumber.longValue());
                    }
                    stmt.setInt(idx++, crl.getCrlScope());
                    stmt.setString(idx, Base64.encodeToString((byte[])encodedCrl));
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CRL with ID=" + crl.getId() + ", message: " + ex.getMessage());
                    throw ex;
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numEntriesInBatch <= 0 || numEntriesInBatch % numEntriesPerCommit != 0 && !isLastBlock) continue;
                try {
                    stmt.executeBatch();
                    this.commit("(commit import to CA)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteFromTableWithLargerId(type.getTableName(), "ID", id, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate(sql, (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulEntryId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                CaCertstoreDbImporter.echoToFile((Object)((Object)type) + ":" + ((long)numProcessedInLastProcess + processLog.numProcessed()) + ":" + lastSuccessfulEntryId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulEntryId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importRequests(String entriesZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess, PreparedStatement stmt, String sql) throws Exception {
        CaCertstore.Requests requests;
        DbPorter.CaDbEntryType type = DbPorter.CaDbEntryType.REQUEST;
        int numEntriesPerCommit = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerCommit));
        ZipFile zipFile = new ZipFile(new File(entriesZipFile));
        ZipEntry entriesEntry = zipFile.getEntry("overview.json");
        try {
            requests = (CaCertstore.Requests)((Object)JSON.parseObject((InputStream)zipFile.getInputStream(entriesEntry), CaCertstore.Requests.class, (Feature[])new Feature[0]));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)entriesZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + entriesZipFile, (Throwable)e2);
            }
            throw ex;
        }
        requests.validate();
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulEntryId = 0L;
            List<CaCertstore.Request> list = requests.getRequests();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                CaCertstore.Request request = list.get(i);
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                long id = request.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                String filename = request.getFile();
                ZipEntry zipEnty = zipFile.getEntry(filename);
                byte[] encodedRequest = IoUtil.read((InputStream)zipFile.getInputStream(zipEnty));
                try {
                    int idx = 1;
                    stmt.setLong(idx++, request.getId());
                    stmt.setLong(idx++, request.getUpdate());
                    stmt.setString(idx, Base64.encodeToString((byte[])encodedRequest));
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    System.err.println("could not import REQUEST with ID=" + request.getId() + ", message: " + ex.getMessage());
                    throw ex;
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numEntriesInBatch <= 0 || numEntriesInBatch % numEntriesPerCommit != 0 && !isLastBlock) continue;
                try {
                    stmt.executeBatch();
                    this.commit("(commit import to CA)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteFromTableWithLargerId(type.getTableName(), "ID", id, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate(sql, (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulEntryId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                CaCertstoreDbImporter.echoToFile((Object)((Object)type) + ":" + ((long)numProcessedInLastProcess + processLog.numProcessed()) + ":" + lastSuccessfulEntryId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulEntryId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importReqCerts(String entriesZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess, PreparedStatement stmt, String sql) throws Exception {
        CaCertstore.ReqCerts reqCerts;
        DbPorter.CaDbEntryType type = DbPorter.CaDbEntryType.REQCERT;
        int numEntriesPerCommit = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerCommit));
        ZipFile zipFile = new ZipFile(new File(entriesZipFile));
        ZipEntry entriesEntry = zipFile.getEntry("overview.json");
        try {
            reqCerts = (CaCertstore.ReqCerts)((Object)JSON.parseObject((InputStream)zipFile.getInputStream(entriesEntry), CaCertstore.ReqCerts.class, (Feature[])new Feature[0]));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)entriesZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + entriesZipFile, (Throwable)e2);
            }
            throw ex;
        }
        reqCerts.validate();
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulEntryId = 0L;
            List<CaCertstore.ReqCert> list = reqCerts.getReqCerts();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                CaCertstore.ReqCert reqCert = list.get(i);
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                long id = reqCert.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                try {
                    int idx = 1;
                    stmt.setLong(idx++, reqCert.getId());
                    stmt.setLong(idx++, reqCert.getRid());
                    stmt.setLong(idx, reqCert.getCid());
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    System.err.println("could not import REQUEST with ID=" + reqCert.getId() + ", message: " + ex.getMessage());
                    throw ex;
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numEntriesInBatch <= 0 || numEntriesInBatch % numEntriesPerCommit != 0 && !isLastBlock) continue;
                try {
                    stmt.executeBatch();
                    this.commit("(commit import to CA)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteFromTableWithLargerId(type.getTableName(), "ID", id, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate(sql, (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulEntryId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                CaCertstoreDbImporter.echoToFile((Object)((Object)type) + ":" + ((long)numProcessedInLastProcess + processLog.numProcessed()) + ":" + lastSuccessfulEntryId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulEntryId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }
}

