/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.cert.CRLException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;

class CaCertstoreDbExporter
extends DbPorter {
    private static final Logger LOG = LoggerFactory.getLogger(CaCertstoreDbExporter.class);
    private final int numCertsInBundle;
    private final int numCertsPerSelect;
    private final boolean resume;

    CaCertstoreDbExporter(DataSourceWrapper datasource, String baseDir, int numCertsInBundle, int numCertsPerSelect, boolean resume, AtomicBoolean stopMe) throws DataAccessException {
        super(datasource, baseDir, stopMe);
        this.numCertsInBundle = Args.positive((int)numCertsInBundle, (String)"numCertsInBundle");
        this.numCertsPerSelect = Args.positive((int)numCertsPerSelect, (String)"numCertsPerSelect");
        this.resume = resume;
    }

    public void export() throws Exception {
        CaCertstore certstore;
        if (this.resume) {
            try (InputStream is = Files.newInputStream(Paths.get(this.baseDir, "ca-certstore.json"), new OpenOption[0]);){
                certstore = (CaCertstore)((Object)JSON.parseObject((InputStream)is, CaCertstore.class, (Feature[])new Feature[0]));
            }
            certstore.validate();
            if (certstore.getVersion() > 1) {
                throw new Exception("could not continue with CertStore greater than 1: " + certstore.getVersion());
            }
        } else {
            certstore = new CaCertstore();
            certstore.setVersion(1);
        }
        Exception exception = null;
        System.out.println("exporting CA certstore from database");
        try {
            DbPorter.CaDbEntryType[] types;
            byte[] content;
            if (!this.resume) {
                this.exportPublishQueue(certstore);
            }
            File processLogFile = new File(this.baseDir, "export.process");
            Long idProcessedInLastProcess = null;
            DbPorter.CaDbEntryType typeProcessedInLastProcess = null;
            if (processLogFile.exists() && (content = IoUtil.read((File)processLogFile)) != null && content.length > 0) {
                DbPorter.CaDbEntryType[] str = StringUtil.toUtf8String((byte[])content);
                int idx = str.indexOf(58);
                String typeName = str.substring(0, idx).trim();
                typeProcessedInLastProcess = DbPorter.CaDbEntryType.valueOf(typeName);
                idProcessedInLastProcess = Long.parseLong(str.substring(idx + 1).trim());
            }
            if (DbPorter.CaDbEntryType.CRL == typeProcessedInLastProcess || typeProcessedInLastProcess == null) {
                exception = this.exportEntries(DbPorter.CaDbEntryType.CRL, certstore, processLogFile, idProcessedInLastProcess);
                typeProcessedInLastProcess = null;
                idProcessedInLastProcess = null;
            }
            for (DbPorter.CaDbEntryType type : types = new DbPorter.CaDbEntryType[]{DbPorter.CaDbEntryType.CERT, DbPorter.CaDbEntryType.REQUEST, DbPorter.CaDbEntryType.REQCERT}) {
                if (exception != null || type != typeProcessedInLastProcess && typeProcessedInLastProcess != null) continue;
                exception = this.exportEntries(type, certstore, processLogFile, idProcessedInLastProcess);
                typeProcessedInLastProcess = null;
                idProcessedInLastProcess = null;
            }
            certstore.validate();
            try (OutputStream os = Files.newOutputStream(Paths.get(this.baseDir, "ca-certstore.json"), new OpenOption[0]);){
                JSON.writeJSONString((OutputStream)os, (Charset)StandardCharsets.UTF_8, (Object)((Object)certstore), (SerializerFeature[])new SerializerFeature[0]);
            }
        }
        catch (Exception ex) {
            System.err.println("could not export CA certstore from database");
            exception = ex;
        }
        if (exception != null) {
            throw exception;
        }
        System.out.println(" exported CA certstore from database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception exportEntries(DbPorter.CaDbEntryType type, CaCertstore certstore, File processLogFile, Long idProcessedInLastProcess) {
        String tablesText = "table " + type.getTableName();
        File dir = new File(this.baseDir, type.getDirName());
        dir.mkdirs();
        OutputStream entriesFileOs = null;
        try {
            entriesFileOs = Files.newOutputStream(Paths.get(this.baseDir, type.getDirName() + ".mf"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            this.exportEntries(type, certstore, processLogFile, entriesFileOs, idProcessedInLastProcess);
            Exception exception = null;
            IoUtil.closeQuietly((Closeable)entriesFileOs);
            return exception;
        }
        catch (Exception ex) {
            CaCertstoreDbExporter.deleteTmpFiles(this.baseDir, "tmp-");
            System.err.println("\nexporting " + tablesText + " has been cancelled due to error,\nplease continue with the option '--resume'");
            LOG.error("Exception", (Throwable)ex);
            Exception exception = ex;
            return exception;
        }
        finally {
            IoUtil.closeQuietly(entriesFileOs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEntries(DbPorter.CaDbEntryType type, CaCertstore certstore, File processLogFile, OutputStream filenameListOs, Long idProcessedInLastProcess) throws Exception {
        String coreSql;
        int numProcessedBefore;
        int numEntriesPerSelect = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerSelect));
        int numEntriesPerZip = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsInBundle));
        File entriesDir = new File(this.baseDir, type.getDirName());
        String tableName = type.getTableName();
        switch (type) {
            case CERT: {
                numProcessedBefore = certstore.getCountCerts();
                coreSql = "ID,SN,CA_ID,PID,RID,RTYPE,TID,UID,EE,LUPDATE,REV,RR,RT,RIT,FP_RS,REQ_SUBJECT,CRL_SCOPE,CERT FROM CERT WHERE ID>=?";
                break;
            }
            case CRL: {
                numProcessedBefore = certstore.getCountCrls();
                coreSql = "ID,CA_ID,CRL_SCOPE,CRL FROM CRL WHERE ID>=?";
                break;
            }
            case REQUEST: {
                numProcessedBefore = certstore.getCountRequests();
                coreSql = "ID,LUPDATE,DATA FROM REQUEST WHERE ID>=?";
                break;
            }
            case REQCERT: {
                numProcessedBefore = certstore.getCountReqCerts();
                coreSql = "ID,RID,CID FROM REQCERT WHERE ID>=?";
                break;
            }
            default: {
                throw new IllegalStateException("unknown CaDbEntryType " + (Object)((Object)type));
            }
        }
        long minId = idProcessedInLastProcess != null ? idProcessedInLastProcess + 1L : this.min(tableName, "ID");
        String tablesText = "table " + type.getTableName();
        System.out.println("exporting " + tablesText + " from ID " + minId);
        long maxId = this.max(tableName, "ID");
        long total = this.count(tableName) - numProcessedBefore;
        if (total < 1L) {
            total = 1L;
        }
        String sql = this.datasource.buildSelectFirstSql(numEntriesPerSelect, "ID ASC", coreSql);
        Object entriesInCurrentFile = CaCertstoreDbExporter.createContainer(type);
        PreparedStatement ps = this.prepareStatement(sql);
        int numEntriesInCurrentFile = 0;
        int sum = 0;
        File currentEntriesZipFile = new File(this.baseDir, "tmp-" + type.getDirName() + "-" + System.currentTimeMillis() + ".zip");
        ZipOutputStream currentEntriesZip = CaCertstoreDbExporter.getZipOutputStream(currentEntriesZipFile);
        long minIdOfCurrentFile = -1L;
        long maxIdOfCurrentFile = -1L;
        ProcessLog processLog = new ProcessLog(total);
        processLog.printHeader();
        try {
            Long id = null;
            boolean interrupted = false;
            long lastMaxId = minId - 1L;
            while (true) {
                if (this.stopMe.get()) {
                    interrupted = true;
                    break;
                }
                ps.setLong(1, lastMaxId + 1L);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) break;
                do {
                    ZipEntry certZipEntry;
                    String sha1;
                    if (lastMaxId < (id = Long.valueOf(rs.getLong("ID")))) {
                        lastMaxId = id;
                    }
                    if (minIdOfCurrentFile == -1L) {
                        minIdOfCurrentFile = id;
                    } else if (minIdOfCurrentFile > id) {
                        minIdOfCurrentFile = id;
                    }
                    if (maxIdOfCurrentFile == -1L) {
                        maxIdOfCurrentFile = id;
                    } else if (maxIdOfCurrentFile < id) {
                        maxIdOfCurrentFile = id;
                    }
                    if (DbPorter.CaDbEntryType.CERT == type) {
                        int userId;
                        byte[] certBytes = Base64.decodeFast((String)rs.getString("CERT"));
                        sha1 = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{certBytes});
                        String certFileName = sha1 + ".der";
                        certZipEntry = new ZipEntry(certFileName);
                        currentEntriesZip.putNextEntry(certZipEntry);
                        try {
                            currentEntriesZip.write(certBytes);
                        }
                        finally {
                            currentEntriesZip.closeEntry();
                        }
                        CaCertstore.Cert cert = new CaCertstore.Cert();
                        cert.setId(id);
                        cert.setCaId(rs.getInt("CA_ID"));
                        cert.setEe(rs.getBoolean("EE"));
                        cert.setFile(certFileName);
                        long fpReqSubject = rs.getLong("FP_RS");
                        if (fpReqSubject != 0L) {
                            cert.setFpRs(fpReqSubject);
                            cert.setRs(rs.getString("REQ_SUBJECT"));
                        }
                        cert.setPid(rs.getInt("PID"));
                        cert.setReqType(rs.getInt("RTYPE"));
                        cert.setRid(rs.getInt("RID"));
                        cert.setSn(rs.getString("SN"));
                        String str = rs.getString("TID");
                        if (StringUtil.isNotBlank((String)str)) {
                            cert.setTid(str);
                        }
                        if ((userId = rs.getInt("UID")) != 0) {
                            cert.setUid(userId);
                        }
                        cert.setUpdate(rs.getLong("LUPDATE"));
                        int revoked = rs.getInt("REV");
                        cert.setRev(revoked);
                        if (revoked == 1) {
                            cert.setRr(rs.getInt("RR"));
                            cert.setRt(rs.getLong("RT"));
                            long revInvTime = rs.getLong("RIT");
                            if (revInvTime != 0L) {
                                cert.setRit(revInvTime);
                            }
                        }
                        cert.setCrlScope(rs.getInt("CRL_SCOPE"));
                        cert.validate();
                        ((CaCertstore.Certs)((Object)entriesInCurrentFile)).add(cert);
                    } else if (DbPorter.CaDbEntryType.CRL == type) {
                        X509CRLHolder x509Crl;
                        byte[] crlBytes = Base64.decodeFast((String)rs.getString("CRL"));
                        try {
                            x509Crl = X509Util.parseCrl((byte[])crlBytes);
                        }
                        catch (CRLException ex) {
                            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse CRL with id " + id));
                            throw ex;
                        }
                        catch (Exception ex) {
                            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse CRL with id " + id));
                            throw new CRLException(ex.getMessage(), ex);
                        }
                        byte[] extnValue = X509Util.getCoreExtValue((Extensions)x509Crl.getExtensions(), (ASN1ObjectIdentifier)Extension.cRLNumber);
                        if (extnValue == null) {
                            LOG.warn("CRL without CRL number, ignore it");
                            continue;
                        }
                        String sha12 = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{crlBytes});
                        String crlFilename = sha12 + ".crl";
                        ZipEntry certZipEntry2 = new ZipEntry(crlFilename);
                        currentEntriesZip.putNextEntry(certZipEntry2);
                        try {
                            currentEntriesZip.write(crlBytes);
                        }
                        finally {
                            currentEntriesZip.closeEntry();
                        }
                        CaCertstore.Crl crl = new CaCertstore.Crl();
                        crl.setId(id);
                        crl.setCaId(rs.getInt("CA_ID"));
                        BigInteger crlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                        crl.setCrlNo(crlNumber.toString());
                        crl.setCrlScope(rs.getInt("CRL_SCOPE"));
                        crl.setFile(crlFilename);
                        crl.validate();
                        ((CaCertstore.Crls)((Object)entriesInCurrentFile)).add(crl);
                    } else if (DbPorter.CaDbEntryType.REQUEST == type) {
                        byte[] dataBytes = Base64.decodeFast((String)rs.getString("DATA"));
                        sha1 = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{dataBytes});
                        String dataFilename = sha1 + ".req";
                        certZipEntry = new ZipEntry(dataFilename);
                        currentEntriesZip.putNextEntry(certZipEntry);
                        try {
                            currentEntriesZip.write(dataBytes);
                        }
                        finally {
                            currentEntriesZip.closeEntry();
                        }
                        CaCertstore.Request entry = new CaCertstore.Request();
                        entry.setId(id);
                        entry.setUpdate(rs.getLong("LUPDATE"));
                        entry.setFile(dataFilename);
                        entry.validate();
                        ((CaCertstore.Requests)((Object)entriesInCurrentFile)).add(entry);
                    } else if (DbPorter.CaDbEntryType.REQCERT == type) {
                        CaCertstore.ReqCert entry = new CaCertstore.ReqCert();
                        entry.setId(id);
                        entry.setCid(rs.getLong("CID"));
                        entry.setRid(rs.getLong("RID"));
                        entry.validate();
                        ((CaCertstore.ReqCerts)((Object)entriesInCurrentFile)).add(entry);
                    } else {
                        throw new IllegalStateException("unknown CaDbEntryType " + (Object)((Object)type));
                    }
                    ++sum;
                    if (++numEntriesInCurrentFile != numEntriesPerZip) continue;
                    String currentEntriesFilename = CaCertstoreDbExporter.buildFilename(type.getDirName() + "_", ".zip", minIdOfCurrentFile, maxIdOfCurrentFile, maxId);
                    this.finalizeZip(currentEntriesZip, "overview.json", entriesInCurrentFile);
                    currentEntriesZipFile.renameTo(new File(entriesDir, currentEntriesFilename));
                    CaCertstoreDbExporter.writeLine(filenameListOs, currentEntriesFilename);
                    CaCertstoreDbExporter.setCount(type, certstore, numProcessedBefore + sum);
                    CaCertstoreDbExporter.echoToFile(tableName + ":" + id, processLogFile);
                    processLog.addNumProcessed((long)numEntriesInCurrentFile);
                    processLog.printStatus();
                    entriesInCurrentFile = CaCertstoreDbExporter.createContainer(type);
                    numEntriesInCurrentFile = 0;
                    minIdOfCurrentFile = -1L;
                    maxIdOfCurrentFile = -1L;
                    currentEntriesZipFile = new File(this.baseDir, "tmp-" + type.getDirName() + "-" + System.currentTimeMillis() + ".zip");
                    currentEntriesZip = CaCertstoreDbExporter.getZipOutputStream(currentEntriesZipFile);
                } while (rs.next());
                rs.close();
            }
            if (interrupted) {
                currentEntriesZip.close();
                throw new InterruptedException("interrupted by the user");
            }
            if (numEntriesInCurrentFile > 0) {
                this.finalizeZip(currentEntriesZip, "overview.json", entriesInCurrentFile);
                String currentEntriesFilename = CaCertstoreDbExporter.buildFilename(type.getDirName() + "_", ".zip", minIdOfCurrentFile, maxIdOfCurrentFile, maxId);
                currentEntriesZipFile.renameTo(new File(entriesDir, currentEntriesFilename));
                CaCertstoreDbExporter.writeLine(filenameListOs, currentEntriesFilename);
                CaCertstoreDbExporter.setCount(type, certstore, numProcessedBefore + sum);
                if (id != null) {
                    CaCertstoreDbExporter.echoToFile(Long.toString(id), processLogFile);
                }
                processLog.addNumProcessed((long)numEntriesInCurrentFile);
            } else {
                currentEntriesZip.close();
                currentEntriesZipFile.delete();
            }
        }
        catch (SQLException ex) {
            throw this.translate(null, ex);
        }
        finally {
            this.releaseResources(ps, null);
        }
        processLog.printTrailer();
        processLogFile.delete();
        System.out.println(" exported " + sum + " entries from " + tablesText);
    }

    private void exportPublishQueue(CaCertstore certstore) throws DataAccessException, InvalidConfException {
        System.out.println("exporting table PUBLISHQUEUE");
        String sql = "SELECT CID,PID,CA_ID FROM PUBLISHQUEUE WHERE CID>=? AND CID<? ORDER BY CID ASC";
        int minId = (int)this.min("PUBLISHQUEUE", "CID");
        int maxId = (int)this.max("PUBLISHQUEUE", "CID");
        LinkedList<CaCertstore.ToPublish> queue = new LinkedList<CaCertstore.ToPublish>();
        certstore.setPublishQueue(queue);
        if (maxId == 0) {
            System.out.println(" exported table PUBLISHQUEUE");
            return;
        }
        PreparedStatement ps = this.prepareStatement(sql);
        ResultSet rs = null;
        int n = 500;
        try {
            for (int i = minId; i <= maxId; i += 500) {
                ps.setInt(1, i);
                ps.setInt(2, i + 500);
                rs = ps.executeQuery();
                while (rs.next()) {
                    CaCertstore.ToPublish toPub = new CaCertstore.ToPublish();
                    toPub.setPubId(rs.getInt("PID"));
                    toPub.setCertId(rs.getInt("CID"));
                    toPub.setCaId(rs.getInt("CA_ID"));
                    toPub.validate();
                    queue.add(toPub);
                }
            }
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(ps, rs);
        }
        System.out.println(" exported table PUBLISHQUEUE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeZip(ZipOutputStream zipOutStream, String filename, Object container) throws IOException {
        ZipEntry certZipEntry = new ZipEntry(filename);
        zipOutStream.putNextEntry(certZipEntry);
        try {
            JSON.writeJSONString((OutputStream)zipOutStream, (Charset)StandardCharsets.UTF_8, (Object)container, (SerializerFeature[])new SerializerFeature[0]);
        }
        finally {
            zipOutStream.closeEntry();
        }
        zipOutStream.close();
    }

    private static Object createContainer(DbPorter.CaDbEntryType type) {
        switch (type) {
            case CERT: {
                return new CaCertstore.Certs();
            }
            case CRL: {
                return new CaCertstore.Crls();
            }
            case REQUEST: {
                return new CaCertstore.Requests();
            }
            case REQCERT: {
                return new CaCertstore.ReqCerts();
            }
        }
        throw new IllegalStateException("unknown CaDbEntryType " + (Object)((Object)type));
    }

    private static void setCount(DbPorter.CaDbEntryType type, CaCertstore certstore, int num) {
        switch (type) {
            case CERT: {
                certstore.setCountCerts(num);
                break;
            }
            case CRL: {
                certstore.setCountCrls(num);
                break;
            }
            case REQUEST: {
                certstore.setCountRequests(num);
                break;
            }
            case REQCERT: {
                certstore.setCountReqCerts(num);
                break;
            }
            default: {
                throw new IllegalStateException("unknown CaDbEntryType " + (Object)((Object)type));
            }
        }
    }
}

