/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.CaCertstoreDbExporter;
import org.xipki.ca.mgmt.db.port.CaCertstoreDbImporter;
import org.xipki.ca.mgmt.db.port.CaconfDbExporter;
import org.xipki.ca.mgmt.db.port.CaconfDbImporter;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.ca.mgmt.db.port.OcspCertStoreFromCaDbImporter;
import org.xipki.ca.mgmt.db.port.OcspCertstoreDbExporter;
import org.xipki.ca.mgmt.db.port.OcspCertstoreDbImporter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public abstract class DbPortWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DbPortWorker.class);
    protected final AtomicBoolean stopMe = new AtomicBoolean(false);
    protected final DataSourceWrapper datasource;
    private Exception exception;

    public DbPortWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile) throws PasswordResolverException, IOException {
        Properties props = DbPorter.getDbConfProperties(Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)dbConfFile), new String[0]), new OpenOption[0]));
        this.datasource = datasourceFactory.createDataSource("ds-" + dbConfFile, props, passwordResolver);
    }

    public final Exception exception() {
        return this.exception;
    }

    public void setStopMe(boolean stopMe) {
        this.stopMe.set(stopMe);
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Exception ex) {
            LOG.error("exception thrown", (Throwable)ex);
            this.exception = ex;
        }
    }

    protected abstract void run0() throws Exception;

    public static class ImportOcspFromCaDb
    extends DbPortWorker {
        private final String publisherName;
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;

        public ImportOcspFromCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String publisherName, boolean resume, String srcFolder, int batchEntriesPerCommit) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile);
            this.publisherName = publisherName;
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = System.currentTimeMillis();
            try {
                OcspCertStoreFromCaDbImporter certStoreImporter = new OcspCertStoreFromCaDbImporter(this.datasource, this.srcFolder, this.publisherName, this.batchEntriesPerCommit, this.resume, this.stopMe);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                long end = System.currentTimeMillis();
                System.out.println("finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
            }
        }
    }

    public static class ImportOcspDb
    extends DbPortWorker {
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;

        public ImportOcspDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, boolean resume, String srcFolder, int batchEntriesPerCommit) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile);
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = System.currentTimeMillis();
            try {
                OcspCertstoreDbImporter certStoreImporter = new OcspCertstoreDbImporter(this.datasource, this.srcFolder, this.batchEntriesPerCommit, this.resume, this.stopMe);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                long end = System.currentTimeMillis();
                System.out.println("finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
            }
        }
    }

    public static class ExportOcspDb
    extends DbPortWorker {
        private final String destFolder;
        private final boolean resume;
        private final int numCertsInBundle;
        private final int numCertsPerSelect;

        public ExportOcspDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String destFolder, boolean resume, int numCertsInBundle, int numCertsPerSelect) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile);
            String[] children;
            this.destFolder = Args.notBlank((String)destFolder, (String)destFolder);
            File file = new File(destFolder);
            if (!file.exists()) {
                file.mkdirs();
            } else {
                if (!file.isDirectory()) {
                    throw new IOException(destFolder + " is not a folder");
                }
                if (!file.canWrite()) {
                    throw new IOException(destFolder + " is not writable");
                }
            }
            if (!resume && (children = file.list()) != null && children.length > 0) {
                throw new IOException(destFolder + " is not empty");
            }
            this.resume = resume;
            this.numCertsInBundle = numCertsInBundle;
            this.numCertsPerSelect = numCertsPerSelect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = System.currentTimeMillis();
            try {
                OcspCertstoreDbExporter certStoreExporter = new OcspCertstoreDbExporter(this.datasource, this.destFolder, this.numCertsInBundle, this.numCertsPerSelect, this.resume, this.stopMe);
                certStoreExporter.export();
                certStoreExporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                long end = System.currentTimeMillis();
                System.out.println("finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
            }
        }
    }

    public static class ExportCaDb
    extends DbPortWorker {
        private final String destFolder;
        private final boolean resume;
        private final int numCertsInBundle;
        private final int numCertsPerSelect;

        public ExportCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, String destFolder, boolean resume, int numCertsInBundle, int numCertsPerSelect) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile);
            this.destFolder = IoUtil.expandFilepath((String)destFolder);
            this.resume = resume;
            this.numCertsInBundle = numCertsInBundle;
            this.numCertsPerSelect = numCertsPerSelect;
            this.checkDestFolder();
        }

        private void checkDestFolder() throws IOException {
            File file = new File(this.destFolder);
            if (!file.exists()) {
                file.mkdirs();
            } else {
                if (!file.isDirectory()) {
                    throw new IOException(this.destFolder + " is not a folder");
                }
                if (!file.canWrite()) {
                    throw new IOException(this.destFolder + " is not writable");
                }
            }
            File processLogFile = new File(this.destFolder, "export.process");
            if (this.resume) {
                if (!processLogFile.exists()) {
                    throw new IOException("could not process with '--resume' option");
                }
            } else {
                String[] children = file.list();
                if (children != null && children.length > 0) {
                    throw new IOException(this.destFolder + " is not empty");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            long start = System.currentTimeMillis();
            try {
                if (!this.resume) {
                    CaconfDbExporter caConfExporter = new CaconfDbExporter(this.datasource, this.destFolder, this.stopMe);
                    caConfExporter.export();
                    caConfExporter.close();
                }
                CaCertstoreDbExporter certStoreExporter = new CaCertstoreDbExporter(this.datasource, this.destFolder, this.numCertsInBundle, this.numCertsPerSelect, this.resume, this.stopMe);
                certStoreExporter.export();
                certStoreExporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                long end = System.currentTimeMillis();
                System.out.println("Finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
            }
        }
    }

    public static class ImportCaDb
    extends DbPortWorker {
        private final boolean resume;
        private final String srcFolder;
        private final int batchEntriesPerCommit;

        public ImportCaDb(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile, boolean resume, String srcFolder, int batchEntriesPerCommit) throws PasswordResolverException, IOException {
            super(datasourceFactory, passwordResolver, dbConfFile);
            this.resume = resume;
            this.srcFolder = IoUtil.expandFilepath((String)srcFolder);
            this.batchEntriesPerCommit = batchEntriesPerCommit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run0() throws Exception {
            File processLogFile = new File(this.srcFolder, "import.process");
            if (this.resume) {
                if (!processLogFile.exists()) {
                    throw new Exception("could not process with '--resume' option");
                }
            } else if (processLogFile.exists()) {
                throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
            }
            long start = System.currentTimeMillis();
            try {
                if (!this.resume) {
                    CaconfDbImporter caConfImporter = new CaconfDbImporter(this.datasource, this.srcFolder, this.stopMe);
                    caConfImporter.importToDb();
                    caConfImporter.close();
                }
                CaCertstoreDbImporter certStoreImporter = new CaCertstoreDbImporter(this.datasource, this.srcFolder, this.batchEntriesPerCommit, this.resume, this.stopMe);
                certStoreImporter.importToDb();
                certStoreImporter.close();
            }
            finally {
                try {
                    this.datasource.close();
                }
                catch (Throwable th) {
                    LOG.error("datasource.close()", th);
                }
                long end = System.currentTimeMillis();
                System.out.println("Finished in " + StringUtil.formatTime((long)((end - start) / 1000L), (boolean)false));
            }
        }
    }
}

