/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.MgmtMessage;
import org.xipki.ca.api.mgmt.MgmtRequest;
import org.xipki.ca.api.mgmt.MgmtResponse;
import org.xipki.ca.api.mgmt.entry.AddUserEntry;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.CaHasUserEntry;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.mgmt.entry.ChangeUserEntry;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.api.mgmt.entry.UserEntry;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;
import org.xipki.util.http.SslContextConf;

public class CaMgmtClient
implements CaManager {
    private static final String REQUEST_CT = "application/json";
    private static final String RESPONSE_CT = "application/json";
    private final Map<MgmtMessage.MgmtAction, URL> actionUrlMap = new HashMap<MgmtMessage.MgmtAction, URL>(50);
    private String serverUrl;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private final SslContextConf sslContextConf;
    private boolean initialized;
    private CaMgmtException initException;

    public CaMgmtClient(SslContextConf sslContextConf) {
        this.sslContextConf = sslContextConf;
    }

    public synchronized void initIfNotDone() throws CaMgmtException {
        if (this.initException != null) {
            throw this.initException;
        }
        if (this.initialized) {
            return;
        }
        if (this.sslContextConf != null && this.sslContextConf.isUseSslConf()) {
            try {
                this.sslSocketFactory = this.sslContextConf.getSslSocketFactory();
                this.hostnameVerifier = this.sslContextConf.buildHostnameVerifier();
            }
            catch (ObjectCreationException ex) {
                this.initException = new CaMgmtException("could not initialize CaMgmtClient: " + ex.getMessage(), (Throwable)ex);
                throw this.initException;
            }
        }
        this.initialized = true;
    }

    public void setServerUrl(String serverUrl) throws MalformedURLException {
        Args.notBlank((String)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        for (MgmtMessage.MgmtAction action : MgmtMessage.MgmtAction.values()) {
            this.actionUrlMap.put(action, new URL(this.serverUrl + action));
        }
    }

    public CaSystemStatus getCaSystemStatus() throws CaMgmtException {
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCaSystemStatus, null);
        MgmtResponse.GetCaSystemStatus resp = (MgmtResponse.GetCaSystemStatus)CaMgmtClient.parse(respBytes, MgmtResponse.GetCaSystemStatus.class);
        return resp.getResult();
    }

    public void unlockCa() throws CaMgmtException {
        this.voidTransmit(MgmtMessage.MgmtAction.unlockCa, null);
    }

    public void notifyCaChange() throws CaMgmtException {
        this.voidTransmit(MgmtMessage.MgmtAction.notifyCaChange, null);
    }

    public void republishCertificates(String caName, List<String> publisherNames, int numThreads) throws CaMgmtException {
        MgmtRequest.RepublishCertificates req = new MgmtRequest.RepublishCertificates();
        req.setCaName(caName);
        req.setPublisherNames(publisherNames);
        req.setNumThreads(numThreads);
        this.voidTransmit(MgmtMessage.MgmtAction.republishCertificates, (MgmtRequest)req);
    }

    public void clearPublishQueue(String caName, List<String> publisherNames) throws CaMgmtException {
        MgmtRequest.ClearPublishQueue req = new MgmtRequest.ClearPublishQueue();
        req.setCaName(caName);
        req.setPublisherNames(publisherNames);
        this.voidTransmit(MgmtMessage.MgmtAction.clearPublishQueue, (MgmtRequest)req);
    }

    public void removeCa(String caName) throws CaMgmtException {
        this.removeEntity(MgmtMessage.MgmtAction.removeCa, caName);
    }

    public void restartCa(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        this.voidTransmit(MgmtMessage.MgmtAction.restartCa, (MgmtRequest)req);
    }

    public void restartCaSystem() throws CaMgmtException {
        this.voidTransmit(MgmtMessage.MgmtAction.restartCaSystem, null);
    }

    public void addCaAlias(String aliasName, String caName) throws CaMgmtException {
        MgmtRequest.AddCaAlias req = new MgmtRequest.AddCaAlias();
        req.setAliasName(aliasName);
        req.setCaName(caName);
        this.voidTransmit(MgmtMessage.MgmtAction.addCaAlias, (MgmtRequest)req);
    }

    public void removeCaAlias(String aliasName) throws CaMgmtException {
        this.removeEntity(MgmtMessage.MgmtAction.removeCaAlias, aliasName);
    }

    public Set<String> getAliasesForCa(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getAliasesForCa, (MgmtRequest)req);
        MgmtResponse.StringSet resp = (MgmtResponse.StringSet)CaMgmtClient.parse(respBytes, MgmtResponse.StringSet.class);
        return resp.getResult();
    }

    public String getCaNameForAlias(String aliasName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(aliasName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCaNameForAlias, (MgmtRequest)req);
        MgmtResponse.StringResponse resp = (MgmtResponse.StringResponse)CaMgmtClient.parse(respBytes, MgmtResponse.StringResponse.class);
        return resp.getResult();
    }

    public Set<String> getCaAliasNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getCaAliasNames);
    }

    public Set<String> getCertprofileNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getCertprofileNames);
    }

    public Set<String> getPublisherNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getPublisherNames);
    }

    public Set<String> getRequestorNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getRequestorNames);
    }

    public Set<String> getSignerNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getSignerNames);
    }

    public Set<String> getCaNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getCaNames);
    }

    public Set<String> getSuccessfulCaNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getSuccessfulCaNames);
    }

    public Set<String> getFailedCaNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getFailedCaNames);
    }

    public Set<String> getInactiveCaNames() throws CaMgmtException {
        return this.getNames(MgmtMessage.MgmtAction.getInactiveCaNames);
    }

    private Set<String> getNames(MgmtMessage.MgmtAction action) throws CaMgmtException {
        byte[] respBytes = this.transmit(action, null);
        MgmtResponse.StringSet resp = (MgmtResponse.StringSet)CaMgmtClient.parse(respBytes, MgmtResponse.StringSet.class);
        return resp.getResult();
    }

    public void addCa(CaEntry caEntry) throws CaMgmtException {
        MgmtRequest.AddCa req = new MgmtRequest.AddCa();
        req.setCaEntry(new MgmtMessage.CaEntryWrapper(caEntry));
        this.voidTransmit(MgmtMessage.MgmtAction.addCa, (MgmtRequest)req);
    }

    public CaEntry getCa(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCa, (MgmtRequest)req);
        MgmtResponse.GetCa resp = (MgmtResponse.GetCa)CaMgmtClient.parse(respBytes, MgmtResponse.GetCa.class);
        try {
            return resp.getResult().toCaEntry();
        }
        catch (CertificateException | InvalidConfException ex) {
            throw new CaMgmtException("could not convert CaEntryWrapper to CaEntry", ex);
        }
    }

    public void changeCa(ChangeCaEntry changeCaEntry) throws CaMgmtException {
        MgmtRequest.ChangeCa req = new MgmtRequest.ChangeCa();
        req.setChangeCaEntry(changeCaEntry);
        this.voidTransmit(MgmtMessage.MgmtAction.changeCa, (MgmtRequest)req);
    }

    public void removeCertprofileFromCa(String profileName, String caName) throws CaMgmtException {
        MgmtRequest.RemoveEntityFromCa req = new MgmtRequest.RemoveEntityFromCa();
        req.setEntityName(profileName);
        req.setCaName(caName);
        this.voidTransmit(MgmtMessage.MgmtAction.removeCertprofileFromCa, (MgmtRequest)req);
    }

    public void addCertprofileToCa(String profileName, String caName) throws CaMgmtException {
        MgmtRequest.AddCertprofileToCa req = new MgmtRequest.AddCertprofileToCa();
        req.setProfileName(profileName);
        req.setCaName(caName);
        this.voidTransmit(MgmtMessage.MgmtAction.addCertprofileToCa, (MgmtRequest)req);
    }

    public void removePublisherFromCa(String publisherName, String caName) throws CaMgmtException {
        MgmtRequest.RemoveEntityFromCa req = new MgmtRequest.RemoveEntityFromCa();
        req.setCaName(caName);
        req.setEntityName(publisherName);
        this.voidTransmit(MgmtMessage.MgmtAction.removePublisherFromCa, (MgmtRequest)req);
    }

    public void addPublisherToCa(String publisherName, String caName) throws CaMgmtException {
        MgmtRequest.AddPublisherToCa req = new MgmtRequest.AddPublisherToCa();
        req.setPublisherName(publisherName);
        req.setCaName(caName);
        this.voidTransmit(MgmtMessage.MgmtAction.addPublisherToCa, (MgmtRequest)req);
    }

    public Set<String> getCertprofilesForCa(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCertprofilesForCa, (MgmtRequest)req);
        MgmtResponse.StringSet resp = (MgmtResponse.StringSet)CaMgmtClient.parse(respBytes, MgmtResponse.StringSet.class);
        return resp.getResult();
    }

    public Set<CaHasRequestorEntry> getRequestorsForCa(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getRequestorsForCa, (MgmtRequest)req);
        MgmtResponse.GetRequestorsForCa resp = (MgmtResponse.GetRequestorsForCa)CaMgmtClient.parse(respBytes, MgmtResponse.GetRequestorsForCa.class);
        return resp.getResult();
    }

    public RequestorEntry getRequestor(String name) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(name);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getRequestor, (MgmtRequest)req);
        MgmtResponse.GetRequestor resp = (MgmtResponse.GetRequestor)CaMgmtClient.parse(respBytes, MgmtResponse.GetRequestor.class);
        return resp.getResult();
    }

    public void addRequestor(RequestorEntry requestorEntry) throws CaMgmtException {
        MgmtRequest.AddRequestor req = new MgmtRequest.AddRequestor();
        req.setRequestorEntry(requestorEntry);
        this.voidTransmit(MgmtMessage.MgmtAction.addRequestor, (MgmtRequest)req);
    }

    public void removeRequestor(String requestorName) throws CaMgmtException {
        this.removeEntity(MgmtMessage.MgmtAction.removeRequestor, requestorName);
    }

    public void changeRequestor(String name, String type, String conf) throws CaMgmtException {
        MgmtRequest.ChangeTypeConfEntity req = new MgmtRequest.ChangeTypeConfEntity(name, type, conf);
        this.voidTransmit(MgmtMessage.MgmtAction.changeRequestor, (MgmtRequest)req);
    }

    public void removeRequestorFromCa(String requestorName, String caName) throws CaMgmtException {
        MgmtRequest.RemoveEntityFromCa req = new MgmtRequest.RemoveEntityFromCa();
        req.setCaName(caName);
        req.setEntityName(requestorName);
        this.voidTransmit(MgmtMessage.MgmtAction.removeRequestorFromCa, (MgmtRequest)req);
    }

    public void addRequestorToCa(CaHasRequestorEntry requestor, String caName) throws CaMgmtException {
        MgmtRequest.AddRequestorToCa req = new MgmtRequest.AddRequestorToCa();
        req.setRequestor(requestor);
        req.setCaName(caName);
        this.voidTransmit(MgmtMessage.MgmtAction.addRequestorToCa, (MgmtRequest)req);
    }

    public void removeUserFromCa(String userName, String caName) throws CaMgmtException {
        MgmtRequest.RemoveEntityFromCa req = new MgmtRequest.RemoveEntityFromCa();
        req.setEntityName(userName);
        req.setCaName(caName);
        this.voidTransmit(MgmtMessage.MgmtAction.removeUserFromCa, (MgmtRequest)req);
    }

    public void addUserToCa(CaHasUserEntry user, String caName) throws CaMgmtException {
        MgmtRequest.AddUserToCa req = new MgmtRequest.AddUserToCa();
        req.setCaName(caName);
        req.setUser(user);
        this.voidTransmit(MgmtMessage.MgmtAction.addUserToCa, (MgmtRequest)req);
    }

    public Map<String, CaHasUserEntry> getCaHasUsersForUser(String user) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(user);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCaHasUsersForUser, (MgmtRequest)req);
        MgmtResponse.GetCaHasUsersForUser resp = (MgmtResponse.GetCaHasUsersForUser)CaMgmtClient.parse(respBytes, MgmtResponse.GetCaHasUsersForUser.class);
        return resp.getResult();
    }

    public CertprofileEntry getCertprofile(String profileName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(profileName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCertprofile, (MgmtRequest)req);
        MgmtResponse.GetCertprofile resp = (MgmtResponse.GetCertprofile)CaMgmtClient.parse(respBytes, MgmtResponse.GetCertprofile.class);
        return resp.getResult();
    }

    public void removeCertprofile(String profileName) throws CaMgmtException {
        this.removeEntity(MgmtMessage.MgmtAction.removeCertprofile, profileName);
    }

    public void changeCertprofile(String name, String type, String conf) throws CaMgmtException {
        MgmtRequest.ChangeTypeConfEntity req = new MgmtRequest.ChangeTypeConfEntity(name, type, conf);
        this.voidTransmit(MgmtMessage.MgmtAction.changeCertprofile, (MgmtRequest)req);
    }

    public void addCertprofile(CertprofileEntry certprofileEntry) throws CaMgmtException {
        MgmtRequest.AddCertprofile req = new MgmtRequest.AddCertprofile();
        req.setCertprofileEntry(certprofileEntry);
        this.voidTransmit(MgmtMessage.MgmtAction.addCertprofile, (MgmtRequest)req);
    }

    public void addSigner(SignerEntry signerEntry) throws CaMgmtException {
        MgmtRequest.AddSigner req = new MgmtRequest.AddSigner();
        req.setSignerEntry(new MgmtMessage.SignerEntryWrapper(signerEntry));
        this.voidTransmit(MgmtMessage.MgmtAction.addSigner, (MgmtRequest)req);
    }

    public void removeSigner(String name) throws CaMgmtException {
        this.removeEntity(MgmtMessage.MgmtAction.removeSigner, name);
    }

    public SignerEntry getSigner(String name) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(name);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getSigner, (MgmtRequest)req);
        MgmtResponse.GetSigner resp = (MgmtResponse.GetSigner)CaMgmtClient.parse(respBytes, MgmtResponse.GetSigner.class);
        return resp.getResult().toSignerEntry();
    }

    public void changeSigner(String name, String type, String conf, String base64Cert) throws CaMgmtException {
        MgmtRequest.ChangeSigner req = new MgmtRequest.ChangeSigner();
        req.setName(name);
        req.setType(type);
        req.setConf(conf);
        req.setBase64Cert(base64Cert);
        this.voidTransmit(MgmtMessage.MgmtAction.changeSigner, (MgmtRequest)req);
    }

    public void addPublisher(PublisherEntry entry) throws CaMgmtException {
        MgmtRequest.AddPublisher req = new MgmtRequest.AddPublisher();
        req.setPublisherEntry(entry);
        this.voidTransmit(MgmtMessage.MgmtAction.addPublisher, (MgmtRequest)req);
    }

    public List<PublisherEntry> getPublishersForCa(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getPublishersForCa, (MgmtRequest)req);
        MgmtResponse.GetPublischersForCa resp = (MgmtResponse.GetPublischersForCa)CaMgmtClient.parse(respBytes, MgmtResponse.GetPublischersForCa.class);
        return resp.getResult();
    }

    public PublisherEntry getPublisher(String publisherName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(publisherName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getPublisher, (MgmtRequest)req);
        MgmtResponse.GetPublisher resp = (MgmtResponse.GetPublisher)CaMgmtClient.parse(respBytes, MgmtResponse.GetPublisher.class);
        return resp.getResult();
    }

    public void removePublisher(String publisherName) throws CaMgmtException {
        this.removeEntity(MgmtMessage.MgmtAction.removePublisher, publisherName);
    }

    public void changePublisher(String name, String type, String conf) throws CaMgmtException {
        MgmtRequest.ChangeTypeConfEntity req = new MgmtRequest.ChangeTypeConfEntity(name, type, conf);
        this.voidTransmit(MgmtMessage.MgmtAction.changePublisher, (MgmtRequest)req);
    }

    public void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        MgmtRequest.RevokeCa req = new MgmtRequest.RevokeCa();
        req.setCaName(caName);
        req.setRevocationInfo(revocationInfo);
        this.voidTransmit(MgmtMessage.MgmtAction.revokeCa, (MgmtRequest)req);
    }

    public void unrevokeCa(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        this.voidTransmit(MgmtMessage.MgmtAction.unrevokeCa, (MgmtRequest)req);
    }

    public void revokeCertificate(String caName, BigInteger serialNumber, CrlReason reason, Date invalidityTime) throws CaMgmtException {
        MgmtRequest.RevokeCertificate req = new MgmtRequest.RevokeCertificate();
        req.setCaName(caName);
        req.setSerialNumber(serialNumber);
        req.setReason(reason);
        req.setInvalidityTime(invalidityTime);
        this.voidTransmit(MgmtMessage.MgmtAction.revokeCertficate, (MgmtRequest)req);
    }

    public void unrevokeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        MgmtRequest.UnrevokeCertificate req = new MgmtRequest.UnrevokeCertificate();
        req.setCaName(caName);
        req.setSerialNumber(serialNumber);
        this.voidTransmit(MgmtMessage.MgmtAction.unrevokeCertificate, (MgmtRequest)req);
    }

    public void removeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        MgmtRequest.RemoveCertificate req = new MgmtRequest.RemoveCertificate();
        req.setCaName(caName);
        req.setSerialNumber(serialNumber);
        this.voidTransmit(MgmtMessage.MgmtAction.removeCertificate, (MgmtRequest)req);
    }

    public X509Cert generateCertificate(String caName, String profileName, byte[] encodedCsr, Date notBefore, Date notAfter) throws CaMgmtException {
        MgmtRequest.GenerateCertificate req = new MgmtRequest.GenerateCertificate();
        req.setCaName(caName);
        req.setProfileName(profileName);
        req.setEncodedCsr(encodedCsr);
        req.setNotBefore(notBefore);
        req.setNotAfter(notAfter);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.generateCertificate, (MgmtRequest)req);
        MgmtResponse.ByteArray resp = (MgmtResponse.ByteArray)CaMgmtClient.parse(respBytes, MgmtResponse.ByteArray.class);
        return this.parseCert(resp.getResult());
    }

    public X509Cert generateRootCa(CaEntry caEntry, String certprofileName, String subject, String serialNumber) throws CaMgmtException {
        MgmtRequest.GenerateRootCa req = new MgmtRequest.GenerateRootCa();
        req.setCaEntry(new MgmtMessage.CaEntryWrapper(caEntry));
        req.setCertprofileName(certprofileName);
        req.setSubject(subject);
        req.setSerialNumber(serialNumber);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.generateRootCa, (MgmtRequest)req);
        MgmtResponse.ByteArray resp = (MgmtResponse.ByteArray)CaMgmtClient.parse(respBytes, MgmtResponse.ByteArray.class);
        return this.parseCert(resp.getResult());
    }

    public void addUser(AddUserEntry addUserEntry) throws CaMgmtException {
        MgmtRequest.AddUser req = new MgmtRequest.AddUser();
        req.setAddUserEntry(addUserEntry);
        this.voidTransmit(MgmtMessage.MgmtAction.addUser, (MgmtRequest)req);
    }

    public void changeUser(ChangeUserEntry changeUserEntry) throws CaMgmtException {
        MgmtRequest.ChangeUser req = new MgmtRequest.ChangeUser();
        req.setChangeUserEntry(changeUserEntry);
        this.voidTransmit(MgmtMessage.MgmtAction.changeUser, (MgmtRequest)req);
    }

    public void removeUser(String username) throws CaMgmtException {
        this.removeEntity(MgmtMessage.MgmtAction.removeUser, username);
    }

    public UserEntry getUser(String username) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(username);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getUser, (MgmtRequest)req);
        MgmtResponse.GetUser resp = (MgmtResponse.GetUser)CaMgmtClient.parse(respBytes, MgmtResponse.GetUser.class);
        return resp.getResult();
    }

    public X509CRLHolder generateCrlOnDemand(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.generateCrlOnDemand, (MgmtRequest)req);
        return this.parseCrl(respBytes);
    }

    public X509CRLHolder getCrl(String caName, BigInteger crlNumber) throws CaMgmtException {
        MgmtRequest.GetCrl req = new MgmtRequest.GetCrl();
        req.setCaName(caName);
        req.setCrlNumber(crlNumber);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCrl, (MgmtRequest)req);
        return this.parseCrl(respBytes);
    }

    public X509CRLHolder getCurrentCrl(String caName) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(caName);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCurrentCrl, (MgmtRequest)req);
        return this.parseCrl(respBytes);
    }

    public CertWithRevocationInfo getCert(String caName, BigInteger serialNumber) throws CaMgmtException {
        MgmtRequest.GetCert req = new MgmtRequest.GetCert();
        req.setCaName(caName);
        req.setSerialNumber(serialNumber);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCert, (MgmtRequest)req);
        MgmtResponse.GetCert resp = (MgmtResponse.GetCert)CaMgmtClient.parse(respBytes, MgmtResponse.GetCert.class);
        try {
            return resp.getResult().toCertWithRevocationInfo();
        }
        catch (CertificateException ex) {
            throw new CaMgmtException("could not parse the certificate", (Throwable)ex);
        }
    }

    public CertWithRevocationInfo getCert(X500Name issuer, BigInteger serialNumber) throws CaMgmtException {
        MgmtRequest.GetCert req = new MgmtRequest.GetCert();
        try {
            req.setEncodedIssuerDn(issuer.getEncoded());
        }
        catch (IOException ex) {
            throw new CaMgmtException("could not encode issuer", (Throwable)ex);
        }
        req.setSerialNumber(serialNumber);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCert, (MgmtRequest)req);
        MgmtResponse.GetCert resp = (MgmtResponse.GetCert)CaMgmtClient.parse(respBytes, MgmtResponse.GetCert.class);
        try {
            return resp.getResult().toCertWithRevocationInfo();
        }
        catch (CertificateException ex) {
            throw new CaMgmtException("could not parse the certificate", (Throwable)ex);
        }
    }

    public Map<String, X509Cert> loadConf(InputStream zippedConfStream) throws CaMgmtException, IOException {
        MgmtRequest.LoadConf req = new MgmtRequest.LoadConf();
        req.setConfBytes(IoUtil.read((InputStream)zippedConfStream));
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.loadConf, (MgmtRequest)req);
        MgmtResponse.LoadConf resp = (MgmtResponse.LoadConf)CaMgmtClient.parse(respBytes, MgmtResponse.LoadConf.class);
        Map nameCertMap = resp.getResult();
        if (nameCertMap == null) {
            return null;
        }
        HashMap<String, X509Cert> result = new HashMap<String, X509Cert>(nameCertMap.size());
        for (Map.Entry entry : nameCertMap.entrySet()) {
            result.put((String)entry.getKey(), this.parseCert((byte[])entry.getValue()));
        }
        return result;
    }

    public InputStream exportConf(List<String> caNames) throws CaMgmtException {
        MgmtRequest.ExportConf req = new MgmtRequest.ExportConf();
        req.setCaNames(caNames);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.exportConf, (MgmtRequest)req);
        MgmtResponse.ByteArray resp = (MgmtResponse.ByteArray)CaMgmtClient.parse(respBytes, MgmtResponse.ByteArray.class);
        return new ByteArrayInputStream(resp.getResult());
    }

    public List<CertListInfo> listCertificates(String caName, X500Name subjectPattern, Date validFrom, Date validTo, CertListOrderBy orderBy, int numEntries) throws CaMgmtException {
        MgmtRequest.ListCertificates req = new MgmtRequest.ListCertificates();
        req.setCaName(caName);
        if (subjectPattern != null) {
            try {
                req.setEncodedSubjectDnPattern(subjectPattern.getEncoded());
            }
            catch (IOException ex) {
                throw new CaMgmtException("could not parse subjectPattern", (Throwable)ex);
            }
        }
        req.setValidFrom(validFrom);
        req.setValidTo(validTo);
        req.setOrderBy(orderBy);
        req.setNumEntries(numEntries);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.listCertificates, (MgmtRequest)req);
        MgmtResponse.ListCertificates resp = (MgmtResponse.ListCertificates)CaMgmtClient.parse(respBytes, MgmtResponse.ListCertificates.class);
        return resp.getResult();
    }

    public byte[] getCertRequest(String caName, BigInteger serialNumber) throws CaMgmtException {
        MgmtRequest.GetCertRequest req = new MgmtRequest.GetCertRequest();
        req.setCaName(caName);
        req.setSerialNumber(serialNumber);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getCertRequest, (MgmtRequest)req);
        MgmtResponse.ByteArray resp = (MgmtResponse.ByteArray)CaMgmtClient.parse(respBytes, MgmtResponse.ByteArray.class);
        return resp.getResult();
    }

    public Set<String> getSupportedSignerTypes() throws CaMgmtException {
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getSupportedSignerTypes, null);
        MgmtResponse.StringSet resp = (MgmtResponse.StringSet)CaMgmtClient.parse(respBytes, MgmtResponse.StringSet.class);
        return resp.getResult();
    }

    public Set<String> getSupportedCertprofileTypes() throws CaMgmtException {
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getSupportedCertprofileTypes, null);
        MgmtResponse.StringSet resp = (MgmtResponse.StringSet)CaMgmtClient.parse(respBytes, MgmtResponse.StringSet.class);
        return resp.getResult();
    }

    public Set<String> getSupportedPublisherTypes() throws CaMgmtException {
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.getSupportedPublisherTypes, null);
        MgmtResponse.StringSet resp = (MgmtResponse.StringSet)CaMgmtClient.parse(respBytes, MgmtResponse.StringSet.class);
        return resp.getResult();
    }

    public String getTokenInfoP11(String module, Integer slotIndex, boolean verbose) throws CaMgmtException {
        MgmtRequest.TokenInfoP11 req = new MgmtRequest.TokenInfoP11(module, slotIndex, verbose);
        byte[] respBytes = this.transmit(MgmtMessage.MgmtAction.tokenInfoP11, (MgmtRequest)req);
        MgmtResponse.StringResponse resp = (MgmtResponse.StringResponse)CaMgmtClient.parse(respBytes, MgmtResponse.StringResponse.class);
        return resp.getResult();
    }

    public void refreshTokenForSignerType(String signerType) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(signerType);
        this.voidTransmit(MgmtMessage.MgmtAction.refreshTokenForSignerType, (MgmtRequest)req);
    }

    private X509Cert parseCert(byte[] certBytes) throws CaMgmtException {
        try {
            return X509Util.parseCert((byte[])certBytes);
        }
        catch (CertificateException ex) {
            throw new CaMgmtException("could not parse X.509 certificate", (Throwable)ex);
        }
    }

    private X509CRLHolder parseCrl(byte[] respBytes) throws CaMgmtException {
        MgmtResponse.ByteArray resp = (MgmtResponse.ByteArray)CaMgmtClient.parse(respBytes, MgmtResponse.ByteArray.class);
        try {
            return X509Util.parseCrl((byte[])resp.getResult());
        }
        catch (CRLException ex) {
            throw new CaMgmtException("could not parse X.509 CRL", (Throwable)ex);
        }
    }

    private void removeEntity(MgmtMessage.MgmtAction action, String name) throws CaMgmtException {
        MgmtRequest.Name req = new MgmtRequest.Name(name);
        this.voidTransmit(action, (MgmtRequest)req);
    }

    private void voidTransmit(MgmtMessage.MgmtAction action, MgmtRequest req) throws CaMgmtException {
        this.transmit(action, req, true);
    }

    private byte[] transmit(MgmtMessage.MgmtAction action, MgmtRequest req) throws CaMgmtException {
        return this.transmit(action, req, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] transmit(MgmtMessage.MgmtAction action, MgmtRequest req, boolean voidReturn) throws CaMgmtException {
        this.initIfNotDone();
        byte[] reqBytes = req == null ? null : JSON.toJSONBytes((Object)req, (SerializerFeature[])new SerializerFeature[0]);
        int size = reqBytes == null ? 0 : reqBytes.length;
        URL url = this.actionUrlMap.get(action);
        try {
            HttpURLConnection httpUrlConnection = IoUtil.openHttpConn((URL)url);
            if (httpUrlConnection instanceof HttpsURLConnection) {
                if (this.sslSocketFactory != null) {
                    ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(this.sslSocketFactory);
                }
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)httpUrlConnection).setHostnameVerifier(this.hostnameVerifier);
                }
            }
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setRequestProperty("Content-Type", "application/json");
            httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(size));
            OutputStream outputstream = httpUrlConnection.getOutputStream();
            if (size != 0) {
                outputstream.write(reqBytes);
            }
            outputstream.flush();
            if (httpUrlConnection.getResponseCode() == 200) {
                byte[] byArray;
                block16: {
                    boolean inClosed;
                    InputStream in;
                    block14: {
                        byte[] byArray2;
                        block15: {
                            in = httpUrlConnection.getInputStream();
                            inClosed = false;
                            try {
                                String responseContentType = httpUrlConnection.getContentType();
                                if (!"application/json".equals(responseContentType)) {
                                    throw new CaMgmtException("bad response: mime type " + responseContentType + " not supported!");
                                }
                                if (!voidReturn) break block14;
                                byArray2 = null;
                                if (!(in != null & !inClosed)) break block15;
                            }
                            catch (Throwable throwable) {
                                if (in != null & !inClosed) {
                                    in.close();
                                }
                                throw throwable;
                            }
                            in.close();
                        }
                        return byArray2;
                    }
                    inClosed = true;
                    byArray = IoUtil.read((InputStream)httpUrlConnection.getInputStream());
                    if (!(in != null & !inClosed)) break block16;
                    in.close();
                }
                return byArray;
            }
            String errorMessage = httpUrlConnection.getHeaderField("x-xipki-error");
            if (errorMessage != null) {
                throw new CaMgmtException(errorMessage);
            }
            StringBuilder sb = new StringBuilder(100);
            sb.append("server returns ").append(httpUrlConnection.getResponseCode());
            String respMsg = httpUrlConnection.getResponseMessage();
            if (StringUtil.isNotBlank((String)respMsg)) {
                sb.append(" ").append(respMsg);
            }
            throw new CaMgmtException(sb.toString());
        }
        catch (IOException ex) {
            throw new CaMgmtException("IOException while sending message to the server: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static <T extends MgmtResponse> T parse(byte[] bytes, Class<?> clazz) throws CaMgmtException {
        try {
            return (T)((MgmtResponse)JSON.parseObject((byte[])bytes, clazz, (Feature[])new Feature[0]));
        }
        catch (RuntimeException ex) {
            throw new CaMgmtException("cannot parse response " + clazz + " from byte[]", (Throwable)ex);
        }
    }
}

