/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.util.StringUtil;

abstract class AbstractOcspCertstoreDbImporter
extends DbPorter {
    protected static final String MSG_CERTS_FINISHED = "certs.finished";
    protected static final String SQL_ADD_CRLINFO = "INSERT INTO CRL_INFO (ID,NAME,INFO) VALUES (?,?,?)";
    protected static final String SQL_ADD_ISSUER = "INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,REV_INFO,CERT,CRL_ID) VALUES (?,?,?,?,?,?,?,?)";
    protected static final String SQL_ADD_CERT = "INSERT INTO CERT (ID,IID,SN,LUPDATE,NBEFORE,NAFTER,REV,RR,RT,RIT,HASH,SUBJECT,CRL_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    protected static final String SQL_DEL_CERT = "DELETE FROM CERT WHERE ID>?";

    AbstractOcspCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
    }

    protected String sha1(byte[] data) {
        return HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{data});
    }

    protected String sha256(byte[] data) {
        return HashAlgo.SHA256.base64Hash((byte[][])new byte[][]{data});
    }

    protected String sha3_256(byte[] data) {
        return HashAlgo.SHA3_256.base64Hash((byte[][])new byte[][]{data});
    }

    protected void deleteCertGreatherThan(long id, Logger log) {
        this.deleteFromTableWithLargerId("CERT", "ID", id, log);
    }

    protected void dropIndexes() throws DataAccessException {
        System.out.println("dropping indexes");
        long start = System.currentTimeMillis();
        this.datasource.dropForeignKeyConstraint(null, "FK_CERT_ISSUER1", "CERT");
        this.datasource.dropUniqueConstrain(null, "CONST_ISSUER_SN", "CERT");
        this.datasource.dropPrimaryKey(null, "PK_CERT", "CERT");
        long duration = (System.currentTimeMillis() - start) / 1000L;
        System.out.println(" dropped indexes in " + StringUtil.formatTime((long)duration, (boolean)false));
    }

    protected void recoverIndexes() throws DataAccessException {
        System.out.println("recovering indexes");
        long start = System.currentTimeMillis();
        this.datasource.addPrimaryKey(null, "PK_CERT", "CERT", new String[]{"ID"});
        this.datasource.addForeignKeyConstraint(null, "FK_CERT_ISSUER1", "CERT", "IID", "ISSUER", "ID", "CASCADE", "NO ACTION");
        this.datasource.addUniqueConstrain(null, "CONST_ISSUER_SN", "CERT", new String[]{"IID", "SN"});
        long duration = (System.currentTimeMillis() - start) / 1000L;
        System.out.println(" recovered indexes in " + StringUtil.formatTime((long)duration, (boolean)false));
    }
}

