/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.AbstractOcspCertstoreDbImporter;
import org.xipki.ca.mgmt.db.port.OcspCertstore;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Args;
import org.xipki.util.ProcessLog;

class OcspCertstoreDbImporter
extends AbstractOcspCertstoreDbImporter {
    private static final Logger LOG = LoggerFactory.getLogger(OcspCertstoreDbImporter.class);
    private final boolean resume;
    private final int numCertsPerCommit;

    OcspCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, int numCertsPerCommit, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
        this.numCertsPerCommit = Args.positive((int)numCertsPerCommit, (String)"numCertsPerCommit");
        File processLogFile = new File(this.baseDir, "import.process");
        if (resume) {
            if (!processLogFile.exists()) {
                throw new Exception("could not process with '--resume' option");
            }
        } else if (processLogFile.exists()) {
            throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
        }
        this.resume = resume;
    }

    public void importToDb() throws Exception {
        OcspCertstore certstore;
        try (InputStream is = Files.newInputStream(Paths.get(this.baseDir, "ocsp-certstore.json"), new OpenOption[0]);){
            certstore = (OcspCertstore)((Object)JSON.parseObject((InputStream)is, OcspCertstore.class, (Feature[])new Feature[0]));
        }
        certstore.validate();
        if (certstore.getVersion() > 1) {
            throw new Exception("could not import Certstore greater than 1: " + certstore.getVersion());
        }
        File processLogFile = new File(this.baseDir, "import.process");
        System.out.println("importing OCSP certstore to database");
        try {
            if (!this.resume) {
                this.importCertHashAlgo(certstore.getCerthashAlgo());
                this.importCrlInfo(certstore.getCrlInfos());
                this.importIssuer(certstore.getIssuers());
            }
            this.importCert(certstore, processLogFile);
            processLogFile.delete();
        }
        catch (Exception ex) {
            System.err.println("could not import OCSP certstore to database");
            throw ex;
        }
        System.out.println(" imported OCSP certstore to database");
    }

    private void importCertHashAlgo(String certHashAlgo) throws DataAccessException {
        String sql = "UPDATE DBSCHEMA SET VALUE2=? WHERE NAME='CERTHASH_ALGO'";
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            ps.setString(1, certHashAlgo);
            ps.executeUpdate();
            this.dbSchemaInfo.setVariable("CERTHASH_ALGO", certHashAlgo);
        }
        catch (SQLException ex) {
            System.err.println("could not import DBSCHEMA");
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(ps, null);
        }
    }

    /*
     * Exception decompiling
     */
    private void importIssuer(List<OcspCertstore.Issuer> issuers) throws DataAccessException, CertificateException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void importCrlInfo(List<OcspCertstore.CrlInfo> crlInfos) throws DataAccessException, CertificateException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void importCert(OcspCertstore certstore, File processLogFile) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importCert0(PreparedStatement psCert, String certsZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess) throws Exception {
        OcspCertstore.Certs certs;
        ZipFile zipFile = new ZipFile(new File(certsZipFile));
        ZipEntry certsEntry = zipFile.getEntry("certs.json");
        try {
            certs = (OcspCertstore.Certs)((Object)JSON.parseObject((InputStream)zipFile.getInputStream(certsEntry), (Charset)Charset.forName("UTF-8"), OcspCertstore.Certs.class, (Feature[])new Feature[0]));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)certsZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + certsZipFile, (Throwable)e2);
            }
            throw ex;
        }
        certs.validate();
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulCertId = 0L;
            List<OcspCertstore.Cert> list = certs.getCerts();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                OcspCertstore.Cert cert = list.get(i);
                long id = cert.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                try {
                    int idx = 1;
                    psCert.setLong(idx++, id);
                    psCert.setInt(idx++, cert.getIid());
                    psCert.setString(idx++, cert.getSn());
                    psCert.setLong(idx++, cert.getUpdate());
                    psCert.setLong(idx++, cert.getNbefore());
                    psCert.setLong(idx++, cert.getNafter());
                    OcspCertstoreDbImporter.setBoolean(psCert, idx++, cert.getRev());
                    OcspCertstoreDbImporter.setInt(psCert, idx++, cert.getRr());
                    OcspCertstoreDbImporter.setLong(psCert, idx++, cert.getRt());
                    OcspCertstoreDbImporter.setLong(psCert, idx++, cert.getRit());
                    psCert.setString(idx++, cert.getHash());
                    psCert.setString(idx++, cert.getSubject());
                    if (cert.getCrlId() == null) {
                        psCert.setNull(idx++, 4);
                    } else {
                        psCert.setInt(idx++, cert.getCrlId());
                    }
                    psCert.addBatch();
                }
                catch (SQLException ex) {
                    throw this.translate("INSERT INTO CERT (ID,IID,SN,LUPDATE,NBEFORE,NAFTER,REV,RR,RT,RIT,HASH,SUBJECT,CRL_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)", ex);
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numEntriesInBatch <= 0 || numEntriesInBatch % this.numCertsPerCommit != 0 && !isLastBlock) continue;
                try {
                    psCert.executeBatch();
                    this.commit("(commit import cert to OCSP)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteCertGreatherThan(lastSuccessfulCertId, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate("INSERT INTO CERT (ID,IID,SN,LUPDATE,NBEFORE,NAFTER,REV,RR,RT,RIT,HASH,SUBJECT,CRL_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)", (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulCertId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                OcspCertstoreDbImporter.echoToFile((long)numProcessedInLastProcess + processLog.numProcessed() + ":" + lastSuccessfulCertId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulCertId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }
}

