/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class DbToolBase
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DbToolBase.class);
    private static final int STREAM_BUFFER_SIZE = 0x100000;
    protected final AtomicBoolean stopMe;
    protected final DataSourceWrapper datasource;
    protected final String baseDir;
    protected Connection connection;
    private boolean connectionAutoCommit;

    public DbToolBase(DataSourceWrapper datasource, String baseDir, AtomicBoolean stopMe) throws DataAccessException {
        Args.notBlank((String)baseDir, (String)"baseDir");
        this.stopMe = (AtomicBoolean)Args.notNull((Object)stopMe, (String)"stopMe");
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.connection = datasource.getConnection();
        try {
            this.connectionAutoCommit = this.connection.getAutoCommit();
        }
        catch (SQLException ex) {
            throw datasource.translate(null, ex);
        }
        this.baseDir = IoUtil.expandFilepath((String)baseDir);
    }

    protected Statement createStatement() throws DataAccessException {
        try {
            return this.connection.createStatement();
        }
        catch (SQLException ex) {
            throw this.datasource.translate(null, ex);
        }
    }

    protected PreparedStatement prepareStatement(String sql) throws DataAccessException {
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFromTableWithLargerId(String table, String idColumn, long id, Logger log) {
        Statement stmt;
        String sql = StringUtil.concatObjects((Object)"DELETE FROM ", (Object[])new Object[]{table, " WHERE ", idColumn, ">", id});
        try {
            stmt = this.createStatement();
        }
        catch (DataAccessException ex) {
            log.error("could not create statement", (Throwable)ex);
            return false;
        }
        try {
            stmt.execute(sql);
        }
        catch (Throwable th) {
            String msg = String.format("could not delete columns from table %s with %s > %s", table, idColumn, id);
            LogUtil.error((Logger)log, (Throwable)th, (String)msg);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseResources(stmt, null);
        }
        return true;
    }

    @Override
    public void close() {
        this.datasource.returnConnection(this.connection);
        this.connection = null;
    }

    public long min(String table, String column) throws DataAccessException {
        return this.datasource.getMin(this.connection, table, column);
    }

    public long min(String table, String column, String condition) throws DataAccessException {
        return this.datasource.getMin(this.connection, table, column, condition);
    }

    public long max(String table, String column) throws DataAccessException {
        return this.datasource.getMax(this.connection, table, column);
    }

    public long max(String table, String column, String condition) throws DataAccessException {
        return this.datasource.getMax(this.connection, table, column, condition);
    }

    public int count(String table) throws DataAccessException {
        return this.datasource.getCount(this.connection, table);
    }

    public boolean tableHasColumn(String table, String column) throws DataAccessException {
        return this.datasource.tableHasColumn(this.connection, table, column);
    }

    public boolean tableExists(String table) throws DataAccessException {
        return this.datasource.tableExists(this.connection, table);
    }

    protected Savepoint setSavepoint() throws DataAccessException {
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException ex) {
            throw this.datasource.translate(null, ex);
        }
    }

    protected void rollback() throws DataAccessException {
        try {
            this.connection.rollback();
        }
        catch (SQLException ex) {
            throw this.datasource.translate(null, ex);
        }
    }

    protected DataAccessException translate(String sql, SQLException ex) {
        return this.datasource.translate(sql, (SQLException)Args.notNull((Object)ex, (String)"ex"));
    }

    protected void disableAutoCommit() throws DataAccessException {
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw this.datasource.translate(null, ex);
        }
    }

    protected void recoverAutoCommit() {
        try {
            this.connection.setAutoCommit(this.connectionAutoCommit);
        }
        catch (SQLException ex) {
            DataAccessException dex = this.datasource.translate(null, ex);
            LogUtil.error((Logger)LOG, (Throwable)dex, (String)"could not recover AutoCommit");
        }
    }

    protected void commit(String task) throws DataAccessException {
        Args.notBlank((String)task, (String)"task");
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            throw this.datasource.translate(task, ex);
        }
    }

    protected static void setLong(PreparedStatement ps, int index, Long value) throws SQLException {
        if (value != null) {
            ps.setLong(index, value);
        } else {
            ps.setNull(index, -5);
        }
    }

    protected static void setInt(PreparedStatement ps, int index, Integer value) throws SQLException {
        if (value != null) {
            ps.setInt(index, value);
        } else {
            ps.setNull(index, 4);
        }
    }

    protected static void setBoolean(PreparedStatement ps, int index, boolean value) throws SQLException {
        ps.setInt(index, value ? 1 : 0);
    }

    public static Properties getDbConfProperties(InputStream is) throws IOException {
        Properties props = new Properties();
        try {
            props.load(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                LOG.warn("could not close stream: {}", (Object)ex.getMessage());
            }
        }
        if (props.getProperty("minimumIdle") != null) {
            props.setProperty("minimumIdle", "1");
        }
        return props;
    }

    public static void deleteTmpFiles(String dirName, String prefix) {
        Args.notBlank((String)dirName, (String)"dirName");
        Args.notBlank((String)prefix, (String)"prefix");
        File dir = new File(dirName);
        File[] children = dir.listFiles();
        if (children != null && children.length > 0) {
            for (File child : children) {
                if (!child.getName().startsWith(prefix)) continue;
                child.delete();
            }
        }
    }

    protected static void writeLine(OutputStream os, String text) throws IOException {
        os.write(StringUtil.toUtf8Bytes((String)text));
        os.write(10);
    }

    public static String buildFilename(String prefix, String suffix, long minIdOfCurrentFile, long maxIdOfCurrentFile, long maxId) {
        Args.notNull((Object)prefix, (String)"prefix");
        Args.notNull((Object)suffix, (String)"suffix");
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        int len = Long.toString(maxId).length();
        String minIdStr = Long.toString(minIdOfCurrentFile);
        for (int i = 0; i < len - minIdStr.length(); ++i) {
            sb.append('0');
        }
        sb.append(minIdStr);
        sb.append("-");
        String maxIdStr = Long.toString(maxIdOfCurrentFile);
        for (int i = 0; i < len - maxIdStr.length(); ++i) {
            sb.append('0');
        }
        sb.append(maxIdStr);
        sb.append(suffix);
        return sb.toString();
    }

    public static ZipOutputStream getZipOutputStream(File zipFile) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(zipFile.toPath(), new OpenOption[0]), 0x100000);
        ZipOutputStream zipOutStream = new ZipOutputStream(out);
        zipOutStream.setLevel(1);
        return zipOutStream;
    }

    public void releaseResources(Statement ps, ResultSet rs) {
        this.datasource.releaseResources(ps, rs, false);
    }
}

