/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;

abstract class AbstractOcspCertstoreDbImporter
extends DbPorter {
    protected static final String MSG_CERTS_FINISHED = "certs.finished";
    protected static final String SQL_ADD_CRLINFO = "INSERT INTO CRL_INFO (ID,NAME,INFO) VALUES (?,?,?)";
    protected static final String SQL_ADD_ISSUER = "INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,REV_INFO,CERT,CRL_ID) VALUES (?,?,?,?,?,?,?,?)";
    protected static final String SQL_ADD_CERT = "INSERT INTO CERT (ID,IID,SN,LUPDATE,NBEFORE,NAFTER,REV,RR,RT,RIT,HASH,SUBJECT,CRL_ID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    protected static final String SQL_DEL_CERT = "DELETE FROM CERT WHERE ID>?";

    AbstractOcspCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
    }

    protected String sha1(byte[] data) {
        return HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{data});
    }

    protected String sha256(byte[] data) {
        return HashAlgo.SHA256.base64Hash((byte[][])new byte[][]{data});
    }

    protected String sha3_256(byte[] data) {
        return HashAlgo.SHA3_256.base64Hash((byte[][])new byte[][]{data});
    }

    protected void deleteCertGreatherThan(long id, Logger log) {
        this.deleteFromTableWithLargerId("CERT", "ID", id, log);
    }
}

