/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.diffdb;

import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.mgmt.db.diffdb.IdentifiedDigestEntry;

interface QueueEntry {
    public static final EndOfQueue END_OF_QUEUE = new EndOfQueue();

    public static class DigestEntrySet
    implements QueueEntry,
    Comparable<DigestEntrySet> {
        private final long startId;
        private Exception exception;
        private List<IdentifiedDigestEntry> entries = new LinkedList<IdentifiedDigestEntry>();

        public DigestEntrySet(long startId) {
            this.startId = startId;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public void addEntry(IdentifiedDigestEntry entry) {
            this.entries.add(entry);
        }

        public long getStartId() {
            return this.startId;
        }

        public List<IdentifiedDigestEntry> getEntries() {
            return this.entries;
        }

        @Override
        public int compareTo(DigestEntrySet obj) {
            if (this.startId < obj.startId) {
                return -1;
            }
            if (this.startId == obj.startId) {
                return 0;
            }
            return 1;
        }
    }

    public static class EndOfQueue
    implements QueueEntry {
        private EndOfQueue() {
        }
    }
}

