/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.mgmt.db.port.IdentifidDbObject;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ValidatableConf;

public class CaCertstore
extends ValidatableConf {
    private int version;
    private int countCrls;
    private int countCerts;
    private int countRequests;
    private int countReqCerts;
    private List<ToPublish> publishQueue;
    private List<DeltaCrlCacheEntry> deltaCrlCache;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCountCrls() {
        return this.countCrls;
    }

    public void setCountCrls(int countCrls) {
        this.countCrls = countCrls;
    }

    public int getCountCerts() {
        return this.countCerts;
    }

    public void setCountCerts(int countCerts) {
        this.countCerts = countCerts;
    }

    public int getCountRequests() {
        return this.countRequests;
    }

    public void setCountRequests(int countRequests) {
        this.countRequests = countRequests;
    }

    public int getCountReqCerts() {
        return this.countReqCerts;
    }

    public void setCountReqCerts(int countReqCerts) {
        this.countReqCerts = countReqCerts;
    }

    public List<ToPublish> getPublishQueue() {
        if (this.publishQueue == null) {
            this.publishQueue = new LinkedList<ToPublish>();
        }
        return this.publishQueue;
    }

    public void setPublishQueue(List<ToPublish> publishQueue) {
        this.publishQueue = publishQueue;
    }

    public List<DeltaCrlCacheEntry> getDeltaCrlCache() {
        if (this.deltaCrlCache == null) {
            this.deltaCrlCache = new LinkedList<DeltaCrlCacheEntry>();
        }
        return this.deltaCrlCache;
    }

    public void setDeltaCrlCache(List<DeltaCrlCacheEntry> deltaCrlCache) {
        this.deltaCrlCache = deltaCrlCache;
    }

    public void validate() throws InvalidConfException {
        CaCertstore.validate(this.publishQueue);
        CaCertstore.validate(this.deltaCrlCache);
    }

    public static class User
    extends ValidatableConf {
        private int id;
        private String name;
        private int active;
        private String password;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getActive() {
            return this.active;
        }

        public void setActive(int active) {
            this.active = active;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void validate() throws InvalidConfException {
            User.notEmpty((String)this.name, (String)"name");
            User.notEmpty((String)this.password, (String)"password");
        }
    }

    public static class ToPublish
    extends ValidatableConf {
        private int pubId;
        private long certId;
        private int caId;

        public int getPubId() {
            return this.pubId;
        }

        public void setPubId(int pubId) {
            this.pubId = pubId;
        }

        public long getCertId() {
            return this.certId;
        }

        public void setCertId(long certId) {
            this.certId = certId;
        }

        public int getCaId() {
            return this.caId;
        }

        public void setCaId(int caId) {
            this.caId = caId;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class Signer
    extends ValidatableConf {
        private String name;
        private String type;
        private FileOrValue conf;
        private FileOrBinary cert;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public void validate() throws InvalidConfException {
            Signer.notEmpty((String)this.name, (String)"name");
            Signer.notEmpty((String)this.type, (String)"type");
            Signer.notNull((Object)this.conf, (String)"conf");
            this.conf.validate();
            Signer.validate((ValidatableConf)this.cert);
        }
    }

    public static class Requests
    extends ValidatableConf {
        private List<Request> requests;

        public List<Request> getRequests() {
            if (this.requests == null) {
                this.requests = new LinkedList<Request>();
            }
            return this.requests;
        }

        public void setRequests(List<Request> requests) {
            this.requests = requests;
        }

        public void add(Request request) {
            if (this.requests == null) {
                this.requests = new LinkedList<Request>();
            }
            this.requests.add(request);
        }

        public void validate() throws InvalidConfException {
            Requests.validate(this.requests);
        }
    }

    public static class Request
    extends IdentifidDbObject {
        private Long update;
        private String file;

        public Long getUpdate() {
            return this.update;
        }

        public void setUpdate(Long update) {
            this.update = update;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Request.notNull((Object)this.update, (String)"update");
            Request.notEmpty((String)this.file, (String)"file");
        }
    }

    public static class ReqCerts
    extends ValidatableConf {
        private List<ReqCert> reqCerts;

        public List<ReqCert> getReqCerts() {
            if (this.reqCerts == null) {
                this.reqCerts = new LinkedList<ReqCert>();
            }
            return this.reqCerts;
        }

        public void setReqCerts(List<ReqCert> reqCerts) {
            this.reqCerts = reqCerts;
        }

        public void add(ReqCert reqCert) {
            if (this.reqCerts == null) {
                this.reqCerts = new LinkedList<ReqCert>();
            }
            this.reqCerts.add(reqCert);
        }

        public void validate() throws InvalidConfException {
            ReqCerts.validate(this.reqCerts);
        }
    }

    public static class ReqCert
    extends IdentifidDbObject {
        private Long rid;
        private Long cid;

        public Long getRid() {
            return this.rid;
        }

        public void setRid(long rid) {
            this.rid = rid;
        }

        public Long getCid() {
            return this.cid;
        }

        public void setCid(long cid) {
            this.cid = cid;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            ReqCert.notNull((Object)this.rid, (String)"rid");
            ReqCert.notNull((Object)this.cid, (String)"cid");
        }
    }

    public static class IdNameTypeConf
    extends ValidatableConf {
        private int id;
        private String name;
        private String type;
        private FileOrValue conf;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue conf) {
            this.conf = conf;
        }

        public void validate() throws InvalidConfException {
            IdNameTypeConf.notEmpty((String)this.name, (String)"name");
            IdNameTypeConf.notEmpty((String)this.type, (String)"type");
            IdNameTypeConf.notNull((Object)this.conf, (String)"conf");
            this.conf.validate();
        }
    }

    public static class DeltaCrlCacheEntry
    extends ValidatableConf {
        private String serial;
        private int caId;

        public String getSerial() {
            return this.serial;
        }

        public void setSerial(String serial) {
            this.serial = serial;
        }

        public int getCaId() {
            return this.caId;
        }

        public void setCaId(int caId) {
            this.caId = caId;
        }

        public void validate() throws InvalidConfException {
            DeltaCrlCacheEntry.notEmpty((String)this.serial, (String)"serial");
        }
    }

    public static class Crls
    extends ValidatableConf {
        private List<Crl> crls;

        public List<Crl> getCrls() {
            return this.crls;
        }

        public void setCrls(List<Crl> crls) {
            this.crls = crls;
        }

        public void add(Crl crl) {
            if (this.crls == null) {
                this.crls = new LinkedList<Crl>();
            }
            this.crls.add(crl);
        }

        public void validate() throws InvalidConfException {
            Crls.validate(this.crls);
        }
    }

    public static class Crl
    extends IdentifidDbObject {
        private Integer caId;
        private String crlNo;
        private String file;
        private Integer crlScope;

        public Integer getCaId() {
            return this.caId;
        }

        public void setCaId(Integer caId) {
            this.caId = caId;
        }

        public String getCrlNo() {
            return this.crlNo;
        }

        public void setCrlNo(String crlNo) {
            this.crlNo = crlNo;
        }

        public Integer getCrlScope() {
            return this.crlScope;
        }

        public void setCrlScope(Integer crlScope) {
            this.crlScope = crlScope;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Crl.notNull((Object)this.caId, (String)"caId");
            Crl.notEmpty((String)this.crlNo, (String)"crlNo");
            Crl.notEmpty((String)this.file, (String)"file");
            Crl.notNull((Object)this.crlScope, (String)"crlScope");
        }
    }

    public static class Certs
    extends ValidatableConf {
        private List<Cert> certs;

        public List<Cert> getCerts() {
            if (this.certs == null) {
                this.certs = new LinkedList<Cert>();
            }
            return this.certs;
        }

        public void setCerts(List<Cert> certs) {
            this.certs = certs;
        }

        public void add(Cert cert) {
            this.getCerts().add(cert);
        }

        public void validate() throws InvalidConfException {
            Certs.validate(this.certs);
        }
    }

    public static class Cert
    extends IdentifidDbObject {
        private String file;
        private Integer caId;
        private String sn;
        private Integer pid;
        private Integer rid;
        private Boolean ee;
        private Long update;
        private Integer rev;
        private Integer rr;
        private Long rt;
        private Long rit;
        private Integer uid;
        private String tid;
        private Integer reqType;
        private Long fpRs;
        private Integer crlScope;
        private String rs;

        public Integer getCaId() {
            return this.caId;
        }

        public void setCaId(Integer caId) {
            this.caId = caId;
        }

        public String getSn() {
            return this.sn;
        }

        public void setSn(String sn) {
            this.sn = sn;
        }

        public Boolean getEe() {
            return this.ee;
        }

        public void setEe(Boolean ee) {
            this.ee = ee;
        }

        public Integer getPid() {
            return this.pid;
        }

        public void setPid(Integer pid) {
            this.pid = pid;
        }

        public Integer getRid() {
            return this.rid;
        }

        public void setRid(Integer rid) {
            this.rid = rid;
        }

        public Long getUpdate() {
            return this.update;
        }

        public void setUpdate(Long update) {
            this.update = update;
        }

        public Integer getRev() {
            return this.rev;
        }

        public void setRev(Integer rev) {
            this.rev = rev;
        }

        public Integer getRr() {
            return this.rr;
        }

        public void setRr(Integer rr) {
            this.rr = rr;
        }

        public Long getRt() {
            return this.rt;
        }

        public void setRt(Long rt) {
            this.rt = rt;
        }

        public Long getRit() {
            return this.rit;
        }

        public void setRit(Long rit) {
            this.rit = rit;
        }

        public String getTid() {
            return this.tid;
        }

        public void setTid(String tid) {
            this.tid = tid;
        }

        public Integer getReqType() {
            return this.reqType;
        }

        public void setReqType(Integer reqType) {
            this.reqType = reqType;
        }

        public Long getFpRs() {
            return this.fpRs;
        }

        public void setFpRs(Long fpRs) {
            this.fpRs = fpRs;
        }

        public String getRs() {
            return this.rs;
        }

        public void setRs(String rs) {
            this.rs = rs;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public Integer getUid() {
            return this.uid;
        }

        public void setUid(Integer uid) {
            this.uid = uid;
        }

        public Integer getCrlScope() {
            return this.crlScope;
        }

        public void setCrlScope(Integer crlScope) {
            this.crlScope = crlScope;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Cert.notNull((Object)this.caId, (String)"caId");
            Cert.notNull((Object)this.ee, (String)"ee");
            Cert.notEmpty((String)this.file, (String)"file");
            Cert.notNull((Object)this.pid, (String)"pid");
            Cert.notNull((Object)this.reqType, (String)"reqType");
            Cert.notNull((Object)this.rev, (String)"rev");
            Cert.notNull((Object)this.rid, (String)"rid");
            Cert.notEmpty((String)this.sn, (String)"sn");
            Cert.notNull((Object)this.update, (String)"update");
            Cert.notNull((Object)this.crlScope, (String)"crlScope");
            if (this.rev != null && this.rev == 1) {
                Cert.notNull((Object)this.rr, (String)"rr");
                Cert.notNull((Object)this.rt, (String)"rt");
            }
        }
    }

    public static class CaHasUser
    extends CaHasEntry {
        private int id;
        private int userId;
        private int active;
        private int permission;
        private String profiles;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getUserId() {
            return this.userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public int getActive() {
            return this.active;
        }

        public void setActive(int active) {
            this.active = active;
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public String getProfiles() {
            return this.profiles;
        }

        public void setProfiles(String profiles) {
            this.profiles = profiles;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class CaHasRequestor
    extends CaHasEntry {
        private int requestorId;
        private int ra;
        private int permission;
        private String profiles;

        public int getRequestorId() {
            return this.requestorId;
        }

        public void setRequestorId(int requestorId) {
            this.requestorId = requestorId;
        }

        public int getRa() {
            return this.ra;
        }

        public void setRa(int ra) {
            this.ra = ra;
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public String getProfiles() {
            return this.profiles;
        }

        public void setProfiles(String profiles) {
            this.profiles = profiles;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class CaHasProfile
    extends CaHasEntry {
        private int profileId;

        public int getProfileId() {
            return this.profileId;
        }

        public void setProfileId(int profileId) {
            this.profileId = profileId;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class CaHasPublisher
    extends CaHasEntry {
        private int publisherId;

        public int getPublisherId() {
            return this.publisherId;
        }

        public void setPublisherId(int publisherId) {
            this.publisherId = publisherId;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static abstract class CaHasEntry
    extends ValidatableConf {
        private int caId;

        public int getCaId() {
            return this.caId;
        }

        public void setCaId(int caId) {
            this.caId = caId;
        }
    }

    public static class Caconf
    extends ValidatableConf {
        private int version;
        private List<Signer> signers;
        private List<IdNameTypeConf> requestors;
        private List<IdNameTypeConf> publishers;
        private List<IdNameTypeConf> profiles;
        private List<Ca> cas;
        private List<Caalias> caaliases;
        private List<User> users;
        private List<CaHasRequestor> caHasRequestors;
        private List<CaHasPublisher> caHasPublishers;
        private List<CaHasProfile> caHasProfiles;
        private List<CaHasUser> caHasUsers;

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public List<Signer> getSigners() {
            if (this.signers == null) {
                this.signers = new LinkedList<Signer>();
            }
            return this.signers;
        }

        public void setSigners(List<Signer> signers) {
            this.signers = signers;
        }

        public List<IdNameTypeConf> getRequestors() {
            if (this.requestors == null) {
                this.requestors = new LinkedList<IdNameTypeConf>();
            }
            return this.requestors;
        }

        public void setRequestors(List<IdNameTypeConf> requestors) {
            this.requestors = requestors;
        }

        public List<IdNameTypeConf> getPublishers() {
            if (this.publishers == null) {
                this.publishers = new LinkedList<IdNameTypeConf>();
            }
            return this.publishers;
        }

        public void setPublishers(List<IdNameTypeConf> publishers) {
            this.publishers = publishers;
        }

        public List<IdNameTypeConf> getProfiles() {
            if (this.profiles == null) {
                this.profiles = new LinkedList<IdNameTypeConf>();
            }
            return this.profiles;
        }

        public void setProfiles(List<IdNameTypeConf> profiles) {
            this.profiles = profiles;
        }

        public List<Ca> getCas() {
            if (this.cas == null) {
                this.cas = new LinkedList<Ca>();
            }
            return this.cas;
        }

        public void setCas(List<Ca> cas) {
            this.cas = cas;
        }

        public List<Caalias> getCaaliases() {
            if (this.caaliases == null) {
                this.caaliases = new LinkedList<Caalias>();
            }
            return this.caaliases;
        }

        public void setCaaliases(List<Caalias> caaliases) {
            this.caaliases = caaliases;
        }

        public List<User> getUsers() {
            if (this.users == null) {
                this.users = new LinkedList<User>();
            }
            return this.users;
        }

        public void setUsers(List<User> users) {
            this.users = users;
        }

        public List<CaHasRequestor> getCaHasRequestors() {
            if (this.caHasRequestors == null) {
                this.caHasRequestors = new LinkedList<CaHasRequestor>();
            }
            return this.caHasRequestors;
        }

        public void setCaHasRequestors(List<CaHasRequestor> caHasRequestors) {
            this.caHasRequestors = caHasRequestors;
        }

        public List<CaHasPublisher> getCaHasPublishers() {
            if (this.caHasPublishers == null) {
                this.caHasPublishers = new LinkedList<CaHasPublisher>();
            }
            return this.caHasPublishers;
        }

        public void setCaHasPublishers(List<CaHasPublisher> caHasPublishers) {
            this.caHasPublishers = caHasPublishers;
        }

        public List<CaHasProfile> getCaHasProfiles() {
            if (this.caHasProfiles == null) {
                this.caHasProfiles = new LinkedList<CaHasProfile>();
            }
            return this.caHasProfiles;
        }

        public void setCaHasProfiles(List<CaHasProfile> caHasProfiles) {
            this.caHasProfiles = caHasProfiles;
        }

        public List<CaHasUser> getCaHasUsers() {
            if (this.caHasUsers == null) {
                this.caHasUsers = new LinkedList<CaHasUser>();
            }
            return this.caHasUsers;
        }

        public void setCaHasUsers(List<CaHasUser> caHasUsers) {
            this.caHasUsers = caHasUsers;
        }

        public void validate() throws InvalidConfException {
            Caconf.validate(this.signers);
            Caconf.validate(this.requestors);
            Caconf.validate(this.publishers);
            Caconf.validate(this.profiles);
            Caconf.validate(this.cas);
            Caconf.validate(this.caaliases);
            Caconf.validate(this.users);
            Caconf.validate(this.caHasRequestors);
            Caconf.validate(this.caHasPublishers);
            Caconf.validate(this.caHasProfiles);
        }
    }

    public static class Caalias
    extends ValidatableConf {
        private int caId;
        private String name;

        public int getCaId() {
            return this.caId;
        }

        public void setCaId(int caId) {
            this.caId = caId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            Caalias.notEmpty((String)this.name, (String)"name");
        }
    }

    public static class Ca
    extends ValidatableConf {
        private int id;
        private String name;
        private int snSize;
        private long nextCrlNo;
        private String status;
        private String caUris;
        private String maxValidity;
        private FileOrBinary cert;
        private FileOrValue certchain;
        private String signerType;
        private FileOrValue signerConf;
        private String crlSignerName;
        private String cmpResponderName;
        private String scepResponderName;
        private String cmpControl;
        private String scepControl;
        private String crlControl;
        private String ctlogControl;
        private String dhpocControl;
        private String revokeSuspendedControl;
        private int duplicateKey;
        private int duplicateSubject;
        private String protocolSupport;
        private int saveReq;
        private int permission;
        private int numCrls;
        private int expirationPeriod;
        private int keepExpiredCertDays;
        private String revInfo;
        private String validityMode;
        private String extraControl;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSnSize() {
            return this.snSize;
        }

        public void setSnSize(int snSize) {
            this.snSize = snSize;
        }

        public long getNextCrlNo() {
            return this.nextCrlNo;
        }

        public void setNextCrlNo(long nextCrlNo) {
            this.nextCrlNo = nextCrlNo;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getCaUris() {
            return this.caUris;
        }

        public void setCaUris(String caUris) {
            this.caUris = caUris;
        }

        public String getMaxValidity() {
            return this.maxValidity;
        }

        public void setMaxValidity(String maxValidity) {
            this.maxValidity = maxValidity;
        }

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public FileOrValue getCertchain() {
            return this.certchain;
        }

        public void setCertchain(FileOrValue certchain) {
            this.certchain = certchain;
        }

        public String getSignerType() {
            return this.signerType;
        }

        public void setSignerType(String signerType) {
            this.signerType = signerType;
        }

        public FileOrValue getSignerConf() {
            return this.signerConf;
        }

        public void setSignerConf(FileOrValue signerConf) {
            this.signerConf = signerConf;
        }

        public String getCrlSignerName() {
            return this.crlSignerName;
        }

        public void setCrlSignerName(String crlSignerName) {
            this.crlSignerName = crlSignerName;
        }

        public String getCmpResponderName() {
            return this.cmpResponderName;
        }

        public void setCmpResponderName(String cmpResponderName) {
            this.cmpResponderName = cmpResponderName;
        }

        public String getScepResponderName() {
            return this.scepResponderName;
        }

        public void setScepResponderName(String scepResponderName) {
            this.scepResponderName = scepResponderName;
        }

        public String getCmpControl() {
            return this.cmpControl;
        }

        public void setCmpControl(String cmpControl) {
            this.cmpControl = cmpControl;
        }

        public String getScepControl() {
            return this.scepControl;
        }

        public void setScepControl(String scepControl) {
            this.scepControl = scepControl;
        }

        public String getCrlControl() {
            return this.crlControl;
        }

        public void setCrlControl(String crlControl) {
            this.crlControl = crlControl;
        }

        public String getCtlogControl() {
            return this.ctlogControl;
        }

        public void setCtlogControl(String ctlogControl) {
            this.ctlogControl = ctlogControl;
        }

        public String getRevokeSuspendedControl() {
            return this.revokeSuspendedControl;
        }

        public void setRevokeSuspendedControl(String revokeSuspendedControl) {
            this.revokeSuspendedControl = revokeSuspendedControl;
        }

        public String getDhpocControl() {
            return this.dhpocControl;
        }

        public void setDhpocControl(String dhpocControl) {
            this.dhpocControl = dhpocControl;
        }

        public int getDuplicateKey() {
            return this.duplicateKey;
        }

        public void setDuplicateKey(int duplicateKey) {
            this.duplicateKey = duplicateKey;
        }

        public int getDuplicateSubject() {
            return this.duplicateSubject;
        }

        public void setDuplicateSubject(int duplicateSubject) {
            this.duplicateSubject = duplicateSubject;
        }

        public String getProtocolSupport() {
            return this.protocolSupport;
        }

        public void setProtocolSupport(String protocolSupport) {
            this.protocolSupport = protocolSupport;
        }

        public int getSaveReq() {
            return this.saveReq;
        }

        public void setSaveReq(int saveReq) {
            this.saveReq = saveReq;
        }

        public int getPermission() {
            return this.permission;
        }

        public void setPermission(int permission) {
            this.permission = permission;
        }

        public int getNumCrls() {
            return this.numCrls;
        }

        public void setNumCrls(int numCrls) {
            this.numCrls = numCrls;
        }

        public int getExpirationPeriod() {
            return this.expirationPeriod;
        }

        public void setExpirationPeriod(int expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        public int getKeepExpiredCertDays() {
            return this.keepExpiredCertDays;
        }

        public void setKeepExpiredCertDays(int keepExpiredCertDays) {
            this.keepExpiredCertDays = keepExpiredCertDays;
        }

        public String getRevInfo() {
            return this.revInfo;
        }

        public void setRevInfo(String revInfo) {
            this.revInfo = revInfo;
        }

        public String getValidityMode() {
            return this.validityMode;
        }

        public void setValidityMode(String validityMode) {
            this.validityMode = validityMode;
        }

        public String getExtraControl() {
            return this.extraControl;
        }

        public void setExtraControl(String extraControl) {
            this.extraControl = extraControl;
        }

        public void validate() throws InvalidConfException {
            Ca.notEmpty((String)this.name, (String)"name");
            Ca.notEmpty((String)this.status, (String)"status");
            Ca.notEmpty((String)this.maxValidity, (String)"maxValidity");
            Ca.notNull((Object)this.cert, (String)"cert");
            this.cert.validate();
            Ca.notEmpty((String)this.signerType, (String)"signerType");
            Ca.notNull((Object)this.signerConf, (String)"signerConf");
            this.signerConf.validate();
            Ca.notEmpty((String)this.protocolSupport, (String)"protocolSupport");
        }
    }
}

