/*
 *
 * Copyright (c) 2013 - 2020 Lijun Liao
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.xipki.ca.mgmt.db.diffdb;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;

import org.xipki.util.Args;

/**
 * Container of the map of serial number to digest value of certificates.
 *
 * @author Lijun Liao
 * @since 2.0.0
 */

class CertsBundle {

  private Map<BigInteger, DigestEntry> certs;

  private List<BigInteger> serialNumbers;

  public CertsBundle(Map<BigInteger, DigestEntry> certs, List<BigInteger> serialNumbers) {
    this.certs = Args.notEmpty(certs, "certs");
    this.serialNumbers = Args.notEmpty(serialNumbers, "serialNumbers");
  }

  public Map<BigInteger, DigestEntry> getCerts() {
    return certs;
  }

  public List<BigInteger> getSerialNumbers() {
    return serialNumbers;
  }

}
