/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.util.IoUtil;

public abstract class DbWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DbWorker.class);
    protected final AtomicBoolean stopMe = new AtomicBoolean(false);
    protected final DataSourceWrapper datasource;
    private Exception exception;

    public DbWorker(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile) throws PasswordResolverException, IOException {
        Properties props = DbPorter.getDbConfProperties(Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)dbConfFile), new String[0]), new OpenOption[0]));
        this.datasource = datasourceFactory.createDataSource("ds-" + dbConfFile, props, passwordResolver);
    }

    public final Exception exception() {
        return this.exception;
    }

    public void setStopMe(boolean stopMe) {
        this.stopMe.set(stopMe);
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Exception ex) {
            LOG.error("exception thrown", (Throwable)ex);
            this.exception = ex;
        }
    }

    protected abstract void run0() throws Exception;
}

