/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.diffdb;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

class DigestEntry {
    private final BigInteger serialNumber;
    private final boolean revoked;
    private final Integer revReason;
    private final Long revTime;
    private final Long revInvTime;
    private final String base64HashValue;

    public DigestEntry(BigInteger serialNumber, boolean revoked, Integer revReason, Long revTime, Long revInvTime, String base64HashValue) {
        this.base64HashValue = (String)Args.notNull((Object)base64HashValue, (String)"base64HashValue");
        this.serialNumber = serialNumber;
        this.revoked = revoked;
        this.revReason = revoked ? (Integer)Args.notNull((Object)revReason, (String)"revReason") : null;
        this.revTime = revoked ? (Long)Args.notNull((Object)revTime, (String)"revTime") : null;
        this.revInvTime = revInvTime;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public int getRevReason() {
        return this.revReason;
    }

    public Long getRevTime() {
        return this.revTime;
    }

    public Long getRevInvTime() {
        return this.revInvTime;
    }

    public String getBase64HashValue() {
        return this.base64HashValue;
    }

    public String toString() {
        return this.encoded();
    }

    public String encodedOmitSeriaNumber() {
        return this.encoded(false);
    }

    public String encoded() {
        return this.encoded(true);
    }

    private String encoded(boolean withSerialNumber) {
        return StringUtil.concatObjects((Object)(withSerialNumber ? this.serialNumber.toString(16) + ";" : ""), (Object[])new Object[]{this.base64HashValue, ";", this.revoked ? "1" : "0", ";", this.revReason != null ? this.revReason : "", ";", this.revTime != null ? this.revTime : "", ";", this.revInvTime != null ? this.revInvTime : ""});
    }

    public boolean contentEquals(DigestEntry obj) {
        return obj != null && this.serialNumber.equals(obj.serialNumber) && this.revoked == obj.revoked && DigestEntry.equals(this.revReason, obj.revReason) && DigestEntry.equals(this.revTime, obj.revTime) && DigestEntry.equals(this.revInvTime, obj.revInvTime) && DigestEntry.equals(this.base64HashValue, obj.base64HashValue);
    }

    public static DigestEntry decode(String encoded) {
        List<Integer> indexes = DigestEntry.getIndexes((String)Args.notNull((Object)encoded, (String)"encoded"));
        if (indexes.size() != 5) {
            throw new IllegalArgumentException("invalid DbDigestEntry: " + encoded);
        }
        int idx = 0;
        String str = encoded.substring(0, indexes.get(idx));
        BigInteger serialNumber = new BigInteger(str, 16);
        String sha1Fp = encoded.substring(indexes.get(idx) + 1, indexes.get(++idx));
        str = encoded.substring(indexes.get(idx) + 1, indexes.get(++idx));
        boolean revoked = !"0".equals(str);
        Integer revReason = null;
        Long revTime = null;
        Long revInvTime = null;
        if (revoked) {
            str = encoded.substring(indexes.get(idx) + 1, indexes.get(++idx));
            revReason = Integer.parseInt(str);
            str = encoded.substring(indexes.get(idx) + 1, indexes.get(++idx));
            revTime = Long.parseLong(str);
            str = encoded.substring(indexes.get(idx) + 1);
            if (str.length() != 0) {
                revInvTime = Long.parseLong(str);
            }
        }
        return new DigestEntry(serialNumber, revoked, revReason, revTime, revInvTime, sha1Fp);
    }

    private static List<Integer> getIndexes(String encoded) {
        ArrayList<Integer> ret = new ArrayList<Integer>(6);
        for (int i = 0; i < encoded.length(); ++i) {
            if (encoded.charAt(i) != ';') continue;
            ret.add(i);
        }
        return ret;
    }

    private static boolean equals(Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }
}

